function initialisePage() {
	var enabledButtons = ["Back","Forward","Refresh","Print","Calendar","Internet","Home","Help","NewWindow"];
	dateSelector();
	initTop();
	enableButtons(enabledButtons);
	
	// Set details for print header
	id("user").innerHTML = FirstName + " " + LastName;
	id("server").innerHTML = Domain;
	
	if(id('filters').className == 'expand') {
		id("fromDay").focus();
	}
	
	// Set date fields
	populateDateFields("fromYear", _fromY, "fromMonth", _fromM, "fromDay", _fromD);
	populateDateFields("toYear", _toY, "toMonth", _toM, "toDay", _toD);

	id("genDate").innerHTML = genDateVal;
 
	colRegenerate();
	loadP("RateSheetScroll");
}

var colRowSelected = false;

function colRow(cObjId,cId,cLabel,cSelected) {
	var row = id(cObjId).insertRow(-1);
	row.tableName = cObjId;
	row.colId = cId;
	row.onmouseover = function() {
		this.style.backgroundColor = "#cfc";
	}
	row.onmouseout = function() {
		if(colRowSelected == this) {
			this.style.backgroundColor = "#31ff63";
		} else {
			this.style.backgroundColor = "";
		}
	}
	row.onclick = function(e,force) {
		if(colRowSelected != this || (colRowSelected == this && force) ) {
			if(colRowSelected) {
				colRowSelected.style.backgroundColor = "";
				colRowSelected.firstChild.style.fontWeight = "";
			}
			colRowSelected = this;
			this.firstChild.style.fontWeight = "bold";
			if(this.style.backgroundColor == "") {
				this.style.backgroundColor = "#31ff63";
			}
			if(this.tableName == "tblInactiveCol") {
				id("btnColAdd").disabled = false;
				id("btnColRemove").disabled = true;
				id("btnColUp").disabled = true;
				id("btnColDown").disabled = true;
			} else {
				id("btnColAdd").disabled = true;
				id("btnColRemove").disabled = false;
				id("btnColUp").disabled = false;
				id("btnColDown").disabled = false;
			}
		} else {
			colRowSelected = false;
			this.firstChild.style.fontWeight = "";
			id("btnColAdd").disabled = true;
			id("btnColRemove").disabled = true;
			id("btnColUp").disabled = true;
			id("btnColDown").disabled = true;
		}
	}

	// name
	var cell = row.insertCell(-1);
	cell.innerHTML = cLabel;
	cell.className = "imgLink";
	cell.style.width = "100px";
	if(cObjId == "tblInactiveCol") {
		cell.style.whiteSpace = "nowrap";
	}


	var cIdIndex;
	for(var count=0; count < colData.length; count++) {
		if(colData[count].id == cId) {
			cIdIndex = count;
		}
	}	
	if(cObjId == "tblActiveCol") {
		// label
		cell = row.insertCell(-1);
		cell.style.width = "100px";
		cell.innerHTML = "<input type=\"text\" id=\"col_label_" + cId + "\" style=\"width:98px;\" value=\""+colData[cIdIndex].label+"\"/>";

		// width
		cell = row.insertCell(-1);
		cell.style.width = "40px";
		cell.innerHTML = "<input type=\"text\" id=\"col_width_" + cId + "\" style=\"width:38px;\" value=\""+colData[cIdIndex].width+"\"/>";

		cell = row.insertCell(-1);
		cell.style.width = "80px";
		cell.innerHTML = "<select id=\"col_sort_" + cId + "\" style=\"width:40px;\">"+colSortOptions+"</select><select id=\"col_sort_direction_" + cId + "\" style=\"width:38px;\"><option value=\"a\">Asc</option><option value=\"d\">Desc</option></select>";

		if(colData[cIdIndex].sort != "") {
			id("col_sort_" + cId).selectedIndex = parseInt(colData[cIdIndex].sort,10);
		}

		if(colData[cIdIndex].direction == "d") {
			id("col_sort_direction_" + cId).selectedIndex = 1;
		}

//		cell = row.insertCell(-1);
//		cell.innerHTML = "<input type=\"text\" id=\"col_header_" + cId + "\" style=\"width:100px\" value=\""+colData[cIdIndex].header+"\"/>";

		cell = row.insertCell(-1);
		cell.innerHTML = "<select id=\"col_align_" + cId + "\" style=\"width:44px\"><option value=\"l\">Left</option><option value=\"c\">Centre</option><option value=\"r\">Right</option></select>";

		var align = colData[cIdIndex].align;
		if(align == "c") {
			id("col_align_"+cId).selectedIndex = 1;
		} 
		if(align == "r") {
			id("col_align_"+cId).selectedIndex = 2;
		} 
	}
	
	if(cSelected) {
		colRowSelected = row;
		row.onclick(false,true);
	}
	
}

var colSortOptions = "";
function colRegenerate() {
	if(colRowSelected != false) {
		var colRowSelectedId = colRowSelected.colId;
	}
	emptyTable("tblInactiveCol");
	emptyTable("tblActiveCol");

	var colSort = [];
	var sortCount = 1;
	colSortOptions = "<option value=\"\"></option>";
	for(var count=0; count < colData.length; count++) {
		colSortOptions += "<option value=\"" + sortCount.toString() + "\">" + sortCount.toString() + "</option>";
		sortCount++;
	}
	for(var count=0; count < colData.length; count++) {
		if(colData[count].active != "1" && colData[count].disabled != "1") {
			var selected = false;
			if(colData[count].id == colRowSelectedId) {
				selected = true;
			}
			colRow("tblInactiveCol",colData[count].id,colData[count].name,selected);
		} else {
			colSort[colData[count].order] = count;
		}
	}

	for(var count=1; count < colSort.length; count++) {
		if (colData[colSort[count]].disabled != "1"){
			var selected = false;
			if(colData[colSort[count]].id == colRowSelectedId) {
				selected = true;
			}
			colRow("tblActiveCol",colData[colSort[count]].id,colData[colSort[count]].name,selected);
		}
	}
}

function colOrderArray() {
	var colOrder = [];
	for(var count=0; count < colData.length; count++) {
		if(colData[count].active == "1") {
			colOrder[colData[count].order] = count;
		} else {
			colData[count].order = 0;
		}
	}

	var newColOrder = [];

	for(var count=1; count < colOrder.length; count++) {
		var key = colOrder[count];
		if(colData[key]) {
			newColOrder[newColOrder.length] = key;
		}
	}
	return newColOrder;
}

function colNormaliseOrder() {
	var colOrder = colOrderArray();

	var orderCount = 1;
	for(var count=0; count < colOrder.length; count++) {
		colData[colOrder[count]].order = orderCount;
		orderCount++;
	}
}

function colAdd() {
	if(!colRowSelected) { return false; }

	var maxOrder = 0;
	for(var count=0; count < colData.length; count++) {
		if(parseInt(colData[count].order,10) > parseInt(maxOrder,10)) maxOrder = colData[count].order;	
	}
	maxOrder++;
	for(var count=0; count < colData.length; count++) {
		if(colRowSelected.colId == colData[count].id) {
			colData[count].active = "1";
			colData[count].order = maxOrder;
		}
	}	

	colNormaliseOrder();
	colRegenerate();
}

function colRemove() {
	if(!colRowSelected) { return false; }

	for(var count=0; count < colData.length; count++) {
		if(colRowSelected.colId == colData[count].id) {
			colData[count].active = "0";
		}
	}	
	colNormaliseOrder();
	colRegenerate();
}

function colSwapOrder(key1, key2) {
	var temp = colData[key1].order;
	colData[key1].order = colData[key2].order;
	colData[key2].order = temp;
}

function colMove(direction) {
	if(!colRowSelected) { return false; }

	var colOrder = colOrderArray();
	var colFirst = colOrder[0];
	
	for(var count=0; count < colOrder.length; count++) {
		var key = colOrder[count];
		if(colRowSelected.colId == colData[key].id) {
			if(!direction) {
				if(count != 0) {
					colSwapOrder(key,colOrder[count-1]);
				}
			} else {
				if(count < colOrder.length-1) {
					colSwapOrder(key,colOrder[count+1]);
				}
			}
		}
	}

	colNormaliseOrder();
	colRegenerate();
}

function colUp() {
	colMove();
}

function colDown() {
	colMove(true);
}

function emptyTable(objId) {
	var obj = id(objId);
	for(var count=obj.rows.length-1;count > -1; count--) {
		obj.deleteRow(count);
	}
}

function processForm() {
	url = buildURL();
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function buildURL(renderOption) {
	_urlCount++;

	var fromDate = buildDate("from");
	if(!fromDate) { return false; }
	var toDate = buildDate("to");
	if(!toDate) { return false; }
	if(buildDate("from") > buildDate("to") ) {
		id("toDay").focus();
		openMessage("Please enter a To date that is greater than or equal to the From date","a",120);
		return false;
	}

	var cols = buildCols();

	var url = ["reservation.php?2002",
		/*  1 */ id("accommIds").value,
		/*  2 */ id("ratePeriodIds").value,
		/*  3 */ id("rateIds").value,
		/*  4 */ id("page").value,
		/*  5 */ id("dateRangeOptVal").value,
		/*  6 */ fromDate,
		/*  7 */ toDate,
		/*  8 */ id("reportDetailComponents").checked?"1":"0",				
		/*  9 */ id("reportDetailCompSplits").checked?"1":"0",
		/* 10 */ id("reportDetailAmounts").checked?"1":"0",
		/* 11 */ id("rateComponentIds").value,	
		/* 12 */ id("compOptionalNo").checked?"1":"0",				
		/* 13 */ id("compOptionalYes").checked?"1":"0",
		/* 14 */ id("compCommissionNC").checked?"1":"0",
		/* 15 */ id("compCommissionC").checked?"1":"0",
		/* 16 */ id("compCommissionCD").checked?"1":"0",
		/* 17 */ id("compCommissionCDA").checked?"1":"0",
		/* 18 */ id("compFrequencyPN").checked?"1":"0",		
		/* 19 */ id("compFrequencyPS").checked?"1":"0",		
		/* 20 */ id("compSeparateNo").checked?"1":"0",				
		/* 21 */ id("compSeparateYes").checked?"1":"0",	
		/* 22 */ id("rateGroupSplitIds").value,			
		/* 23 */ id("rateGroupAmountIds").value,			
		/* 24 */ id("amountQtySelect").value,	
		/* 25 */ id("amountQty").value,	
		/* 26 */ id("taxRateIds").value,	
		/* 27 */ id("taxGroupIds").value,	
		/* 28 */ id("splitIgnoreZeros").checked?"1":"0"	,
		/* 29 */ cols,
		/* 30 */ renderOption

	];
    
	return url.join("+");		
}

function buildDate(prefix) {
	dayValue = id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue = id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue = dayValue<10?"0"+dayValue:dayValue;
	monthValue = monthValue<10?"0"+monthValue:monthValue;
	 
	resultDate = id(prefix+"Year").value+"-"+monthValue+"-"+dayValue;
      
	if(dayValue < 1) { 
		id(prefix+"Day").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(monthValue < 1) {
		id(prefix+"Month").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(id(prefix+"Year").value == "") {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;		 
	 }		 
	if(id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}

	return resultDate;
} 

function buildCols() {
	var cols = [];
	for(var count=0; count<colData.length; count++) {
		var cSort = colData[count].sort;
		var cDirection = colData[count].direction;
		var cWidth = colData[count].width;
		var cLabel = colData[count].label;
		//var cHeader = colData[count].header;
		var cHeader = "";
		var cAlign = colData[count].align;
		var cId = colData[count].id;
		if(colData[count].active == "1" && colData[count].disabled != "1") {
			cSort = selValue("col_sort_" + cId);
			cDirection = selValue("col_sort_direction_" + cId);
			cWidth = id("col_width_" + cId).value;
			cLabel = id("col_label_" + cId).value;
			//cHeader = id("col_header_" + cId).value;
			cHeader = "";
			cAlign = selValue("col_align_" + cId);
		}
		var col = [
			colData[count].active,
			colData[count].order,
			cSort,
			cDirection,
			cWidth,
			cLabel,
			cHeader,
			cAlign,
			cId
		]
		cols[cols.length] = col.join(",");
	}
	return cols.join(":");
}

function setDateRangeOpt(opt){
	id("dateRangeOptVal").value = opt;
	if (opt == "3"){
		id("dateRange").checked = true;
	}
}

function showComponents(){
	if (id("ComponentFilters").className == "expand"){
		id("ComponentFilters").className = "collapse printCollapse";
		id("reportDetailCompSplits").disabled = true;
		id("reportDetailCompSplits").checked = false;
	} else {
		id("ComponentFilters").className = "expand";
		id("reportDetailCompSplits").disabled = false;
	}
}

function showCompSplits(){
	if (id("CompSplitFilters").className == "expand"){
		id("CompSplitFilters").className = "collapse printCollapse";
	} else {
		id("CompSplitFilters").className = "expand";
	}
}

function showAmounts(){
	if (id("AmountFilters").className == "expand"){
		id("AmountFilters").className = "collapse printCollapse";
	} else {
		id("AmountFilters").className = "expand";
	}
}

function showHideFilters(){
  var filters 		= id("filters");
  var filterBut 	= id("filterBut");
	
	mnuInitialise = false;
	
  if ( filters.className == "collapse printCollapse" ) {
    filters.className = "expand";
    filterBut.innerHTML 	= "<< Hide Filters";
  } else {
    filters.className = "collapse printCollapse";
    filterBut.innerHTML 	= ">> Show Filters";
  }
}

function openPropFilter(filter) {
	var accomm = id("accommIds").value;
	openPopup("reservation.php?293+"+accomm,556,407);
}

function openFilter(filter){
	var selectedArray = id(filter + "Ids").value;

	url = "reservation.php?661+"
		+ filter
		+ "+"
		+ '';

	openPopup(url, 280, 360, false, false, false, false, false, false, false, false, ['rate', selectedArray]);
}

function setPage(page) {
	id("page").value = page;
	processForm();
}

function openPDF(){
	url = buildURL(1);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
}

function openCSV() {
	url = buildURL(4);
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openCSVGrid() {
	url = buildURL(12);
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openCSVGridRaw() {
	url = buildURL(14);
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function sendPDF(){
	url = buildURL(2);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin = openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",775,615,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function amtScroll(rateId) {
	id("compSplitDiv_"+rateId).scrollLeft = id("amtDiv_"+rateId).scrollLeft;
}

function compSplitScroll(rateId) {
	id("amtDiv_"+rateId).scrollLeft = id("compSplitDiv_"+rateId).scrollLeft;
}

function showExportMenu(e, flag) {
	closeOptGridDiv();
	if ( !e ) {
		e = window.event;
	}
	stopBubble(e);

	var posx = 0;
	var posy = 0;
	
	if (e.pageX || e.pageY) 	{
		posx = e.pageX;
		posy = e.pageY;
	} else if (e.clientX || e.clientY) 	{
		posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
		posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
	}
	
	if(flag == 1) {
		posy = posy-60;
	}

	id("exportOptionDiv").style.display	= "";
	id("exportOptionDiv").style.left = posx.toString()+"px";
	id("exportOptionDiv").style.top = posy.toString()+"px";
}

function showExportGridMenu(e, flag) {
	closeOptDiv();
	if ( !e ) {
		e = window.event;
	}
	stopBubble(e);

	var posx = 0;
	var posy = 0;
	
	if (e.pageX || e.pageY) 	{
		posx = e.pageX;
		posy = e.pageY;
	} else if (e.clientX || e.clientY) 	{
		posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
		posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
	}
	
	if(flag == 1) {
		posy = posy-60;
	}

	id("exportOptionGridDiv").style.display	= "";
	id("exportOptionGridDiv").style.left = posx.toString()+"px";
	id("exportOptionGridDiv").style.top = posy.toString()+"px";
}

function closeOptDiv() {
	id('exportOptionDiv').style.display = "none";
}

function closeOptGridDiv() {
	id('exportOptionGridDiv').style.display = "none";
}

function closeOptGridRawDiv() {
	id('exportOptionGridDiv').style.display = "none";
}

function printReport() {
	window.print();
}

function openOffice() {
	url = buildURL(7);

	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openOfficeGrid() {
	url = buildURL(13);
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function sendCSV(){
	url = buildURL(2);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",595,424,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function selectAllRates() {
	var inputs = document.getElementsByTagName("INPUT");
	if(id("allSelected").value == "0"){
		state = true;
		id("allSelected").value = "1";
	} else {
		state = false;
		id("allSelected").value = "0";
	}
	
	for ( var i = 0; i < inputs.length; i++ ) {
		if ( inputs[i].getAttribute("type") == "checkbox" && inputs[i].getAttribute("id").substring(0, 4) == "tick" && inputs[i].checked != state) {
			inputs[i].checked = state;
		}
	}

	checkCanDuplicate();
}

////////////////////////////////
// Script from http://blog.crondesign.com/2009/09/scrollfix-remember-scroll-position-when.html
// fixscroll.js:
// call loadP and unloadP when body loads/unloads and scroll position will not move
function getScrollXY() {
    var x = 0, y = 0;
    if( typeof( window.pageYOffset ) == 'number' ) {
        // Netscape
        x = window.pageXOffset;
        y = window.pageYOffset;
    } else if( document.body && ( document.body.scrollLeft || document.body.scrollTop ) ) {
        // DOM
        x = document.body.scrollLeft;
        y = document.body.scrollTop;
    } else if( document.documentElement && ( document.documentElement.scrollLeft || document.documentElement.scrollTop ) ) {
        // IE6 standards compliant mode
        x = document.documentElement.scrollLeft;
        y = document.documentElement.scrollTop;
    }
    return [x, y];
}
           
function setScrollXY(x, y) {
    window.scrollTo(x, y);
}
function createCookie(name,value,days) {
	if (days) {
		var date = new Date();
		date.setTime(date.getTime()+(days*24*60*60*1000));
		var expires = "; expires="+date.toGMTString();
	}
	else var expires = "";
	document.cookie = name+"="+value+expires+"; path=/";
}

function readCookie(name) {
	var nameEQ = name + "=";
	var ca = document.cookie.split(';');
	for(var i=0;i < ca.length;i++) {
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
	}
	return null;
}

function eraseCookie(name) {
	createCookie(name,"",-1);
}

function loadP(pageref){
	x=readCookie(pageref+'x');
	y=readCookie(pageref+'y');
	setScrollXY(x,y)
}
function unloadP(pageref){
	s=getScrollXY()
	createCookie(pageref+'x',s[0],0.1);
	createCookie(pageref+'y',s[1],0.1);
}

function clearP(pageref){
	eraseCookie(pageref+'x');
	eraseCookie(pageref+'y');
}

function checkCanDuplicate(){
	ratesSelected = false;
	$("input").each(function(index) {
		if ($(this).prop("id").substring(0, 4) == "tick") //check logic there
		{
			if ($(this).prop('checked')){
				ratesSelected = true;
			}
		}
	});	
	if (ratesSelected){
		$("#btnDuplicate").prop("disabled", false);
	} else {
		$("#btnDuplicate").prop("disabled", true);
	}
}

function showRateEditDatePopup(record) {
	url = "reservation.php?784+"+record+"++++1";
	openPopup(url,600,300);
}