function initialisePage() {
	dateSelector();
	initTop();
	enableButtons(enabledButtons);

	populateDateFields("fromYear", _fromY, "fromMonth", _fromM, "fromDay", _fromD);
	populateDateFields("toYear", _toY, "toMonth", _toM, "toDay", _toD);

	dateTypeChange();
}

function openFilter(filter){
	var selectedArray = id(filter + "Ids").value;

	url = "reservation.php?661+"
		+ filter
		+ "+"
		+ selectedArray;    
         
	openPopup(url,280,360);                          
}

function buildDate(prefix) {
	dayValue = id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue = id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue = dayValue<10?"0"+dayValue:dayValue;
	monthValue = monthValue<10?"0"+monthValue:monthValue;
	 
	resultDate = id(prefix+"Year").value+"-"+monthValue+"-"+dayValue;
      
	if(dayValue < 1) { 
		id(prefix+"Day").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(monthValue < 1) {
		id(prefix+"Month").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(id(prefix+"Year").value == "") {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;		 
	 }		 
	if(id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}

	return resultDate;
}  

function buildOptions(bName) {
	var list = document.getElementsByName(bName +"Check");
	var chosen = [];
	for(var count = 0; count < list.length; count++) {
		if(list[count].checked) {
			chosen.push(list[count].id.toString().replace(bName,""));
		}
	}
	return chosen.join(":");
}

function getDateType() {
	if(id("dateTypeToday").checked) {
		return "1";
	}
	if(id("dateTypeDayCount").checked) {
		return "2";
	}
	return "3";
}

function getExtraOption() {
	if(id("extraShowAll").checked) {
		return "1";
	} else if(id("extraShowProp").checked) {
		return "2";
	} else {
		return "3";
	}
}

function getNoteSort() {
	if(id("noteSortArrive").checked) {
		return "1";
	} else if(id("noteSortDepart").checked) {
		return "2";
	} else if(id("noteSortId").checked) {
		return "3";
	} else {
		return "4";
	}
}

function buildURL(renderOption) {
	renderOption &= 7;
	_urlCount++;

	var dateType = getDateType();
	var dayCount = id("dayCount").value;
	var fromDate = "";
	var toDaye = "";
	if(dateType == "3") { 
		var fromDate = buildDate("from");
		if(!fromDate) { return false; }
		var toDate = buildDate("to");
		if(!toDate) { return false; }
		if(buildDate("from") > buildDate("to") ) {
			id("toDay").focus();
			openMessage("Please enter a To date that is greater than or equal to the From date","a",120);
			return false;
		}

	}

	var roomShow = buildOptions("Room");
	var departShow = buildOptions("Depart");
	var colourShow = buildOptions("Colour");
	var legendShow = buildOptions("Legend");
	var noteShow = buildOptions("Note");
	if(roomShow == "") {
		roomShow = "1"
	}

	setExtrasIds();
	var url = [
		/*  0 */ "reservation.php?292",
		/*  1 */ dateType,
		/*  2 */ dayCount,
		/*  3 */ fromDate,
		/*  4 */ toDate,
		/*  5 */ id("accommIds").value,
		/*  6 */ id("statusRoomIds").value, // status filter goes here
		/*  7 */ id("extraFilterTypeCategory").checked?"1":"2",
		/*  8 */ id("extrasIds").value,
		/*  9 */ id("extraCategoryIds").value,
		/* 10 */ getExtraOption(),
		/* 11 */ id("directionRoom").checked?"1":"2",
		/* 12 */ id("roomSortNumber").checked?"1":"2",
		/* 13 */ id("autoRoom").checked?"1":"2",
		/* 14 */ id("showChart").checked?"1":"2",
		/* 15 */ id("showNotes").checked?"1":"2",
		/* 16 */ id("showAccomm").checked?"1":"2",
		/* 17 */ id("showPAX").checked?"1":"2",
		/* 18 */ id("showLegend").checked?"1":"2",
		/* 19 */ id("showUnitLabel").checked?"1":"2",
		/* 20 */ id("showUnitNumber").checked?"1":"2",
		/* 21 */ id("showDatePAX").checked?"1":"2",
		/* 22 */ roomShow,
		/* 23 */ departShow,
		/* 24 */ colourShow,
		/* 25 */ legendShow,
		/* 26 */ noteShow,
		/* 27 */ getNoteSort(),
		/* 28 */ id("noteDateReservation").checked?"1":"2",
		/* 29 */ renderOption,
		/* 30 */ _randomId + "_" + _urlCount.toString(),
		/* 31 */ id("pdfColor").value,
		/* 32 */ id("showCatExtras").checked?"1":"2",
		/* 33 */ id("componentsIds").value,	
	];
   
	return url.join("+");
}

function generateReport() {
	if(id("showChart").checked==false && (id("showNotes").checked==true && id("autoRoom").checked==false)) {
		openMessage("Please select Auto-allocate rooms option.");
			return false;
	}
	url = buildURL();
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openCSV() {
	url = buildURL(4);
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openPDF(){
	url = buildURL(1);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
}

function sendPDF(){
	url = buildURL(2);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",775,615,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function select_daymonth_changed(){
	setDayList(id("fromDay"),id("fromMonth").options[id("fromMonth").selectedIndex].value,id("fromYear").value);
	setDayList(id("toDay"),id("toMonth").options[id("toMonth").selectedIndex].value,id("toYear").value);
}

function showHideFilters(){
	var filters = id("filters");
	var filterBut = id("filterBut");
	
	mnuInitialise = false;
	
	if( filters.className == "collapse printCollapse" ) {
		filters.className = "expand";
		filterBut.value 	= "<< Hide Filters";
	} else {
		filters.className = "collapse printCollapse";
		filterBut.value 	= ">> Show Filters";
	}
}

function dateTypeChange() {
	if (!id("dateTypeRange").checked ) {
		populateDateFields("fromYear", "", "fromMonth", 0, "fromDay", 0);
		populateDateFields("toYear", "", "toMonth", 0, "toDay", 0);
	} else {
		populateDateFields("fromYear", _fromY, "fromMonth", _fromM, "fromDay", _fromD);
		populateDateFields("toYear", _toY, "toMonth", _toM, "toDay", _toD);
	}
	return true;
}

function toggleCollapse(objId) {
	if(id(objId).className == "") {
		id(objId).className = "collapse printCollapse";
	} else {
		id(objId).className = "";
	}
}

function setExtrasIds() {
	list = document.getElementsByName("extraIds");
	last = [];
	if(list.length > 0) {
		for(count=0; count<list.length; count++) {
			tmp = list[count].value.toString().split(":");
			for(count2=0;count2<tmp.length; count2++) {
				last[last.length] = tmp[count2];
			}
		}
		id("extrasIds").value = last.join(":");
	} else {
		id("extrasIds").value = "";
	}	
}

function removeExtraIds(rCatId) {
	id("extra_"+rCatId).parentNode.removeChild(id("extra_"+rCatId));
	id("extraIds_"+rCatId).parentNode.removeChild(id("extraIds_"+rCatId));
	if(document.getElementsByName("extraIds").length === 0) {
		id("extraAll").className = "";
	} else {
		id("extraAll").className = "collapse";
	}
}

function openPropFilter() {
	var accomm = id("accommIds").value;
	openPopup("reservation.php?293+"+accomm,556,407);
}

function openOptReqFilter() {
	var accomm = id("accommIds").value;
	openPopup("reservation.php?661+components+"+accomm,556,407);
}

function printReport() {
	window.print();
}

function openOffice() {
	url = buildURL(7);
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function showExportMenu(e, flag) {
	if ( !e ) {
		e = window.event;
	}
	stopBubble(e);

	var posx = 0;
	var posy = 0;
	
	if (e.pageX || e.pageY) 	{
		posx = e.pageX;
		posy = e.pageY;
	} else if (e.clientX || e.clientY) 	{
		posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
		posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
	}

	if(flag == 1) {
		posy = posy-60;
	}

	id("exportOptionDiv").style.display	= "";
	id("exportOptionDiv").style.left = posx;
	id("exportOptionDiv").style.top = posy;
}

function closeOptDiv() {
	id('exportOptionDiv').style.display = "none";

}
