function initialisePage(){
	dateSelector();
	initTop();
	enableButtons(enabledButtons);

	id("user").innerHTML = FirstName + " " + LastName;
	id("server").innerHTML = Domain;
	id("genDate").innerHTML = genDateVal;

	populateDateFields("fromYear", fromY, "fromMonth", fromM, "fromDay", fromD);
	populateDateFields("toYear", toY, "toMonth", toM, "toDay", toD);
	populateDateFields("statusDateFromYear", statusDateFromY, "statusDateFromMonth", statusDateFromM, "statusDateFromDay", statusDateFromD);
	populateDateFields("statusDateToYear", statusDateToY, "statusDateToMonth", statusDateToM, "statusDateToDay", statusDateToD);
	populateDateFields("createDateFromYear", createDateFromY, "createDateFromMonth", createDateFromM, "createDateFromDay", createDateFromD);
	populateDateFields("createDateToYear", createDateToY, "createDateToMonth", createDateToM, "createDateToDay", createDateToD);

	levelChange();

	showRevenueClick();

	statusDateToggle();
	createDateToggle();

	nightTypeToggle();

	checkShow(id("rateOverrideCheck"),"rateOverrideTable");
	checkShow(id("amountOverrideCheck"),"amountOverrideTable");
}

function buildDate(prefix) {
	dayValue		= id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue	= id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue		= dayValue < 10 ? "0" + dayValue:dayValue;
	monthValue	= monthValue < 10 ? "0" + monthValue:monthValue;

	resultDate	= id(prefix + "Year").value + "-" + monthValue + "-" + dayValue;

	if ( dayValue < 1 ) {
		id(prefix + "Day").focus();
		openMessage("Please enter a valid " + prefix + " date","a",100);
		return false;
	}

	if ( monthValue < 1 ) {
		id(prefix+"Month").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}

	if ( id(prefix+"Year").value == "" ) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}		 

	if ( id(prefix+"Year").value.search(/^\d{4}$/) == -1 ) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	return resultDate;
}

function buildURL(renderOption) {
	var testFromDate;
	var testToDate;
	var testFromMonth;
	var testToMonth;

	fromDate = buildDate("from");
	if(!fromDate) {
		return false;
	}
	toDate = buildDate("to");
	if(!toDate) {
		return false;
	}
	if(toDate < fromDate) {
		openMessage("Please enter a To date that is greater than or equal to the From date","a",120);
		return false;
	}
	
	statusFromDate = buildDate("statusDateFrom");
	statusToDate = buildDate("statusDateTo");
	if(statusToDate < statusFromDate) {
		openMessage("Please enter a Status To date that is greater than or equal to the Status From date","a",120);
		return false;
	}

	createFromDate = buildDate("createDateFrom");
	createToDate = buildDate("createDateTo");
	if(createToDate < createFromDate) {
		openMessage("Please enter a Create To date that is greater than or equal to the Create From date","a",120);
		return false;
	}
	
	if(renderOption == 0) {
		var filterStatus = "";
	} else {
		var filterStatus = id('filters').className;
	}
		
	var showHideButtonText = id('filterBut').value;

	renderOption &= 7;
	_urlCount++;

	var rateOverride = "0";
	if(id("rateOverrideCheck").checked) {
		rateOverride = "1";
	}
	if(id("rateOverrideExcludeRes").checked) {
		rateOverride += ":excludeRes";
	}
	if(id("rateOverrideIncludeRes").checked) {
		rateOverride += ":includeRes";
	}
	if(id("rateOverrideExcludeItem").checked) {
		rateOverride += ":excludeItem";
	}
	if(id("rateOverrideIncludeItem").checked) {
		rateOverride += ":includeItem";
	}
	if(id("rateOverrideAgentGranted").checked) {
		rateOverride += ":1";
	} else {
		rateOverride += ":0";
	}
	if(id("rateOverrideAgentDenied").checked) {
		rateOverride += ":1";
	} else {
		rateOverride += ":0";
	}

	var amountOverride = "0";
	if(id("amountOverrideCheck").checked) {
		amountOverride = "1";
	}
	if(id("amountOverrideExcludeRes").checked) {
		amountOverride += ":excludeRes";
	}
	if(id("amountOverrideIncludeRes").checked) {
		amountOverride += ":includeRes";
	}
	if(id("amountOverrideExcludeItem").checked) {
		amountOverride += ":excludeItem";
	}
	if(id("amountOverrideIncludeItem").checked) {
		amountOverride += ":includeItem";
	}
	
	var showRevenueOption = 0;
	if(id("showRevenue").checked) { showRevenueOption = 1; }

	var showRoomConfig = 0;
	if(id("showRoomConfig").checked) { showRoomConfig = 1; }

	var showTaxOption = 0;
	if(id("showTax").checked) { showTaxOption = 1; }

	var excludeTBAOption = 0;
	if(id("excludeTBA").checked) { excludeTBAOption = 1; }
	

	var url = [
		/*  0 */ "reservation.php?304",
		/*  1 */ fromDate,
		/*  2 */ toDate,
		/*  3 */ "", //id("propertiesIds").value,
		/*  4 */ id("accommIds").value,
		/*  5 */ (id("agentNameRadio").checked?"name":"country"),
		/*  6 */ id("agentIds").value,
		/*  7 */ id("agentCountryIds").value,
		/*  8 */ id("statusAllocIds").value,
		/*  9 */ id("consultantIds").value,
		/* 10 */ id("originatorIds").value,
		/* 11 */ id("sourceIds").value,
		/* 12 */ id("nationalityIds").value,
		/* 13 */ id("rateIds").value,
		/* 14 */ id("currenciesIds").value,
		/* 15 */ rateOverride,
		/* 16 */ amountOverride,
		/* 17 */ showRevenueOption,
		/* 18 */ showRoomConfig,
		/* 19 */ selValue("level1"),
		/* 20 */ selValue("level2"),
		/* 21 */ (id("byInvoice").checked?"invoice":"day"),
		/* 22 */ (id("commNett").checked?"nett":(id("commGross").checked?"gross":"payable")),
		/* 23 */ showTaxOption,
		/* 24 */ excludeTBAOption,
		/* 25 */ id("componentsIds").value,
		/* 26 */ sortBy,
		/* 27 */ renderOption,
		/* 28 */ _randomId + "_" + _urlCount.toString(),
		/* 29 */ filterStatus,
		/* 30 */ showHideButtonText,
		/* 31 */ (id("statusDateCheck").checked?"1":"0"),
		/* 32 */ selValue("statusDateType"),
		/* 33 */ statusFromDate,
		/* 34 */ statusToDate,
		/* 35 */ (id("totalOnlyCheck").checked?"1":"0"),
		/* 36 */ (id("includePayment").checked?"1":"0"),
		/* 37 */ (id("nightByBed").checked?"bed":"room"),
		/* 38 */ (id("roomUpgradeCheck").checked?"1":"0"),
		/* 39 */ (id("createDateCheck").checked?"1":"0"),
		/* 40 */ createFromDate,
		/* 41 */ createToDate
	];
	return url.join("+");
}

function generateReport(renderOption) {
	url = buildURL(renderOption);
	if(url) {
		id("urlForm").target = "_self";		
		id("urlForm").action = "";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openPDF() {
	url = buildURL(1);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		id("urlForm").action = "";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
}

function sendPDF() {
	url = buildURL(2);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		id("urlForm").action = "";
		pdfWin = openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",775,615,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
}

function openDetailPopup(urlArgs) {
	url = "reservation.php?305+" + urlArgs;
	if(url) {
		id("url").value = url;
		id("urlForm").action = "reservation.php?305";
		id("urlForm").target = "detailWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading details...",660,400,0,0,0,1,"detailWin","opener.id('urlForm').submit();");
	}	
}


function newSort(num) {
	sortBy = num;
	generateReport(0);
}

function dataScroll(div) {
	var currX;

	currX = id(div).scrollLeft;

	if(div != "mainScrollDiv") { id("mainScrollDiv").scrollLeft = currX; }
	if(div != "headerScrollDiv") { id("headerScrollDiv").scrollLeft = currX; }
	if(div != "revenueScrollDiv") { id("revenueScrollDiv").scrollLeft = currX; }
}

function showHideFilters(){
  var filters 		= id("filters");
  var filterBut 	= id("filterBut");
	
	mnuInitialise = false;
	
  if ( filters.className == "collapse printCollapse" ) {
    filters.className = "expand";
    filterBut.value 	= "<< Hide Filters";
  } else {
    filters.className = "collapse printCollapse";
    filterBut.value 	= ">> Show Filters";
  }
}

function rowOn(rowNum) {
	id("groupRow"+rowNum.toString()).style.backgroundColor = '#CCFFCC';
}

function rowOff(rowNum) {
	id("groupRow"+rowNum.toString()).style.backgroundColor = '';
}

function colOn(colNum) {
	id("groupCol"+colNum.toString()).style.backgroundColor = '#CCFFCC';
	id("revenueCol"+colNum.toString()).style.backgroundColor = '#CCFFCC';
}

function colOff(colNum) {
	id("groupCol"+colNum.toString()).style.backgroundColor = '';
	id("revenueCol"+colNum.toString()).style.backgroundColor = '';
}

function showTotalRoomNightsOverlib() {
	overlib("<span class='txtb'><span class='txtu txtb'>Formula:</span> All active rooms &times; number of days in the month</span><br><br><span class='txts'>A room is excluded in any results for a period prior to the creation of the room (e.g. if a new room is added in Jan 2005 it does not affect the potential bednight calculations for Dec 2004)<br>Note: prior to June 2005 the room creation date has not been stored this means that rooms on file prior to June 2005 will carry a creation date of 0 and will thus qualify for inclusion in reports for all periods<br>A room night or block is discounted if either the accommodation type or the room itself is inactive on that day/night<br>A room becomes available on its date of creation<br>A room becomes unavailable on the date that it, or its parent accommodation type, becomes inactive<br>A room becomes unavailable on the day that a block starts<br>A room becomes available ON the day that the block ends</span>",WIDTH,500);
}

function showBlockedRoomNightsOverlib() {
	overlib("<span class='txtb'><span class='txtu txtb'>Formula:</span> Number of active blocked rooms &times; blocked nights</span><br><br><span class='txts'>A room is excluded in any results for a period prior to the creation of the room (e.g. if a new room is added in Jan 2005 it does not affect the potential bednight calculations for Dec 2004)<br>Note: prior to June 2005 the room creation date has not been stored this means that rooms on file prior to June 2005 will carry a creation date of 0 and will thus qualify for inclusion in reports for all periods<br>A room night or block is discounted if either the accommodation type or the room itself is inactive on that day/night<br>A room becomes available on its date of creation<br>A room becomes unavailable on the date that it, or its parent accommodation type, becomes inactive<br>A room becomes unavailable on the day that a block starts<br>A room becomes available ON the day that the block ends</span>",WIDTH,500);
}

function showPotentialBedNightsOverlib() {
	overlib("<span class='txtb'><span class='txtu txtb'>Formula:</span> (Total room nights &minus; Blocked room nights) &times; room capacity</span>",WIDTH,380);
}

function showPercentOccupancyOverlib() {
	overlib("<span class='txtb'><span class='txtu txtb'>Formula:</span> Total occupied &divide; Potential bed nights &times; 100</span>",WIDTH,290);
}

function showYieldOverlib() {
	overlib("<span class='txtb'><span class='txtu txtb'>Formula:</span> (Row revenue) / (Row total bed nights)</span>",LEFT,WIDTH,290);
}

function showActualBedNightsOverlib() {
	overlib("<span class='txtb'><span class='txtu txtb'>Formula:</span> (Row total bed nights) / (Total occupied) &times; 100</span>",LEFT,WIDTH,320);
}

function showPotentialBedNightsColOverlib() {
	overlib("<span class='txtb'><span class='txtu txtb'>Formula:</span> (Row total bed nights) / (Potential bed nights) &times; 100</span>",LEFT,WIDTH,340);
}

function showActualRoomNightsOverlib() {
	overlib("<span class='txtb'><span class='txtu txtb'>Formula:</span> (Row total room nights) / (Total occupied) &times; 100</span>",LEFT,WIDTH,320);
}

function showPotentialRoomNightsColOverlib() {
	overlib("<span class='txtb'><span class='txtu txtb'>Formula:</span> (Row total room nights) / (Total room nights) &times; 100</span>",LEFT,WIDTH,340);
}

function showResOverlib() {
	overlib("<span class='txtb'><span class='txtu txtb'>Formula:</span> (Row res count) / (Total res count) &times; 100</span>",LEFT,WIDTH,280);
}

function openPropFilter() {
	var accomm = id("accommIds").value;
	openPopup("reservation.php?293+"+accomm,556,407);
}

function levelChange() {
	if(selValue("level1") == "all") {
		id("level2").selectedIndex = 0;
		id("level2").disabled = true;
	} else {
		id("level2").disabled = false;
	} 
	if(
		selValue("level1")=='accomm'
		|| selValue("level1")=='property' 
		|| selValue("level2")=='accomm' 
		|| selValue("level2")=='property'
	) {
		id("includePayment").checked = false;
		id("includePayment").disabled = true;
	} else {
		id("includePayment").disabled = false;
	}

	if(selValue("level1") == "accomm" || selValue("level2") == "accomm") {
		id("roomUpgradeRow").className = "expand";
	} else {
		id("roomUpgradeRow").className = "collapse printCollapse";
	}
}

function showRevenueClick() {
	if(id("showRevenue").checked) {
		id("revenueFilter").className = "";
	} else {
		id("revenueFilter").className = "collapse printCollapse";
		id("includePayment").checked = false;
	}
}

function statusDateToggle() {
	if(id("statusDateCheck").checked) {
		id("statusDateDetail").style.visibility = "";
	} else {
		id("statusDateDetail").style.visibility = "hidden";
	}
}

function createDateToggle() {
	if(id("createDateCheck").checked) {
		id("createDateDetail").style.visibility = "";
	} else {
		id("createDateDetail").style.visibility = "hidden";
	}
}


function nightTypeToggle() {
	if(id("nightByBed").checked) {
		id("showRoomConfigRow").className = "expand";
		id("showRoomConfigRow2").className = "expand";
	} else {
		id("showRoomConfigRow").className = "collapse";
		id("showRoomConfigRow2").className = "collapse";
	}
}

function checkShow(checkbox,obj) {
	if(checkbox.checked) {
		id(obj).className = "expand";
	} else {
		id(obj).className = "collapse";
	}
}

function select_daymonth_changed(){
	setDayList(id("fromDay"),id("fromMonth").options[id("fromMonth").selectedIndex].value,id("fromYear").value);
	setDayList(id("toDay"),id("toMonth").options[id("toMonth").selectedIndex].value,id("toYear").value);
	setDayList(id("createDateFromDay"),id("createDateFromMonth").options[id("createDateFromMonth").selectedIndex].value,id("createDateFromYear").value);
	setDayList(id("createDateToDay"),id("createDateToMonth").options[id("createDateToMonth").selectedIndex].value,id("createDateToYear").value);
	setDayList(id("statusDateFromDay"),id("statusDateFromMonth").options[id("statusDateFromMonth").selectedIndex].value,id("statusDateFromYear").value);
	setDayList(id("statusDateToDay"),id("statusDateToMonth").options[id("statusDateToMonth").selectedIndex].value,id("statusDateToYear").value);
}

