function dataScroll() {
	id("scrollHeaderDiv").scrollLeft = id("scrollDiv").scrollLeft;
	id("leftScrollDiv").scrollTop = id("scrollDiv").scrollTop;
	if(id("leftHeaderScrollDiv")) {
		id("leftHeaderScrollDiv").scrollLeft = id("leftScrollDiv").scrollLeft;
	}
}

function headerScroll() {
	id("leftHeaderScrollDiv").scrollLeft = id("leftScrollDiv").scrollLeft;
	id("scrollDiv").scrollTop = id("leftScrollDiv").scrollTop;
}

function initialisePage() {
	dateSelector();
	initTop();
	enableButtons(enabledButtons);

	// get print info
	id("user").innerHTML = FirstName + " " + LastName;
	id("server").innerHTML = Domain;
	id("genDate").innerHTML = genDateVal;

	populateDateFields("fromYear", fromY, "fromMonth", fromM, "fromDay", fromD);
	populateDateFields("toYear", toY, "toMonth", toM, "toDay", toD);

	if(id("arrowDsc"+sortBy)) {
		id("arrowDsc"+sortBy).src = "/resource/Resrequest/Application/public/img/arrow_descend_down.gif";
	}
	if(id("arrowAsc"+sortBy)) {
		id("arrowAsc"+sortBy).src = "/resource/Resrequest/Application/public/img/arrow_ascend_down.gif";
	}
	changeDisplayTotals(id("totalInvoiceDate").checked?1:2);
	travelToggle();
	extrasToggle();

	if(id("scrollDiv")) {
		id("scrollDiv").onscroll = dataScroll;
	}

	if(id("leftHeaderScrollDiv")) {
		id("leftScrollDiv").onscroll = headerScroll;
	}
}

function buildDate(prefix) {
	dayValue		= id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue	= id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue		= dayValue < 10 ? "0" + dayValue:dayValue;
	monthValue	= monthValue < 10 ? "0" + monthValue:monthValue;

	resultDate	= id(prefix + "Year").value + "-" + monthValue + "-" + dayValue;

	if ( dayValue < 1 ) {
		id(prefix + "Day").focus();
		openMessage("Please enter a valid " + prefix + " date","a",100);
		return false;
	}

	if ( monthValue < 1 ) {
		id(prefix+"Month").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}

	if ( id(prefix+"Year").value == "" ) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}

	if ( id(prefix+"Year").value.search(/^\d{4}$/) == -1 ) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	return resultDate;
}

function buildURL(renderOption,sortOption) {
	fromDate = buildDate("from");
	toDate = buildDate("to");
	if(id("totalInvoiceDate").checked) {
		totalDisplay = "1";
	} else {
		totalDisplay = "2";
	}
	invoiceStatus = 0;
	if(id("showInvoiced").checked) {
		invoiceStatus += 1;
	}
	if(id("showUninvoiced").checked) {
		invoiceStatus += 2;
	}
	if(id("extraFilterTypeCategory").checked) {
		extraFilterType = "1";
	} else {
		extraFilterType = "2";
	}
	setExtrasIds();
	if(id("agentNameRadio").checked) {
		agentFilterType = "1";
	} else {
		agentFilterType = "2";
	}
	showTravelType = 1;
	if(id("showTravelByAll").checked) {
		showTravelType = 2;
	}
	showExtrasType = 1;
	if(id("showExtrasByAll").checked) {
		showExtrasType = 2;
	}
	if(id("commNett").checked) {
		commissionFilterType = "1";
	} else if(id("commGross").checked) {
		commissionFilterType = "2";
	} else {
		commissionFilterType = "3";
	}
	if(id("taxExclude").checked) {
		taxFilterType = "1";
	} else {
		taxFilterType = "2";
	}
	renderOption &= 7;
	if(id("filters").className != "expand") {
		renderOption += 8;
	}

	fromDate = buildDate("from");
	toDate = buildDate("to");
	if ( toDate < fromDate ) {
		openMessage("Enter a To date that is greater than or equal to the From date","a",120);
		return false;
	}

	if(!sortOption) { sortOption = 1; }
	_urlCount++;


	if(renderOption == 0) {
		var filterStatus = "";
	} else {
		var filterStatus = id("filters").className;
	}

	var showHideButtonText = id("filterBut").value;

	var url = [
		/*  0 */ "reservation.php?" + jobId,
		/*  1 */ fromDate,
		/*  2 */ toDate,
		/*  3 */ totalDisplay,
		/*  4 */ invoiceStatus.toString(),
		/*  5 */ "", //id("propertiesIds").value,
		/*  6 */ id("accommIds").value,
		/*  7 */ extraFilterType,
		/*  8 */ id("extraCategoryIds").value,
		/*  9 */ id("extrasIds").value,
		/* 10 */ id("currenciesIds").value,
		/* 11 */ agentFilterType,
		/* 12 */ id("agentIds").value,
		/* 13 */ id("agentCountryIds").value,
		/* 14 */ id("consultantIds").value,
		/* 15 */ id("originatorIds").value,
		/* 16 */ id("nationalityIds").value,
		/* 17 */ id("rateIds").value,
		/* 18 */ id("sourceIds").value,
		/* 19 */ id("statusAllocIds").value,
		/* 20 */ (id("showAccomm").checked?"1":"0"),
		/* 21 */ (id("showTravel").checked?"1":"0"),
		/* 22 */ showTravelType,
		/* 23 */ (id("showExtras").checked?"1":"0"),
		/* 24 */ showExtrasType,
		/* 25 */ (id("showPayments").checked?"1":"0"),
		/* 26 */ (id("showTax").checked?"1":"0"),
		/* 27 */ commissionFilterType,
		/* 28 */ taxFilterType,
		/* 29 */ selValue("groupBy"),
		/* 30 */ selValue("invFrom"),
		/* 31 */ id("folioContactIds").value,
		/* 32 */ selValue("serverEnv"),
		/* 33 */ id("resNum").value,
		/* 34 */ renderOption.toString(),
		/* 35 */ sortOption.toString(),
		/* 36 */ _randomId + "_" + _urlCount.toString(),
		/* 37 */ filterStatus,
		/* 38 */ showHideButtonText,
		/* 39 */ (id("extraPropertyCheck").checked?"1":"0"),
		/* 40 */ (id("showReceipts").checked?"1":"0")
	];
	return url.join("+");
}

function generateReport(renderOption,sortOption) {
	var url = buildURL(renderOption,sortOption);
	if(url) {
		id("urlForm").target = "";
		id("url").value = url
		id("urlForm").action = "reservation.php?" + jobId;
		id("urlForm").submit();
	}
}

function openPDF() {
	var url = buildURL(1,sortBy);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
}

function sendPDF() {
	var url = buildURL(2,sortBy);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin = openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",775,615,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function openCSV() {
	var url = buildURL(4,sortBy);
	if ( url ) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openExtrasCat(filter){
	var selectedArray = id(filter + "Ids").value;

	url = "reservation.php?753+"
		+ filter
		+ "+"
		+ selectedArray;

	openPopup(url,290,400);
}

function setExtrasIds() {
	list = document.getElementsByName("extraIds");
	final = new Array();
	if(list.length > 0) {
		for(count=0; count<list.length; count++) {
			tmp = list[count].value.toString().split(":");
			for(count2=0;count2<tmp.length; count2++) {
				final[final.length] = tmp[count2];
			}
		}
		id("extrasIds").value = final.join(":");
	} else {
		id("extrasIds").value = "";
	}
}

function removeExtraIds(rCatId) {
	id("extra_"+rCatId).removeNode(true);
	id("extraIds_"+rCatId).removeNode(true);
	if(document.getElementsByName("extraIds").length == 0) {
		id("extraAll").className = "";
	} else {
		id("extraAll").className = "collapse";
	}
}

function highlightOn(num) {
	id("groupRow"+num.toString()).style.backgroundColor = '#CCFFCC';
	id("groupRowData"+num.toString()).style.backgroundColor = '#CCFFCC';
}

function highlightOff(num) {
	id("groupRow"+num.toString()).style.backgroundColor = '';
	id("groupRowData"+num.toString()).style.backgroundColor = '';
}

function rowClick(rJobId,rEvalId,rEvalData, rCurrencyId, rReservationId) {
	if(rEvalId != "") {
//		alert("about to eval... id('"+ rEvalId + "').value = '" + rEvalData + "';");
		eval("id('"+ rEvalId + "').value = '" + rEvalData + "';");
		if(rEvalId == "accommIds") {
			id("extraPropertyCheck").checked = true;
		}
	}
	id("currenciesIds").value = rCurrencyId;
	if(rReservationId) {
		id("resNum").value = rReservationId;
	}
	jobId = rJobId;
	generateReport();
}

function showHideFilters() {
	var filters 		= id("filters");
	var filterBut 	= id("filterBut");

	mnuInitialise = false;

	if ( filters.className == "collapse printCollapse" ) {
		filters.className = "expand";
		filterBut.value 	= "<< Hide Filters";
	} else {
		filters.className = "collapse printCollapse";
		filterBut.value 	= ">> Show Filters";
	}
}


function hideHeaderCol(name) {
	hw = parseInt(id("headerTable").offsetWidth,10);
	dw = parseInt(id("scrollDiv").offsetWidth,10);
	w = id(name).offsetWidth;

	id(name).className = "collapse";
	id(name+"2").className = "collapse";

	if ( !is_ie ) {
		collapseCol(name,0);
		if ( id(name + "2") ) {
			collapseCol(name + "2",0);
		}
	}

	if(!id("leftHeaderScrollDiv")) {
		id("leftScrollDiv").style.width = hw - w;
		id("scrollHeaderDiv").style.width = dw + w;
		id("scrollDiv").style.width = dw + w;
		id("headerTable").style.width = hw - w;
		id("headerTable2").style.width = hw - w;
	} else {
		id("headerTable").style.width = hw - w;
		id("headerTable2").style.width = hw - w - 30;
	}

	id("tableShowCol").className = "";

	headerScroll();
}

function hideDataCol(name) {
	id(name).className = "collapse";
	if ( id(name + "2") ) {
		id(name + "2").className = "collapse";
	}

	if ( !is_ie ) {
		collapseCol(name,0);
		if ( id(name + "2") ) {
			collapseCol(name + "2",0);
		}
	}

	id("tableShowCol").className = "";
}

function showCols() {
	if(!id("leftHeaderScrollDiv")) {
		id("leftScrollDiv").style.width = initialHeaderWidth;
		id("headerTable").style.width = initialHeaderWidth;
	} else {
		id("headerTable").style.width = parseInt(initialHeaderWidth)+30;
	}
	id("headerTable2").style.width = initialHeaderWidth;

	id("scrollHeaderDiv").style.width = initialDivWidth;
	id("scrollDiv").style.width = initialDivWidth;

	for ( cnt = 0; cnt < colHideList.length; cnt++ ) {
		id(colHideList[cnt]).className = "";
		if ( id(colHideList[cnt]+"2") ) {
			id(colHideList[cnt]+"2").className = "";
		}

		if ( !is_ie ) {
			collapseCol(colHideList[cnt],1);
			if ( colHideList[cnt] + "2" ) {
				collapseCol(colHideList[cnt] + "2",1);
			}
		}
	}

	id("tableShowCol").className = "collapse";
}

function gotoFinTab(job,resNum) {
	Set_Cookie("finTabName","Folios");
	window.location = '/reservation.php?' + job + '+' + resNum;
}

function changeDisplayTotals(val) {
	if(jobId == "251") {
		if(val == 1) {
			id("resNum").disabled = false;
			id("spanResNumReset").className = "collapse printCollapse";
		} else {
			id("resNum").disabled = true;;
			id("spanResNumReset").className = "expand";
		}
	}
}

function resetResNum() {
	id("resNum").value = "";
}

function travelToggle() {
	if(id("showTravel").checked) {
		id("showTravelTable").className = "expand";
	} else {
		id("showTravelTable").className = "collapse printCollapse";
	}
}

function extrasToggle() {
	if(id("showExtras").checked) {
		id("showExtrasTable").className = "expand";
	} else {
		id("showExtrasTable").className = "collapse printCollapse";
	}
}

function select_daymonth_changed(){
	setDayList(id("fromDay"),id("fromMonth").options[id("fromMonth").selectedIndex].value,id("fromYear").value);
	setDayList(id("toDay"),id("toMonth").options[id("toMonth").selectedIndex].value,id("toYear").value);
}

function openPropFilter() {
	var accomm = id("accommIds").value;
	openPopup("reservation.php?293+"+accomm,556,407);
}

function printReport() {
	window.print();
}
