function initialisePage(){
	dateSelector();
	initTop();
	enableButtons(enabledButtons);

	// get print info
	id("user").innerHTML = FirstName + " " + LastName;
	id("server").innerHTML = Domain;
	id("genDate").innerHTML = genDateVal;

	populateDateFields("invFromYear", invFromY, "invFromMonth", invFromM, "invFromDay", invFromD);
	populateDateFields("invToYear", invToY, "invToMonth", invToM, "invToDay", invToD);

	taxDetailColRegenerate();
	taxAmountsColRegenerate();
	changeDisplayCurr();
	levelChange();
}

function openFilter(filter, alias){
	if (typeof(alias) == 'undefined'){
		alias = filter;
	}
	var selectedArray = id(alias + "Ids").value;
	url = "reservation.php?661+"
		+ filter
		+ "+"
		+ selectedArray
		+ "+"
		+ "+"
		+ "+"
		+ alias;
		 
	openPopup(url,280,360);                          
}

function generateReport(renderOption,sortOption) {
	var url = buildURL(renderOption,sortOption);
	if(url) {
		id("urlForm").target = "";
		id("url").value = url
		id("urlForm").action = "reservation.php?" + jobId;
		id("urlForm").submit();
	}
}

function buildDate(prefix) {
	dayValue = id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue = id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue = dayValue<10?"0"+dayValue:dayValue;
	monthValue = monthValue<10?"0"+monthValue:monthValue;
	 
	resultDate = id(prefix+"Year").value+"-"+monthValue+"-"+dayValue;
      
	if(dayValue < 1) { 
		id(prefix+"Day").focus();
		openMessage("Enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(monthValue < 1) {
		id(prefix+"Month").focus();
		openMessage("Enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(id(prefix+"Year").value == "") {
		id(prefix+"Year").focus();
		openMessage("Enter a valid "+prefix+" date","a",100);
		return false;		 
	 }		 
	if(id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
		id(prefix+"Year").focus();
		openMessage("Enter a valid "+prefix+" date","a",100);
		return false;
	}

	return resultDate;
}  

function buildURL(renderOption) {
	invFromDate = buildDate("invFrom");
	invToDate = buildDate("invTo");
	
	if(id("totalInvoiceDate").checked) {
		totalDisplay = "1";
	} else {
		totalDisplay = "2";
	}
	
	
	if(invToDate < invFromDate) {
		openMessage("Invalid invoice date range","a",120);
		return false;		
	}	

	if(id("extraFilterTypeCategory").checked) {
		extraFilterType = "1";
	} else {
		extraFilterType = "2";
	}	
	
	groups = new Array();
	for(var count=0; count<groupCount; count++) {
		groups.push(selValue("groupBy" + count.toString()));
	}	
	
	invoiceStatus = 0;
	if(id("showInvoiced").checked) {
		invoiceStatus += 1;
	}
	if(id("showUninvoiced").checked) {
		invoiceStatus += 2;
	}

	if(id("agentNameRadio").checked) {
		agentFilterType = "1";
	} else {
		agentFilterType = "2";
	}

	if(id("extraFilterTypeCategory").checked) {
		extraFilterType = "1";
	} else {
		extraFilterType = "2";
	}
	setExtrasIds();	
	
	var taxDetailCols = buildTaxDetailCols();
	var taxAmountsCols = buildTaxAmountsCols();

	var url = [
		/*  0 */ "reservation.php?" + jobId,
		/*  1 */ invFromDate,
		/*  2 */ invToDate,
		/*  3 */ totalDisplay,
		/*  4 */ "",
		/*  5 */ "",		
		/*  6 */ agentFilterType,
		/*  7 */ id("agentIds").value,
		/*  8 */ id("agentCountryIds").value,		
		/*  9 */ id("folioContactIds").value,
		/* 10 */ id("originatorIds").value,
		/* 11 */ id("sourceIds").value,
		/* 12 */ id("createdByIds").value,
		/* 13 */ id("nationalityIds").value,		
		/* 14 */ id("rateIds").value,
		/* 15 */ id("statusIds").value,
		/* 16 */ id("accommIds").value,
		/* 17 */ id("paymentPlanIds").value,
		/* 18 */ id("componentsIds").value,
		/* 19 */ id("taxRateIds").value,
		/* 20 */ id("consultantIds").value,
		/* 21 */ id("serverIds").value,
		/* 22 */ id("folioCurrencyIds").value,		
		/* 23 */ selValue("pr_business_id"),
		/* 24 */ invoiceStatus,
		/* 25 */ "",
		/* 26 */ "",		
		/* 27 */ id("checkInclPos").checked?"1":"0",		
		/* 28 */ id("checkInclNeg").checked?"1":"0",
		/* 29 */ id("checkInclZero").checked?"1":"0",
		/* 30 */ "",
		/* 31 */ "",
		/* 32 */ "",
		/* 33 */ "",
		/* 34 */ "",
		/* 35 */ "",
		/* 36 */ "",
		/* 37 */ "",	
		/* 38 */ extraFilterType,
		/* 39 */ id("extraCategoryIds").value,
		/* 40 */ id("extrasIds").value,
		/* 41 */ (id("extraPropertyCheck").checked?"1":"0"),
		/* 42 */ groups.join(":"),
		/* 43 */ taxDetailCols,
		/* 44 */ taxAmountsCols,
		/* 45 */ renderOption,
		/* 46 */ selValue("display_currency")

	];
	return url.join("+");
}

function invDateTypeChange() {
	if (!id("invDateRangeOptCustomDate").checked ) {
		id("invFromDay").selectedIndex = 0;
		id("invFromMonth").selectedIndex = 0;
		id("invFromYear").value = "";

		id("invToDay").selectedIndex = 0;
		id("invToMonth").selectedIndex = 0;
		id("invToYear").value = "";
	} else {
		id("invFromDay").selectedIndex = invFromD;
		id("invFromMonth").selectedIndex = invFromM;
		id("invFromYear").value = invFromY;
		id("invToDay").selectedIndex = invToD;
		id("invToMonth").selectedIndex = invToM;
		id("invToYear").value = invToY;		
		
	}
	return true;
}

function emptyTable(objId) {
	var obj = id(objId);
	for(var count=obj.rows.length-1;count > -1; count--) {
		obj.deleteRow(count);
	}
}

/*  [START] Folio Details Report Builder Functions */

function buildTaxDetailCols() {
	var cols = [];
	for(var count=0; count<taxDetailColData.length; count++) {
		var cWidth = taxDetailColData[count].width;
		var cSort = taxDetailColData[count].sort;
		var cLabel = taxDetailColData[count].label;
		var cHeader = taxDetailColData[count].header;
		var cAlign = taxDetailColData[count].align;
		var cObjType = taxDetailColData[count].objType;
		var cGuestId = taxDetailColData[count].rf_obj_trip_ix;
		var cSplit = taxDetailColData[count].split;
		
		if(taxDetailColData[count].active == "1") {
			cWidth = id("taxDetailCol_width_" + taxDetailColData[count].id).value;
			cSort = selValue("taxDetailCol_sort_" + taxDetailColData[count].id);
			cLabel = id("taxDetailCol_label_" + taxDetailColData[count].id).value;
			cHeader = id("taxDetailCol_header_" + taxDetailColData[count].id).value;
			cAlign = selValue("taxDetailCol_align_" + taxDetailColData[count].id);
			cObjType = id("taxDetailCol_objType_" + taxDetailColData[count].id).value;
			if(cObjType == 3 || cObjType == 4 || cObjType == 5) {
				cSplit = id("taxDetailCol_split_" + taxDetailColData[count].id).checked?"1":"";
			}
		}
		var col = [
			taxDetailColData[count].active,
			taxDetailColData[count].order,
			cSort,
			cWidth,
			cLabel,
			cHeader,
			cAlign,
			cObjType,
			cGuestId,
			cSplit
		]
		cols[cols.length] = col.join(",");     //cSort, cDirection,
	}
	return cols.join(":");
}


var taxDetailColRowSelected = false;

function taxDetailColRow(cObjId,cId,cLabel,cSelected) {
	var row = id(cObjId).insertRow(-1);
	row.tableName = cObjId;
	row.colId = cId;
	row.onmouseover = function() {
		this.style.backgroundColor = "#cfc";
	}
	row.onmouseout = function() {
		if(taxDetailColRowSelected == this) {
			this.style.backgroundColor = "#31ff63";
		} else {
			this.style.backgroundColor = "";
		}
	}
	row.onclick = function(e,force) {
		if(taxDetailColRowSelected != this || (taxDetailColRowSelected == this && force) ) {
			if(taxDetailColRowSelected) {
				taxDetailColRowSelected.style.backgroundColor = "";
				taxDetailColRowSelected.firstChild.style.fontWeight = "";
			}
			taxDetailColRowSelected = this;
			this.firstChild.style.fontWeight = "bold";
			if(this.style.backgroundColor == "") {
				this.style.backgroundColor = "#31ff63";
			}
			if(this.tableName == "tblInactiveTaxDetailCol") {
				id("btnTaxDetailColAdd").disabled = false;
				id("btnTaxDetailColRemove").disabled = true;
				id("btnTaxDetailColUp").disabled = true;
				id("btnTaxDetailColDown").disabled = true;
			} else {
				id("btnTaxDetailColAdd").disabled = true;
				id("btnTaxDetailColRemove").disabled = false;
				id("btnTaxDetailColUp").disabled = false;
				id("btnTaxDetailColDown").disabled = false;
			}
		} else {
			taxDetailColRowSelected = false;
			this.firstChild.style.fontWeight = "";
			id("btnTaxDetailColAdd").disabled = true;
			id("btnTaxDetailColRemove").disabled = true;
			id("btnTaxDetailColUp").disabled = true;
			id("btnTaxDetailColDown").disabled = true;
		}
	}

	// name
	var cell = row.insertCell(-1);
	cell.innerHTML = cLabel;
	cell.className = "imgLink";
	if(taxDetailColData[cId-1].disable == '1') {
		cell.style.backgroundColor = "#999";
	}
	cell.style.width = "100%";
	if(cObjId == "tblInactiveTaxDetailCol") {
		cell.style.whiteSpace = "nowrap";
	}

	if(cObjId == "tblActiveTaxDetailCol") {
		// label
		cell = row.insertCell(-1);
		//cell.style.width = "105px";
		cell.innerHTML = "<input type=\"text\" id=\"taxDetailCol_label_" + cId + "\" style=\"width:95px;\" value=\""+taxDetailColData[cId-1].label+"\"/><input type=\"hidden\" id=\"taxDetailCol_objType_" + cId + "\" value=\""+taxDetailColData[cId-1].objType+"\"/><input type=\"hidden\" id=\"taxDetailCol_rf_obj_trip_ix_" + cId + "\" value=\""+taxDetailColData[cId-1].rf_obj_trip_ix+"\"/>";
	
		//split
		if(taxDetailColData[cId-1].objType=='3' || taxDetailColData[cId-1].objType=='4' || taxDetailColData[cId-1].objType=='5') {
			var splitChecked = "";
			if(taxDetailColData[cId-1].split == 1) {
				splitChecked = "checked";
			}
			cell = row.insertCell(-1);
			//cell.style.width = "40px";
			cell.innerHTML = "<input type=\"checkbox\" id=\"taxDetailCol_split_" + cId + "\" name=\"splitCheck\"  value=\""+taxDetailColData[cId-1].split+"\" "+splitChecked+"/>";
		} else {
			cell = row.insertCell(-1);
		}

	// width
		cell = row.insertCell(-1);
		//cell.style.width = "40px";
		cell.innerHTML = "<input type=\"text\" id=\"taxDetailCol_width_" + cId + "\" style=\"width:28px;\" value=\""+taxDetailColData[cId-1].width+"\"/>";
		
		//sort
		cell = row.insertCell(-1);
		//cell.style.width = "65px";
		cell.innerHTML = "<select id=\"taxDetailCol_sort_" + cId + "\" style=\"width:35px;\">"+taxDetailColSortOptions+"</select><select id=\"taxDetailCol_sort_direction_" + cId + "\" style=\"width:43px;\"><option value=\"a\">Ascending</option><option value=\"d\">Descending</option></select>";

		if(taxDetailColData[cId-1].sort != "") {
			id("taxDetailCol_sort_" + cId).selectedIndex = parseInt(taxDetailColData[cId-1].sort,10);
		}

		if(taxDetailColData[cId-1].direction == "d") {
			id("taxDetailCol_sort_direction_" + cId).selectedIndex = 1;
		}
		
		//Group Header
		cell = row.insertCell(-1);
		//cell.style.width = "100px";
		cell.innerHTML = "<input type=\"text\" id=\"taxDetailCol_header_" + cId + "\" style=\"width:90px\" value=\""+taxDetailColData[cId-1].header+"\"/>";

		//Align
		cell = row.insertCell(-1);
		//cell.style.width = "45px";
		cell.innerHTML = "<select id=\"taxDetailCol_align_" + cId + "\" style=\"width:48px\"><option value=\"l\">Left</option><option value=\"c\">Centre</option><option value=\"r\">Right</option></select>";

		var align = taxDetailColData[cId-1].align;
		if(align == "c") {
			id("taxDetailCol_align_"+cId).selectedIndex = 1;
		} 
		if(align == "r") {
			id("taxDetailCol_align_"+cId).selectedIndex = 2;
		}
	}
	
	if(cSelected) {
		taxDetailColRowSelected = row;
		row.onclick(false,true);
	}
	
}

var taxDetailColSortOptions = "";
function taxDetailColRegenerate() {
	if(taxDetailColRowSelected != false) {
		var taxDetailColRowSelectedId = taxDetailColRowSelected.colId;
	}
	emptyTable("tblInactiveTaxDetailCol");
	emptyTable("tblActiveTaxDetailCol");

	var taxDetailColSort = [];
	var sortCount = 1;
	taxDetailColSortOptions = "<option value=\"\"></option>";
	for(var count=0; count < taxDetailColData.length; count++) {
		taxDetailColSortOptions += "<option value=\"" + sortCount.toString() + "\">" + sortCount.toString() + "</option>";
		sortCount++;
	}
	for(var count=0; count < taxDetailColData.length; count++) {
		if(taxDetailColData[count].active != "1") {
			var selected = false;
			if(taxDetailColData[count].id == taxDetailColRowSelectedId) {
				selected = true;
			}
			taxDetailColRow("tblInactiveTaxDetailCol",taxDetailColData[count].id,taxDetailColData[count].name,selected);
		} else {
			taxDetailColSort[taxDetailColData[count].order] = count;
		}
	}

	for(var count=1; count < taxDetailColSort.length; count++) {
		var selected = false;
		if(taxDetailColData[taxDetailColSort[count]].id == taxDetailColRowSelectedId) {
			selected = true;
		}
		taxDetailColRow("tblActiveTaxDetailCol",taxDetailColData[taxDetailColSort[count]].id,taxDetailColData[taxDetailColSort[count]].name,selected);
	}
}

function taxDetailColOrderArray() {
	var taxDetailColOrder = [];
	for(var count=0; count < taxDetailColData.length; count++) {
		if(taxDetailColData[count].active == "1") {
			taxDetailColOrder[taxDetailColData[count].order] = count;
		} else {
			taxDetailColData[count].order = 0;
		}
	}

	var newColOrder = [];

	for(var count=1; count < taxDetailColOrder.length; count++) {
		var key = taxDetailColOrder[count];
		if(taxDetailColData[key]) {
			newColOrder[newColOrder.length] = key;
		}
	}
	return newColOrder;
}

function taxDetailColNormaliseOrder() {
	var taxDetailColOrder = taxDetailColOrderArray();

	var taxDetailOrderCount = 1;
	for(var count=0; count < taxDetailColOrder.length; count++) {
		taxDetailColData[taxDetailColOrder[count]].order = taxDetailOrderCount;
		taxDetailOrderCount++;
	}
}

function taxDetailColAdd() {
	if(!taxDetailColRowSelected) { return false; }

	var maxOrder = 0;
	for(var count=0; count < taxDetailColData.length; count++) {
		if(parseInt(taxDetailColData[count].order) > parseInt(maxOrder)) { 
			maxOrder = parseInt(taxDetailColData[count].order);
		}
	}
	maxOrder++;
	
	for(var count=0; count < taxDetailColData.length; count++) {
		if(taxDetailColRowSelected.colId == taxDetailColData[count].id) {
			taxDetailColData[count].active = "1";
			taxDetailColData[count].order = maxOrder;
		}
	}	

	taxDetailColNormaliseOrder();
	taxDetailColRegenerate();
}

function taxDetailColRemove() {
	if(!taxDetailColRowSelected) { return false; }

	for(var count=0; count < taxDetailColData.length; count++) {
		if(taxDetailColRowSelected.colId == taxDetailColData[count].id) {
			taxDetailColData[count].active = "0";
		}
	}	
	taxDetailColNormaliseOrder();
	taxDetailColRegenerate();
}

function taxDetailColSwapOrder(key1, key2) {
	var temp = taxDetailColData[key1].order;
	taxDetailColData[key1].order = taxDetailColData[key2].order;
	taxDetailColData[key2].order = temp;
}

function taxDetailColMove(direction) {
	if(!taxDetailColRowSelected) { return false; }

	var colOrder = taxDetailColOrderArray();
	var colFirst = colOrder[0];
	
	for(var count=0; count < colOrder.length; count++) {
		var key = colOrder[count];
		if(taxDetailColRowSelected.colId == taxDetailColData[key].id) {
			if(!direction) {
				if(count != 0) {
					taxDetailColSwapOrder(key,colOrder[count-1]);
				}
			} else {
				if(count < colOrder.length-1) {
					taxDetailColSwapOrder(key,colOrder[count+1]);
				}
			}
		}
	}

	taxDetailColNormaliseOrder();
	taxDetailColRegenerate();
}

function taxDetailColUp() {
	taxDetailColMove();
}

function taxDetailColDown() {
	taxDetailColMove(true);
}

/*  [END] Folio Details Report Builder Functions */

/*  [START] Folio Amounts Report Builder Functions */

function buildTaxAmountsCols() {
	var cols = [];
	for(var count=0; count<taxAmountsColData.length; count++) {
		var cWidth = taxAmountsColData[count].width;
		var cSort = taxAmountsColData[count].sort;
		var cLabel = taxAmountsColData[count].label;
		var cHeader = taxAmountsColData[count].header;
		var cAlign = taxAmountsColData[count].align;
		var cObjType = taxAmountsColData[count].objType;
		var cGuestId = taxAmountsColData[count].rf_obj_trip_ix;
		var cSplit = taxAmountsColData[count].split;
		
		if(taxAmountsColData[count].active == "1") {
			cWidth = id("taxAmountsCol_width_" + taxAmountsColData[count].id).value;
			cSort = selValue("taxAmountsCol_sort_" + taxAmountsColData[count].id);
			cLabel = id("taxAmountsCol_label_" + taxAmountsColData[count].id).value;
			cHeader = id("taxAmountsCol_header_" + taxAmountsColData[count].id).value;
			cAlign = selValue("taxAmountsCol_align_" + taxAmountsColData[count].id);
			cObjType = id("taxAmountsCol_objType_" + taxAmountsColData[count].id).value;
			if(cObjType == 3 || cObjType == 4 || cObjType == 5) {
				cSplit = id("taxAmountsCol_split_" + taxAmountsColData[count].id).checked?"1":"";
			}
		}
		var col = [
			taxAmountsColData[count].active,
			taxAmountsColData[count].order,
			cSort,
			cWidth,
			cLabel,
			cHeader,
			cAlign,
			cObjType,
			cGuestId,
			cSplit
		]
		cols[cols.length] = col.join(",");     //cSort, cDirection,
	}
	return cols.join(":");
}


var taxAmountsColRowSelected = false;

function taxAmountsColRow(cObjId,cId,cLabel,cSelected) {
	var row = id(cObjId).insertRow(-1);
	row.tableName = cObjId;
	row.colId = cId;
	row.onmouseover = function() {
		this.style.backgroundColor = "#cfc";
	}
	row.onmouseout = function() {
		if(taxAmountsColRowSelected == this) {
			this.style.backgroundColor = "#31ff63";
		} else {
			this.style.backgroundColor = "";
		}
	}
	row.onclick = function(e,force) {
		if(taxAmountsColRowSelected != this || (taxAmountsColRowSelected == this && force) ) {
			if(taxAmountsColRowSelected) {
				taxAmountsColRowSelected.style.backgroundColor = "";
				taxAmountsColRowSelected.firstChild.style.fontWeight = "";
			}
			taxAmountsColRowSelected = this;
			this.firstChild.style.fontWeight = "bold";
			if(this.style.backgroundColor == "") {
				this.style.backgroundColor = "#31ff63";
			}
			if(this.tableName == "tblInactiveTaxAmountsCol") {
				id("btnTaxAmountsColAdd").disabled = false;
				id("btnTaxAmountsColRemove").disabled = true;
				id("btnTaxAmountsColUp").disabled = true;
				id("btnTaxAmountsColDown").disabled = true;
			} else {
				id("btnTaxAmountsColAdd").disabled = true;
				id("btnTaxAmountsColRemove").disabled = false;
				id("btnTaxAmountsColUp").disabled = false;
				id("btnTaxAmountsColDown").disabled = false;
			}
		} else {
			taxAmountsColRowSelected = false;
			this.firstChild.style.fontWeight = "";
			id("btnTaxAmountsColAdd").disabled = true;
			id("btnTaxAmountsColRemove").disabled = true;
			id("btnTaxAmountsColUp").disabled = true;
			id("btnTaxAmountsColDown").disabled = true;
		}
	}

	// name
	var cell = row.insertCell(-1);
	cell.innerHTML = cLabel;
	cell.className = "imgLink";
	if(taxAmountsColData[cId-1].disable == '1') {
		cell.style.backgroundColor = "#999";
	}
	cell.style.width = "98px";
	if(cObjId == "tblInactiveTaxAmountsCol") {
		cell.style.whiteSpace = "nowrap";
	}

	if(cObjId == "tblActiveTaxAmountsCol") {
		// label
		cell = row.insertCell(-1);
		//cell.style.width = "105px";
		cell.innerHTML = "<input type=\"text\" id=\"taxAmountsCol_label_" + cId + "\" style=\"width:97px;\" value=\""+taxAmountsColData[cId-1].label+"\"/><input type=\"hidden\" id=\"taxAmountsCol_objType_" + cId + "\" value=\""+taxAmountsColData[cId-1].objType+"\"/><input type=\"hidden\" id=\"taxAmountsCol_rf_obj_trip_ix_" + cId + "\" value=\""+taxAmountsColData[cId-1].rf_obj_trip_ix+"\"/>";
	
		//split
		if(taxAmountsColData[cId-1].objType=='3' || taxAmountsColData[cId-1].objType=='4' || taxAmountsColData[cId-1].objType=='5') {
			var splitChecked = "";
			if(taxAmountsColData[cId-1].split == 1) {
				splitChecked = "checked";
			}
			cell = row.insertCell(-1);
			//cell.style.width = "40px";
			cell.innerHTML = "<input type=\"checkbox\" id=\"taxAmountsCol_split_" + cId + "\" name=\"splitCheck\"  value=\""+taxAmountsColData[cId-1].split+"\" "+splitChecked+"/>";
		} else {
			cell = row.insertCell(-1);
		}

	// width
		cell = row.insertCell(-1);
		//cell.style.width = "40px";
		cell.innerHTML = "<input type=\"text\" id=\"taxAmountsCol_width_" + cId + "\" style=\"width:28px;\" value=\""+taxAmountsColData[cId-1].width+"\"/>";
		
		//sort
		cell = row.insertCell(-1);
		//cell.style.width = "65px";
		cell.innerHTML = "<select id=\"taxAmountsCol_sort_" + cId + "\" style=\"width:35px;\">"+taxAmountsColSortOptions+"</select><select id=\"taxAmountsCol_sort_direction_" + cId + "\" style=\"width:43px;\"><option value=\"a\">Ascending</option><option value=\"d\">Descending</option></select>";

		if(taxAmountsColData[cId-1].sort != "") {
			id("taxAmountsCol_sort_" + cId).selectedIndex = parseInt(taxAmountsColData[cId-1].sort,10);
		}

		if(taxAmountsColData[cId-1].direction == "d") {
			id("taxAmountsCol_sort_direction_" + cId).selectedIndex = 1;
		}
		
		//Group Header
		cell = row.insertCell(-1);
		//cell.style.width = "100px";
		cell.innerHTML = "<input type=\"text\" id=\"taxAmountsCol_header_" + cId + "\" style=\"width:90px\" value=\""+taxAmountsColData[cId-1].header+"\"/>";

		//Align
		cell = row.insertCell(-1);
		//cell.style.width = "45px";
		cell.innerHTML = "<select id=\"taxAmountsCol_align_" + cId + "\" style=\"width:48px\"><option value=\"l\">Left</option><option value=\"c\">Centre</option><option value=\"r\">Right</option></select>";

		var align = taxAmountsColData[cId-1].align;
		if(align == "c") {
			id("taxAmountsCol_align_"+cId).selectedIndex = 1;
		} 
		if(align == "r") {
			id("taxAmountsCol_align_"+cId).selectedIndex = 2;
		}
	}
	
	if(cSelected) {
		taxAmountsColRowSelected = row;
		row.onclick(false,true);
	}
	
}

var taxAmountsColSortOptions = "";
function taxAmountsColRegenerate() {
	if(taxAmountsColRowSelected != false) {
		var taxAmountsColRowSelectedId = taxAmountsColRowSelected.colId;
	}
	emptyTable("tblInactiveTaxAmountsCol");
	emptyTable("tblActiveTaxAmountsCol");

	var taxAmountsColSort = [];
	var sortCount = 1;
	taxAmountsColSortOptions = "<option value=\"\"></option>";
	for(var count=0; count < taxAmountsColData.length; count++) {
		taxAmountsColSortOptions += "<option value=\"" + sortCount.toString() + "\">" + sortCount.toString() + "</option>";
		sortCount++;
	}
	for(var count=0; count < taxAmountsColData.length; count++) {
		if(taxAmountsColData[count].active != "1") {
			var selected = false;
			if(taxAmountsColData[count].id == taxAmountsColRowSelectedId) {
				selected = true;
			}
			taxAmountsColRow("tblInactiveTaxAmountsCol",taxAmountsColData[count].id,taxAmountsColData[count].name,selected);
		} else {
			taxAmountsColSort[taxAmountsColData[count].order] = count;
		}
	}

	for(var count=1; count < taxAmountsColSort.length; count++) {
		var selected = false;
		if(taxAmountsColData[taxAmountsColSort[count]].id == taxAmountsColRowSelectedId) {
			selected = true;
		}
		taxAmountsColRow("tblActiveTaxAmountsCol",taxAmountsColData[taxAmountsColSort[count]].id,taxAmountsColData[taxAmountsColSort[count]].name,selected);
	}
}

function taxAmountsColOrderArray() {
	var taxAmountsColOrder = [];
	for(var count=0; count < taxAmountsColData.length; count++) {
		if(taxAmountsColData[count].active == "1") {
			taxAmountsColOrder[taxAmountsColData[count].order] = count;
		} else {
			taxAmountsColData[count].order = 0;
		}
	}

	var newColOrder = [];

	for(var count=1; count < taxAmountsColOrder.length; count++) {
		var key = taxAmountsColOrder[count];
		if(taxAmountsColData[key]) {
			newColOrder[newColOrder.length] = key;
		}
	}
	return newColOrder;
}

function taxAmountsColNormaliseOrder() {
	var taxAmountsColOrder = taxAmountsColOrderArray();

	var taxAmountsOrderCount = 1;
	for(var count=0; count < taxAmountsColOrder.length; count++) {
		taxAmountsColData[taxAmountsColOrder[count]].order = taxAmountsOrderCount;
		taxAmountsOrderCount++;
	}
}

function taxAmountsColAdd() {
	if(!taxAmountsColRowSelected) { return false; }

	var maxOrder = 0;
	for(var count=0; count < taxAmountsColData.length; count++) {
		if(parseInt(taxAmountsColData[count].order) > parseInt(maxOrder)) { 
			maxOrder = parseInt(taxAmountsColData[count].order);
		}
	}
	maxOrder++;
	
	for(var count=0; count < taxAmountsColData.length; count++) {
		if(taxAmountsColRowSelected.colId == taxAmountsColData[count].id) {
			taxAmountsColData[count].active = "1";
			taxAmountsColData[count].order = maxOrder;
		}
	}	

	taxAmountsColNormaliseOrder();
	taxAmountsColRegenerate();
}

function taxAmountsColRemove() {
	if(!taxAmountsColRowSelected) { return false; }

	for(var count=0; count < taxAmountsColData.length; count++) {
		if(taxAmountsColRowSelected.colId == taxAmountsColData[count].id) {
			taxAmountsColData[count].active = "0";
		}
	}	
	taxAmountsColNormaliseOrder();
	taxAmountsColRegenerate();
}

function taxAmountsColSwapOrder(key1, key2) {
	var temp = taxAmountsColData[key1].order;
	taxAmountsColData[key1].order = taxAmountsColData[key2].order;
	taxAmountsColData[key2].order = temp;
}

function taxAmountsColMove(direction) {
	if(!taxAmountsColRowSelected) { return false; }

	var colOrder = taxAmountsColOrderArray();
	var colFirst = colOrder[0];
	
	for(var count=0; count < colOrder.length; count++) {
		var key = colOrder[count];
		if(taxAmountsColRowSelected.colId == taxAmountsColData[key].id) {
			if(!direction) {
				if(count != 0) {
					taxAmountsColSwapOrder(key,colOrder[count-1]);
				}
			} else {
				if(count < colOrder.length-1) {
					taxAmountsColSwapOrder(key,colOrder[count+1]);
				}
			}
		}
	}

	taxAmountsColNormaliseOrder();
	taxAmountsColRegenerate();
}

function taxAmountsColUp() {
	taxAmountsColMove();
}

function taxAmountsColDown() {
	taxAmountsColMove(true);
}

/*  [END] Folio Amounts Report Builder Functions */


function showHideFilters() {
	var filters = id("filters");
	var filterBut = id("filterBut");

	mnuInitialise = false;

	if(filters.className == "collapse printCollapse") {
		filters.className = "expand";
		filterBut.value 	= "<< Hide Filters";
	} else {
		filters.className = "collapse printCollapse";
		filterBut.value 	= ">> Show Filters";
	}
}

function showExportMenu(e, flag) {
	if ( !e ) {
		e = window.event;
	}
	stopBubble(e);

	var posx = 0;
	var posy = 0;
	if (e.pageX || e.pageY) 	{
		posx = e.pageX;
		posy = e.pageY;
	} else if (e.clientX || e.clientY) 	{
		posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
		posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
	}
	
	if(flag == 1) {
		posy = posy-60;
	}

	id("exportOptionDiv").style.display	= "";
	id("exportOptionDiv").style.left = posx+"px";
	id("exportOptionDiv").style.top = posy+"px";
}

function closeOptDiv() {
	id('exportOptionDiv').style.display = "none";
}

function printReport() {
	window.print();
}

function select_daymonth_changed(){
	setDayList(id("invFromDay"),id("invFromMonth").options[id("invFromMonth").selectedIndex].value,id("invFromYear").value);
	setDayList(id("invToDay"),id("invToMonth").options[id("invToMonth").selectedIndex].value,id("invToYear").value);
}

function rowOn(row) {
	row.style.backgroundColor = '#CCFFCC';
}

function rowOff(row) {
	row.style.backgroundColor = '';
}

function openExtrasCat(filter){
	var selectedArray = id(filter + "Ids").value;

	url = "reservation.php?753+"
		+ filter
		+ "+"
		+ selectedArray;

	openPopup(url,290,400);
}

function setExtrasIds() {
	list = document.getElementsByName("extraIds");
	final = new Array();
	if(list.length > 0) {
		for(count=0; count<list.length; count++) {
			tmp = list[count].value.toString().split(":");
			for(count2=0;count2<tmp.length; count2++) {
				final[final.length] = tmp[count2];
			}
		}
		id("extrasIds").value = final.join(":");
	} else {
		id("extrasIds").value = "";
	}	
}

function removeExtraIds(rCatId) {
	id("extra_"+rCatId).removeNode(true);
	id("extraIds_"+rCatId).removeNode(true);
	if(document.getElementsByName("extraIds").length == 0) {
		id("extraAll").className = "";
	} else {
		id("extraAll").className = "collapse";
	}
}

function openPropFilter() {
	var accomm = id("accommIds").value;
	openPopup("reservation.php?293+"+accomm,556,407);
}

function toggleOptions() {
	if(id("advancedForm").className == "collapse") {
		id("advancedForm").className = "colLt";
		id("advancedTag").value = "<<  More";		// For <input> element
		id("advancedTag").innerHTML = "<<  More";	// For <button> element
	} else {
		id("advancedForm").className = "collapse";
		id("advancedTag").value = ">>  More";
		id("advancedTag").innerHTML = ">>  More";
	}
}

function openCal(obj,e) {
	dateObj = obj;
	screenPosX = getClickPosition(e,'x');
	screenPosY = getClickPosition(e,'y');
	openPopup('/resource/Resrequest/Application/public/html/calendar.htm',300,185,screenPosX,screenPosY);
}

function changeDisplayCurr(){
	if (id("showUninvoiced").checked){
		id("display_currency").selectedIndex = 0;
		id("display_currency").disabled = true;
	} else {
		id("display_currency").disabled = false;
	}
}

function sendCSV(){
	url = buildURL(5);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",595,424,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function levelChange() {
	var count;
	for(count=0; count<groupCount; count++) {
		if(selValue("groupBy"+count.toString()) == "all") {
			break;
		}
	}
	if (id("groupBy"+count.toString())){
		id("groupBy"+count.toString()).disabled = false;
		count++;
	}
	for(;count<groupCount;count++) {
		id("groupBy"+count.toString()).selectedIndex = 0;
		id("groupBy"+count.toString()).disabled = true;
	}
}

function openOffice() {
	url = buildURL(7);
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}
