var builders = [];

function builderInit(name,items) {
	builders[name] = [];

	var conf = builders[name];
	conf['selected'] = false;
	conf['items'] = items;

	builderRegenerate(name);
}

function builderRegenerate(name) {
	var conf = builders[name];

	emptyTable(name+"BuilderAvailableTable");
	emptyTable(name+"BuilderActiveTable");

	// Create options for sort selection
	var count = 1;
	conf['sortOptions'] = "<option value=\"\"></option>";
	for(var itemName in conf['items']) {
		conf['sortOptions'] += "<option value=\"" + count.toString() + "\">" + count.toString() + "</option>";
		count++;
	}

	// Create available items while creating a sorted list of active items
	sorted = [];
	for(var itemName in conf['items']) {
		var item = conf['items'][itemName];

		var selected = false;
		if(itemName == conf['selected']) {
			selected = true;
		}
		if(item.active != "1") {
			builderRow(name,itemName,"available",selected);
		} else {
			sorted[item['order']] = itemName;
			//builderRow(name,itemName,"active",selected);
		}
	}

	for(var count in sorted) {
		var itemName = sorted[count];
		var item = conf['items'][itemName];

		var selected = false;
		if(itemName == conf['selected']) {
			selected = true;
		}
		builderRow(name,itemName,"active",selected);
	}
}

function builderRow(name,itemName,type,selected) {
	var conf = builders[name];
	var item = conf['items'][itemName];
	var prefix = "builderItem_" + name + "_" + itemName;

	if(type == "available") {
		var tableName = name+"BuilderAvailableTable";
	} else {
		var tableName = name+"BuilderActiveTable";
	}
	var table = id(tableName);
	var row = table.insertRow(-1);
	row.tableName = tableName;
	row.builderName = name;
	row.builderItemName = itemName;
	row.id = prefix;

	row.onmouseover = function() {
		this.style.backgroundColor = "#cfc";
	}
	row.onmouseout = function() {
		if(conf['selected'] == itemName) {
			this.style.backgroundColor = "#31ff63";
		} else {
			this.style.backgroundColor = "";
		}
	}

	// name
	var cell = row.insertCell(-1);
	cell.innerHTML = item['label'];
	cell.className = "imgLink";
	if(item['disabled'] == '1') {
		cell.style.backgroundColor = "#999";
	}
	cell.style.width = "100%";
	if(type == "available") {
		cell.style.whiteSpace = "nowrap";
		cell.onmouseout = function() { nd(); };
		cell.onmouseover = (function(label) { return function(e) { overlib(label,WIDTH, false); } }(item['label']));
	}

	row.onclick = (function(name,itemName,type) {
		return function(e,force) {
			var conf = builders[name];
			var item = conf['items'][itemName];

			if(conf['selected'] != itemName || (conf['selected'] == itemName && force) ) {
				if(conf['selected']) {
					var selected = id("builderItem_" + name + "_" + conf['selected']);
					selected.style.backgroundColor = "";
					selected.firstChild.style.fontWeight = "";
				}
				conf['selected'] = itemName;
				this.firstChild.style.fontWeight = "bold";
				if(this.style.backgroundColor == "") {
					this.style.backgroundColor = "#31ff63";
				}
				if(type == "available") {
					id(name + "BuilderAddButton").disabled = false;
					id(name + "BuilderRemoveButton").disabled = true;
					id(name + "BuilderUpButton").disabled = true;
					id(name + "BuilderDownButton").disabled = true;
				} else {
					id(name + "BuilderAddButton").disabled = true;
					id(name + "BuilderRemoveButton").disabled = false;
					id(name + "BuilderUpButton").disabled = false;
					id(name + "BuilderDownButton").disabled = false;
				}
			} else {
				folioDetailColRowSelected = false;
				this.firstChild.style.fontWeight = "";
				id(name + "BuilderAddButton").disabled = true;
				id(name + "BuilderRemoveButton").disabled = true;
				id(name + "BuilderUpButton").disabled = true;
				id(name + "BuilderDownButton").disabled = true;
			}
		}
	}(name,itemName,type));

	if(type == "active") {
		for(var colName in item['cols']) {
			var col = item['cols'][colName];

			cell = row.insertCell(-1);

			var width = (parseInt(col['width'],10) - 6).toString();
			if(col['type'] == "text") {
				cell.innerHTML = "<input type=\"text\" id=\"" + prefix + "_" + colName + "\" value=\"" + col['value'] + "\" style=\"width:" + width + "px\"/>";
			} else if(col['type'] == "select") {
				var html = "<select id=\"" + prefix + "_" + colName + "\" style=\"width:" + width + "px\">";
				for(var option in col['items']) {
					var oSelected = "";
					if(option == col['value']) {
						oSelected = "selected";
					}
					html += "<option value=\"" + option + "\" " + oSelected + ">" + col['items'][option] + "</option>";
				}
				html += "</select>";
				cell.innerHTML = html;
			} else if(col['type'] == "sort") {
				cell.innerHTML = "<select id=\"" + prefix + "_" + colName + "\" style=\"width:35px;\">"+conf['sortOptions']+"</select>";
				id(prefix + "_" + colName).selectedIndex = (parseInt(col['value'],10)).toString();
			} else {
				cell.innerHTML = "Unknown type";
			}
		}
		cell = row.insertCell(-1);
		cell.innerHTML = "<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" />";
	}
	
	if(selected) {
		conf['selected'] = itemName;
		row.onclick(false,true);
	}

}

function builderArg(name) {
	var conf = builders[name];
	for(var itemName in conf['items']) {		
		var item = conf['items'][itemName];
		if(item.active == "1") {
			var prefix = "builderItem_" + name + "_" + itemName;
			for(var colName in item['cols']) {
				var col = item['cols'][colName];

				if(col['type'] == "text") {
					col['value'] = id(prefix + "_" + col['name']).value;
				} else if(col['type'] == "select" || col['type'] == "sort") {
					col['value'] = selValue(prefix + "_" + col['name']);
				} else {
					col['value'] = "Unknown";
				}
			}
		}
	}
	return serialize(conf['items']);
}

function builderAdd(name) {
	var conf = builders[name];
	if(!conf['selected']) { return false; }

	var maxOrder = 0;
	for(var itemName in conf['items']) {
		var item = conf['items'][itemName];
		if(parseInt(item.order) > parseInt(maxOrder)) { 
			maxOrder = parseInt(item.order);
		}
	}
	maxOrder++;

	var item = conf['items'][conf['selected']];
	item.active = "1";
	item.order = maxOrder;

	builderNormaliseOrder(name);
	builderRegenerate(name);
}

function builderRemove(name) {
	var conf = builders[name];

	if(!conf['selected']) { return false; }

	var item = conf['items'][conf['selected']];
	item.active = "0";

	builderNormaliseOrder(name);
	builderRegenerate(name);
}

function builderOrder(name) {
	var conf = builders[name];

	var order = [];
	for(var itemName in conf['items']) {
		var item = conf['items'][itemName];
		if(item.active == "1") {
			order[item.order] = itemName;
		} else {
			item.order = 0;
		}
	}
	return order;
}

function builderNormaliseOrder(name) {
	var conf = builders[name];
	var order = builderOrder(name);	

	var count = 0;
	for(var i in order) {
		var itemName = order[i];
		var item = conf['items'][itemName];
		item.order = count;
		count++;
	}
	return;
}


function builderSwapOrder(name, itemName1, itemName2) {
	var conf = builders[name];

	var item1 = conf['items'][itemName1];
	var item2 = conf['items'][itemName2];

	var temp = item1.order;
	item1.order = item2.order;
	item2.order = temp;
}

function builderMove(name,direction) {
	var conf = builders[name];

	if(!conf['selected']) { return false; }

	var order = builderOrder(name);

	for(var index in order) {
		var itemName = order[index];
		var item = conf['items'][itemName];
		
		if(conf['selected'] == itemName) {
			var i = parseInt(index,10);
			if(!direction) {
				if(index != 0) {
					builderSwapOrder(name,itemName,order[i-1]);
				}
			} else {
				if(index < order.length-1) {
					builderSwapOrder(name,itemName,order[i+1]);
				}
			}
		}
	}

	builderNormaliseOrder(name);
	builderRegenerate(name);
}

function builderUp(name) {
	builderMove(name);
}

function builderDown(name) {
	builderMove(name,true);
}
