function buildDate(prefix) {
	dayValue		= id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue	= id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue		= dayValue < 10 ? "0" + dayValue:dayValue;
	monthValue	= monthValue < 10 ? "0" + monthValue:monthValue;

	resultDate	= id(prefix + "Year").value + "-" + monthValue + "-" + dayValue;

	if ( dayValue < 1 ) {
		id(prefix + "Day").focus();
		openMessage("Please enter a valid " + prefix + " date","a",100);
		return false;
	}

	if ( monthValue < 1 ) {
		id(prefix+"Month").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}

	if ( id(prefix+"Year").value == "" ) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}		 

	if ( id(prefix+"Year").value.search(/^\d{4}$/) == -1 ) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	return resultDate;
}

function select_daymonth_changed(name) {
	setDayList(id(name+"Day"),id(name+"Month").options[id(name+"Month").selectedIndex].value,id(name+"Year").value);
}

function dateResetValue(type, name) {
	var fromDate = "";
	var toDate = "";
	if (type == "all") {
		fromDate = "1000-01-01";
		toDate = "9999-12-31";
	} else if (type == "today") {
		var now = new Date(); 
		day = now.getDate();
		month = (now.getMonth() + 1);
		day = day < 10 ? "0" + day : day;
		month = month < 10 ? "0" + month : month;

		fromDate = now.getFullYear() + "-" + month + "-" + day;
		toDate = fromDate;
	} else if (type == "custom") {
		fromDate = buildDate(name + "From");
		toDate = buildDate(name + "To");
		if (isNaN(Date.parse(fromDate)) || isNaN(Date.parse(toDate))) {
			var now = new Date(); 
			fromDate = now.getFullYear() + "-" + now.getMonth() + "-" + now.getDate();
			toDate = fromDate;
			populateDateFields(name + "FromYear", now.getFullYear(), name + "FromMonth", now.getMonth(), name + "FromDay", now.getDate());
			populateDateFields(name + "ToYear", now.getFullYear(), name + "ToMonth", now.getMonth(), name + "ToDay", now.getDate());
		}
	}
	if(toDate < fromDate) {
		openMessage("Please enter a To date that is greater than or equal to the From date","a",120);
		return false;
	}
	id(name + "Hidden").value = type + ":" + fromDate + ":" + toDate;
}
