dlgRedirectLocation = "";

/**
 * dlgReservationFromTemplate - a modal dialog to create a reservation from a template
 * @param string rv_rate_type_id
 * @param string rv_agent_id
 * @param string rv_corr_persona_id
 * @param array itineraries
 * @param array datesOfStay
 * @param string redirectLocation
 * @param string title
 * @param int h
 * @param int w
 *
 * TODO: document the values within the array parameters
 * itineraries needs to be in the format:
 * 		[
 * 			{
 * 				ac_accomm_type_id : <accommodation_id>
 * 				pax_max : "2",
 * 				room_max : "2",
 * 				rt_rate_type_id : "RS11"
 * 			},
 * 			{
 * 				ac_accomm_type_id : "WB1"
 * 				pax_max : "2",
 * 				room_max : "2",
 * 				rt_rate_type_id : "RS12"
 * 			}
 * 			...
 * 		]
 *
 * datesOfStay needs to be in the format:
 * 		{
 * 			<arrival date> : {
 *				<bl_series_sequence_number> : {"allocation_item_id" (optional) : "RS121", "alloc_item_room_max" : 2, arrival_date: <first arrival date>, departure_date: <first departure date>},
 *				<bl_series_sequence_number> : {"allocation_item_id" (optional) : "RS122", "alloc_item_room_max" : 3, arrival_date: <second arrival date>, departure_date: <second departure date>},
 *				<bl_series_sequence_number> : {"allocation_item_id" (optional) : "RS123", "alloc_item_room_max" : 3, arrival_date: <third arrival date>, departure_date: <third departure date>},
 *				...
 * 			},
 * 			"2014-10-12" : [
 * 				"1" : {"allocation_item_id" (optional) : "RS124", "alloc_item_room_max" : 3, arrival_date : "2014-10-12", departure_date "2014-10-15"},
 * 				"2" : {"allocation_item_id" (optional) : "RS125", "alloc_item_room_max" : 2, arrival_date : "2014-10-15", departure_date "2014-10-18"},
 * 				...
 * 			]
 * 		}
 *
 * 	redirectLocation can have one of following values:
 * 		- "wizardStep2": reservation wizard step 2
 * 		- "availabilityCalendar" : availability calendar (TODO)
 * 		- "quickSearch" : quick search (TODO)
 *
 * Requires:
 * 	- jquery
 * 	- simplemodal
 *
 * Example usage:
 *		var dlgreservationfromtemplate = new dlgReservationFromTemplate(
 *			"RS123", 
 *			"RS222", 
 *			"RS333",
 *			itineraries, 
 *			datesOfStay, 
 *			"wizardStep2",
 *			"Create Reservation from Block", 
 *			"100%", 
 *			700
 *		);
 *		dlgreservationfromtemplate.init();
 */
this.dlgReservationFromTemplate = function(
	rv_agent_id, 
	rv_corr_persona_id, 
	itineraries, 
	datesOfStay, 
	redirectLocation,
	title, 
	h, 
	w,
	bl_block_period_ix) {

	var t = this;

	this.rv_agent_id = rv_agent_id;
	this.rv_corr_persona_id = rv_corr_persona_id;
	this.bl_block_period_ix = typeof bl_block_period_ix !== "undefined" ? bl_block_period_ix : null;
	this.itineraries = itineraries;
	var accommodationRates = [];
	this.rt_rate_type_id = null;
	$.each(this.itineraries, function(key, value) { 
		ac_accomm_type_id = value['ac_accomm_type_id'];
		accommodationRates.push(ac_accomm_type_id + ":" + value['rt_rate_type_id']);
		// Set default reservation rate type to first itinerary's rate type
		if (t.rt_rate_type_id == null) {
			t.rt_rate_type_id = value['rt_rate_type_id'];
		}
	});
	this.accommodationRates = accommodationRates;
	this.datesOfStay = datesOfStay;
	this.redirectLocation = redirectLocation;
	dlgRedirectLocation = redirectLocation;
	var arrivalDepartureDates = [];
	var allocations = [];
	var minRoomsForArrivalDate = {}; 
	var expiryForArrivalDate = {};
	$.each(this.datesOfStay, function(key, value) { 
		$.each(value, function(k, v) { 
			if (v['allocation_item_id'] != null && v['allocation_item_id'] != "") {
				allocations.push(v['allocation_item_id']);
			}
			if (minRoomsForArrivalDate.hasOwnProperty(key)) {
				if (parseInt(v['alloc_item_room_max']) < parseInt(minRoomsForArrivalDate[key])) {
					minRoomsForArrivalDate[key] = v['alloc_item_room_max'];
				}
			} else {
				minRoomsForArrivalDate[key] = v['alloc_item_room_max'];
			}
			if(!expiryForArrivalDate.hasOwnProperty(key)) {
				expiryForArrivalDate[key] = false;
			}
			if(v['expired']) {
				expiryForArrivalDate[key] = true;
			}
		});
	});
	this.minRoomsForArrivalDate = minRoomsForArrivalDate;
	this.arrivalDepartureDates = arrivalDepartureDates;
	this.allocations = allocations;
	this.step = 1;
	this.url = "reservation.php?6016";
	this.title = title;
	this.h = h;
	this.w = w;
	this.message = null;
	this.validator = new Validator();
	this.totalPax = 0;
	this.rateGroupTotals = {};

	this.init = function () {
		var t = this;
		// load the dialog css
		if (document.createStyleSheet) {
			// for ie
			document.createStyleSheet('/resource/Resrequest/Application/public/css/dialog.css');
		} else {
			$("head").append($("<link rel='stylesheet' href='/resource/Resrequest/Application/public/css/dialog.css' type='text/css' media='screen' />"));
		}

		// load the dialog form using ajax
		$.post(this.url, { 
			accommodationRates: t.accommodationRates.join(","), 
			allocations: t.allocations.join(","),
			arrivalDepartureDates: t.arrivalDepartureDates.join(",")
		}).done(function(data){
			// create a modal dialog with the data
			$(data).modal({
        closeHTML: "<i class='material-icons modal-close' style='color: white; cursor: pointer;'>close</i>",
				overlayId: 'dialog-overlay',
				containerId: 'dialog-container',
				zIndex: 80, // above main menu and also above "Req received; Contact us and Logoff"
				containerCss:{
					height:h, 
					width:w
				},
				autoPosition: true,
				autoResize: true,
				escClose: true,
				onOpen: function (dialog) {
					dialog.overlay.fadeIn(1, function () {
						dialog.container.fadeIn(1, function () {
							dialog.data.fadeIn(1, function () {
								$('#dialog-container form').fadeIn(1, function () {
									$("#main-content").width(w);
								});
							});
						});
					});
				},
				onShow: function (dialog) {
					$('#tdTitle').html(t.title);

					$("#chkIncludeExpired").click(function() {
						t.populateArrivalDate();
					});

					$("#btnGo").click(function() {
						if (t.validate()) {
							t.save();
						}
					});
					$("#btnBack").click(function() {
						var step = (t.step > 1) ? t.step - 1 : 1;
						t.dialogStep(step);
					});
					$("#btnNext").click(function() {
						if (t.validate()) {
							switch(t.step) {
								case 1:
									t.dialogStep(2);
									break;
								case 2:
									t.dialogStep(3);
									break;
								default:
									showMessage("There was an error determining the current process step","Error",261,140);
									break;
							}
              t.adjustDimension();
						}
					});
					t.pageView();
					t.validator.validateAll();
					t.validator.addConstraints();
					wait.hide();
				},
				onClose: function (dialog) {
					$('#dialog-container .dialog-message').fadeOut();
					$('#dialog-container form').fadeOut(1);
					dialog.data.fadeOut(1, function () {
						dialog.container.fadeOut(1, function () {
							dialog.overlay.fadeOut(1, function () {
								$.modal.close();
							});
						});
					});
				}
			});
		});
	}

	this.validate = function () {
		var t = this;
		t.message = [];

		switch(this.step) {
			case 1:
				if (id("selArrivalDate").value == "") {
					id("selArrivalDate").focus();
					t.message.push("Select an arrival date");
				}
				if (isNaN(id("txtRooms").value) || parseInt(id("txtRooms").value) < 1) {
					id("txtRooms").focus();
					t.message.push("Enter a number of rooms greater than 0");
				}
				if (id("txtRooms").value > parseInt(t.minRoomsForArrivalDate[id("selArrivalDate").value])) {
					showMessage("You have entered a number of rooms greater than the amount available for the selected arrival date. The excess rooms will not draw down from the selected arrival date.");
				}
				break;
			case 2:
				var roomCounter = 1;
				var totalPaxEntered = 0;
				$("#tblRoomsSplit").find("tbody tr").each(function() {
					var isEmpty = true;
					$(this).find("input").each(function() {
						if ($(this).val() != "" && parseInt($(this).val()) > 0) {
							isEmpty = false;
							totalPaxEntered += parseInt($(this).val());
						}
					});
					if (isEmpty) {
						t.message.push("Please enter a pax value for room " + roomCounter);
					}
					roomCounter += 1;
				});
				if (totalPaxEntered != t.totalPax) {
					t.message.push("The total pax does not equal the number specified in step 1");
				}
				break;
			case 3:
				break;
			default:
				break;
		}

		this.validator.validateAll();

		var validationError = $("#divReservationFromTemplate .validate_error").length;
		if (validationError > 0) {
			this.message.push("Please complete the required areas marked with an orange asterisk");
		}
		if (this.message.length > 0) {
			if (this.message.length > 0) {
				showValidationList(this.message, "Validation failure", 300, 200);
			}
			return false;
		}
		else {
			return true;
		}
	}

	this.populateArrivalDate = function () {
		let includeExpired = $("#chkIncludeExpired").prop("checked");

		$('#selArrivalDate').empty();
		$.each(t.datesOfStay, function(key, value) { 
			if(!includeExpired && expiryForArrivalDate[key]) {
				return;
			}
			var arrivalDate = new Date(key);
			var arrivalYear = arrivalDate.getFullYear();
			var arrivalMonth = arrivalDate.getMonthShortName();
			var arrivalMonthNumber = arrivalDate.getMonth() + 1;
			arrivalMonthNumber = (arrivalMonthNumber < 10) ? "0" + arrivalMonthNumber : arrivalMonthNumber;
			var arrivalDay = (parseInt(arrivalDate.getDate()) < 10) ? "0" + arrivalDate.getDate() : arrivalDate.getDate();
			var arrivalDateText = arrivalDay + " " + arrivalMonth + " " + arrivalYear;
			arrivalDateText += " (Rooms available: " + t.minRoomsForArrivalDate[arrivalDate.getFullYear() + "-" + arrivalMonthNumber + "-" + arrivalDay] + ")";
			$('#selArrivalDate').append($("<option/>", {
				value: key,
				text: arrivalDateText
			}));
		});
		var selArrivalDate = $('#selArrivalDate option');

		selArrivalDate.sort(function(a,b){
			a = new Date(a.value);
			b = new Date(b.value);

			return a % 2 - b % 2 || a - b;
		});
		$('#selArrivalDate').html(selArrivalDate);
		$('#selArrivalDate').prepend($("<option/>", {
			value: "",
			text: "Select a date"
		}));
		$('#selArrivalDate').val("");
	}

	this.pageView = function() {
		var t = this;
		var pagemode = id("dlg_reservation_from_template_mode").value;
		switch (pagemode) {
			case "modeNew":
				this.populateArrivalDate();
				this.dialogStep(1);
				var defaultAdultPax = "";
				$.each(this.itineraries, function(key, value) { 
					if (defaultAdultPax == "") {
						defaultAdultPax = value['pax_max'];
					}
				});
				// Set "adult" rate group with defailt pax
				$("[rt_rate_group_sys_code='2']").val(defaultAdultPax);
				break;
			case "modeEdit":
				break;
			default:
				this.readOnly();
				break;
		}
	}

	this.dialogStep = function(step) {
		var t = this;
		switch(step) {
			case 1:
				this.step = 1;
				$("#btnGo").hide();
				$("#btnBack").hide();
				$("#trStep1").show();
				$("#trStep2").hide();
				$("#trStep3").hide();
				$("#btnNext").show();
				break;
			case 2:
				var goToStep = null;
				if (this.step < 2 && parseInt($("#txtRooms").val()) == 1) {
					goToStep = 3;
				} else if (this.step > 2 && parseInt($("#txtRooms").val()) == 1) {
					goToStep = 1;
				}
				this.step = 2;
				$("#trStep1").hide();
				$("#trStep2").show();
				$("#trStep3").hide();
				$("#tblRoomsSplit").remove();
				$("#tblRoomsSplitReadOnly").remove();
				$("br[name=brStep3]").remove();
				var totalPax = 0;
				this.rateGroupTotals = {};
				$("#tblRateGroups").find("tbody tr:first").find("input").each(function() {
					var pax = ($.trim($(this).val()) == "") ? 0 : parseInt($(this).val()); 
					totalPax = totalPax + pax;
					if (t.rateGroupTotals.hasOwnProperty($(this).attr("rt_rate_group_ix"))) {
						t.rateGroupTotals[$(this).attr("rt_rate_group_ix")] += pax;
					} else {
						t.rateGroupTotals[$(this).attr("rt_rate_group_ix")] = pax;
					}
				});
				var tblRoomsSplit = $("#tblRateGroups").clone();
				tblRoomsSplit.prop("id", "tblRoomsSplit");
				tblRoomsSplit.find("tbody tr:first").find("input").each(function() {
					$(this).attr({
						id: $(this).attr("id") + "_1",
						name: $(this).attr("name") + "_RoomSplit",
						room_number: 1
					});
				});
				var numberRooms = parseInt($("#txtRooms").val());
				for (var i = 1; i < numberRooms; i++) {
					var roomNumber = i + 1;
					tblRoomsSplit.find("tbody tr:first").clone().find("input").each(function() {
						$(this).attr("id", $(this).attr("id").split("_")[0] + "_" + $(this).attr("id").split("_")[1] + "_" + roomNumber);
						$(this).attr("room_number", roomNumber);
						$(this).val("");
					}).end().appendTo(tblRoomsSplit);
				}
				// Set rate group values base on those defined in step 1
				var rateGroupCounter = 1;
				tblRoomsSplit.find("input").each(function() {
					var rateGroupValue = "";
					if (t.rateGroupTotals.hasOwnProperty($(this).attr("rt_rate_group_ix")) && parseInt(t.rateGroupTotals[$(this).attr("rt_rate_group_ix")]) % numberRooms === 0) {
						rateGroupValue = parseInt(t.rateGroupTotals[$(this).attr("rt_rate_group_ix")]) / numberRooms;
					} else {
						var roundedValue = Math.round(parseInt(t.rateGroupTotals[$(this).attr("rt_rate_group_ix")]) / numberRooms);
						if (rateGroupCounter == 1) {
							rateGroupValue = parseInt(t.rateGroupTotals[$(this).attr("rt_rate_group_ix")]) - (numberRooms - 1) * roundedValue;
							if (rateGroupValue < 0) {
								rateGroupValue = 0;
							}
						} else {
							rateGroupValue = roundedValue;
						}
					}
					$(this).val(rateGroupValue);
					rateGroupCounter += 1;
				});
				// Add row for room labels
				tblRoomsSplit.find('thead tr').each(function(){
					$(this).find('th').eq(0).before("<td class='outLt'>&nbsp;</td>");
				});
				// Add room labels
				var roomCounter = 1;
				tblRoomsSplit.find('tbody tr').each(function(){
					$(this).find('td').eq(0).before("<td class='bl bb' style='white-space: nowrap;'>Room " + roomCounter + "</td>");
					roomCounter += 1;
				});
				$("#divStep2RoomConfiguration").append(tblRoomsSplit);
				$("#divStep2RoomConfiguration").slideDown(50);
				$("[name=lblArrivalDate]").html($("#selArrivalDate option:selected").text().substring(0,11));
				$("[name=lblTotalPax]").html(totalPax);
				this.totalPax = totalPax;
				$("[name=lblTotalRooms]").html($("#txtRooms").val());
				$("#btnBack").show();
				$("#btnNext").show();
				$("#btnGo").hide();
				if (goToStep != null) {
					this.dialogStep(goToStep);
				}
				break;
			case 3:
				this.step = 3;
				$("#trStep1").hide();
				$("#trStep2").hide();

				$("#tblAccommodationBreakdown").remove();
				var tblAccommodationBreakdownHead = $("#tblRoomsSplit").find('thead').clone();
				var tblAccommodationBreakdownBody = $("#tblRoomsSplit").find('tbody tr').clone();
				var tblAccommodationBreakdown = $("<table>");
				tblAccommodationBreakdown.prop("id", "tblAccommodationBreakdown").addClass("table").css("width", "100%"); 
				tblAccommodationBreakdown.append(tblAccommodationBreakdownHead).append("<tbody>");
				var numberRateGroups = $("#tblRateGroups").find("tbody tr:first td").length + 1;
				var accommodationCounter = 0;

				$("#loaderCircle").show();
				$.post(
					"reservation.php?6016",
					{
						action: "fetchBlockAllocations",
						bl_block_period_ix: this.bl_block_period_ix,
						arrival: $("#selArrivalDate option:selected").val().substring(0,11)
					}
				)
				.done(function( result ) {
					var result = JSON.parse(result);
					$.each(itineraryDetails, function(key, value) { 
						itineraryDetails[key].ac_accomm_desc = result[key].ac_accomm_desc;
						itineraryDetails[key].ac_accomm_type_id = result[key].ac_accomm_type_id;
						itineraryDetails[key].property_description = result[key].property_description;
					});

					$.each(itineraries, function(key, value) { 
						itineraries[key].ac_accomm_type_id = result[key].ac_accomm_type_id;
						itineraries[key].rv_item_adult_count = result[key].rv_item_adult_count;
						itineraries[key].rv_item_accomm_count = result[key].rv_item_accomm_count;
					});

					$.each(itineraries, function(key, value) { 
						var propertyDescription = itineraryDetails[key]['property_description'];
						var accommodationDescription = itineraryDetails[key]['ac_accomm_desc'];
						var accommodationId = value['ac_accomm_type_id'];
						var newTd = $("<td>");
						newTd.prop("colspan", numberRateGroups).prop("id", "tdAccommodationTitle_" + accommodationCounter).addClass("outLt txtb").html(propertyDescription + " - " + accommodationDescription).css("background-color","white");
						tblAccommodationBreakdown.find('tbody:last').append($("<tr>").append(newTd));
						var roomCells = $("#tblRoomsSplit").find('tbody tr').clone();

						if (roomCells.length > itineraries[key].rv_item_accomm_count) {
							roomCells.splice(itineraries[key].rv_item_accomm_count);
						}

						roomCells.find("input").each(function() {
							if ($(this).val() > itineraries[key].rv_item_adult_count) {
								$(this).val(itineraries[key].rv_item_adult_count);
							}
							$(this).attr("ac_accomm_type_ix", accommodationId);
							$(this).closest("tr").attr("ac_accomm_type_ix", accommodationId);
							$(this).attr("accommodation_number", accommodationCounter);
						});
						tblAccommodationBreakdown.find('tbody:last').append(roomCells);
						accommodationCounter += 1;
					});
					// Add inputs for different rate groups that aren't part of *all* accommodations
					for (var itineraryNumber in itineraryDetails) {
						var rateGroups = itineraryDetails[itineraryNumber]['rate_groups'];
						var accommodation = itineraryDetails[itineraryNumber]['ac_accomm_type_id'];
						for (key in rateGroups) {
							var rateGroup = rateGroups[key]
							if ($("#thRateGroup_" + rateGroup['rt_rate_group_ix']).length == 0) {
								numberRateGroups += 1;
								tblAccommodationBreakdown.find("[id^='tdAccommodationTitle_']").prop("colspan", numberRateGroups);
								tblAccommodationBreakdown.find('thead th:last').after(
									"<th id='thRateGroup_" + rateGroup['rt_rate_group_ix'] + "' class='outLt' style='white-space: nowrap; min-width: 100px;'> " +
									"	<label>" + rateGroup['rt_rate_group_desc'] + "</label> " +
									"</th>"
								);
								tblAccommodationBreakdown.find('tbody tr').each(function(){
									if ($(this).find("td[id^='tdAccommodationTitle_']").length == 0) {
										$(this).find('td:last').after("<td class='bb br' style='text-align:center;background-color: white;'>&nbsp;</td>");
									}
								});
								tblAccommodationBreakdown.find("input[ac_accomm_type_ix='" + accommodation + "']").closest("tr").each(function() {
									var txtRateGroup = $(tblAccommodationBreakdown.find("input[ac_accomm_type_ix='" + accommodation + "']")[0]);
									var txtRateGroupNew = txtRateGroup.clone();
									txtRateGroupNew.val("0");
									var txtRateGroupProperties = txtRateGroup.prop("id").split("_");
									txtRateGroupNew.prop("id", txtRateGroupProperties[0] + "_" + rateGroup['rt_rate_group_ix'] + txtRateGroupProperties[2]);
									txtRateGroupNew.attr("rt_rate_group_sys_code", rateGroup['rt_rate_group_sys_code']);
									txtRateGroupNew.attr("rt_rate_group_ix", rateGroup['rt_rate_group_ix']);
									$(this).find("td:last").append(txtRateGroupNew);
								});
							}
						}
					}
	
					$("#divStep3AccommodationBreakdown").append(tblAccommodationBreakdown);
	
					$("#divStep3").prepend($("<br>").attr("name", "brStep3"));
	
					$("#divStep2RoomConfigurationB").remove();
					var divStep2RoomConfigurationB = $("#divStep2RoomConfiguration").clone();
					divStep2RoomConfigurationB.prop("id", "divStep2RoomConfigurationB"); 
					divStep2RoomConfigurationB.find("#tblRoomsSplit").remove(); 
					$("#tblRoomsSplitReadOnly").remove();
					var tblRoomsSplitReadOnly = $("#tblRoomsSplit").clone();
					tblRoomsSplitReadOnly.prop("id", "tblRoomsSplitReadOnly");
					tblRoomsSplitReadOnly.find("tr").find("input").each(function() {
						var inputVal = ($.trim($(this).val()) == "") ? "-" : $(this).val();
						$(this).closest("td").html(inputVal);
						$(this).remove();
					})
					divStep2RoomConfigurationB.append(tblRoomsSplitReadOnly);
					$("#divStep3").prepend(divStep2RoomConfigurationB);
					if (parseInt($("#txtRooms").val()) == 1) {
						divStep2RoomConfigurationB.hide();
						$("#spaStep3Title").html("Step 2 - Accommodation Breakdown");
					} else {
						$("#spaStep3Title").html("Step 3 - Accommodation Breakdown");
					}
	
					$("#divStep3").prepend($("<br>").attr("name", "brStep3"));
	
					$("#divStep1C").remove();
					var divStep1C = $("#divStep1B").clone();
					divStep1C.prop("id", "divStep1C"); 
					$("#divStep3").prepend(divStep1C);
	
					$("#trStep3").show();
					$("#divStep3AccommodationBreakdown").slideDown(50);
					$("#loaderCircle").hide();
					$("#btnNext").hide();
					$("#btnGo").show();
					$("#btnBack").show();
					$("#divStep3AccommodationBreakdown").width($("#tblAccommodationBreakdown").width());

				}); 



				break;
			default:
				break;
		}
	}

	this.readOnly = function() {
	}

	this.save = function() {
		var t = this;
		wait.show('circle');
		$.modal.close();

		var firstArrivalDate = $("#selArrivalDate").val();

		var accommodationBreakdown = [];
		// Get a list of all the rate group configurations as specified by the user for each room
		$("#tblAccommodationBreakdown").find("tr").each(function() {
			var room = {
				'ac_accomm_type_id' : $(this).attr("ac_accomm_type_ix"),
				'rate_groups' : {}
			};
			var rateGroups = {};
			var accommodation_number = "";
			$(this).find("input").each(function() {
				if (accommodation_number == "") {
					accommodation_number =  $(this).attr('accommodation_number');
				}
				var pax = ($.trim($(this).val()) == "") ? 0 : parseInt($(this).val());
				rt_rate_group_ix = $(this).attr("rt_rate_group_ix");
				if (!rateGroups.hasOwnProperty(rt_rate_group_ix)) {
					rateGroups[rt_rate_group_ix] = pax;
				} else {
					rateGroups[rt_rate_group_ix] += pax;
				}
			});
			room['rate_groups'] = rateGroups;
			if (typeof accommodation_number != 'undefined') {
				if (!accommodationBreakdown.hasOwnProperty(accommodation_number)) {
					accommodationBreakdown[accommodation_number] = [];
				}
				accommodationBreakdown[accommodation_number].push(room);
			}
		});
		// Merge rooms together if their the same. i.e. if two rooms have identical
		// configurations merge them by adding the rooms together
		var accommodationRooms = {};
		for (accommodationNumber in accommodationBreakdown) {
			var rooms1 = accommodationBreakdown[accommodationNumber];
			var rooms2 = accommodationBreakdown[accommodationNumber];
			accommodationRooms[accommodationNumber] = {};
			for (room1 in rooms1) {
				accommodationRooms[accommodationNumber][room1] = 1;
				var roomA = rooms1[room1];
				for (room2 in rooms2) {
					if (room1 !== room2) {
						var roomB = rooms2[room2];
						if (this.equals(roomA, roomB)) {
							accommodationRooms[accommodationNumber][room1] += 1;
							delete accommodationBreakdown[accommodationNumber][room2];
						}
					}
				}
			}
		}

		// Build itineraries in the format expected by php function "createReservationInProgress"
		var itineraries = [];
		for (accommodationNumber in accommodationBreakdown) {
			accommodationNumber = parseInt(accommodationNumber);
			var rooms = accommodationBreakdown[accommodationNumber];
			var bl_series_sequence_number = accommodationNumber + 1;
			for (room in rooms) {
				var itinerary = rooms[room];
				var numberRooms = accommodationRooms[accommodationNumber][room];
				if (parseInt(numberRooms) > 0) {
					var rateGroups = rooms[room]['rate_groups'];
					var rateGroupsArray = [];
					rateGroupsArray.push({
						'rt_rate_group_ix' : id("hidUnitRateGroupId").value,
						'name' : "",
						'qty' : numberRooms
					});
					for (rt_rate_group_ix in rateGroups) {
						if (rt_rate_group_ix != "numberRooms") {
							var rateGroupQuantity = rateGroups[rt_rate_group_ix];
							if (parseInt(rateGroupQuantity) > 0) {
								var rateGroupArray = {
									'rt_rate_group_ix' : rt_rate_group_ix,
									'name' : "",
									'qty' : rateGroupQuantity
								};
								rateGroupsArray.push(rateGroupArray);
							}
						}
					}
					itinerary['rate_groups'] = rateGroupsArray;
					itinerary['rt_rate_type_id'] = this.itineraries[accommodationNumber]['rt_rate_type_id'];
					itinerary['allocation_item_id'] = t.datesOfStay[firstArrivalDate][bl_series_sequence_number]['allocation_item_id'];
					itinerary['arrival_date'] = t.datesOfStay[firstArrivalDate][bl_series_sequence_number]['arrival_date'];
					itinerary['departure_date'] = t.datesOfStay[firstArrivalDate][bl_series_sequence_number]['departure_date'];
					itineraries.push(itinerary);
				}
			}
		}

		var sNames = [
			'rt_rate_type_id',
			'rv_agent_id',
			'rv_corr_persona_id',
			'rv_item_split_yn',
			'firstArrivalDate',
			'datesOfStay',
			'itineraries',
			'bl_block_period_ix'
		];
		var sValues	= [
			this.rt_rate_type_id,
			this.rv_agent_id,
			this.rv_corr_persona_id,
			0,
			firstArrivalDate,
			serialize(this.datesOfStay),
			serialize(itineraries),
			this.bl_block_period_ix
		];
		var url = dglActionNewPersistUrl;
		aRequestPost(url, this.afterSave, sNames, sValues);
	}

	this.afterSave = function(cStatus,cData) {
		if (!cStatus) {
			return;
		}
		cDataArray = cData.split("\n");
		try {
			payload = JSON.parse(cDataArray[0]);
		}catch(e){
			payload = {"result": "fail"};
		}
		if (payload["result"] != "success") {
			showMessage(cData);
			showMessage("There was an error creating the reservation","Error",261,140);
			wait.hide();
		} else { 
			wait.show('circle');
			switch(dlgRedirectLocation) {
				case "wizardStep2":
					window.location = "/reservation.php?639";
					break;
				case "availabilityCalendar":
					// TODO
					break;
				case "quickSearch":
					// TODO
					break;
				default:
					wait.hide();
					showMessage("There was an error redirecting to the appropriate page","Error",261,140);
					break;
			}
		}
	}

	this.equals = function( x, y ) {
		if ( x === y ) return true;
		// if both x and y are null or undefined and exactly the same
		if ( ! ( x instanceof Object ) || ! ( y instanceof Object ) ) return false;
		// if they are not strictly equal, they both need to be Objects
		if ( x.constructor !== y.constructor ) return false;
		// they must have the exact same prototype chain, the closest we can do is
		// test there constructor.
		for ( var p in x ) {
			if ( ! x.hasOwnProperty( p ) ) continue;
			// other properties were tested using x.constructor === y.constructor
			if ( ! y.hasOwnProperty( p ) ) return false;
			// allows to compare x[ p ] and y[ p ] when set to undefined
			if ( x[ p ] === y[ p ] ) continue;
			// if they have the same strict value or identity then they are equal
			if ( typeof( x[ p ] ) !== "object" ) return false;
			// Numbers, Strings, Functions, Booleans must be strictly equal
			if ( ! this.equals( x[ p ],  y[ p ] ) ) return false;
			// Objects and Arrays must be tested recursively
		}

		for ( p in y ) {
			if ( y.hasOwnProperty( p ) && ! x.hasOwnProperty( p ) ) return false;
			// allows x[ p ] to be set to undefined
		}
		return true;
	}

	this.adjustDimension = function() {
		// if it moves above the top of the window
		if ($("#dialog-container").position().top < 0) {
			$("#dialog-container").offset({top: 0 });
		}
	}
};
