/**
 * dlgReservationList - a modal dialog to show a list of reservations
 * @param <jQuery element object> invokerElement
 * @param string url
 * @param string title
 * @param int h
 * @param int w
 * @param string periodTable
 *
 * Requires:
 * 	- jquery
 * 	- simplemodal
 *
 * Example usage:
 *	var dlgreservationlist = new dlgReservationList('#spaBlockDrawDowns', 'reservation.php?6014+RS123,RS124,RS125', 'Reservation List : Block RS111', 500, 770, null);
 *	dlgreservationlist.init();
 * 	
 */
this.dlgReservationList = function(invokerElement, url, title, h, w, periodTable) {

	this.invokerElement = invokerElement;
	this.url = url;
	this.title = title;
	this.h = h;
	this.w = w;
	this.periodTable = periodTable;
	this.message = null;

	this.init = function () {
		var t = this;
		// load the dialog css
		if (document.createStyleSheet) {
			// for ie
			document.createStyleSheet('/resource/Resrequest/Application/public/css/dialog.css');
		} else {
			$("head").append($("<link rel='stylesheet' href='/resource/Resrequest/Application/public/css/dialog.css' type='text/css' media='screen' />"));
		}
		$(invokerElement).click(function (e) {
			if (!e) { e = window.event; }
			stopBubble(e);
			e.preventDefault();

			wait.show('circle');

			// load the dialog form using ajax
			$.get(url, function(data){
				// create a modal dialog with the data
				$(data).modal({
					closeHTML: "<i class='material-icons modal-close' style='color: white; cursor: pointer;'>close</i>",
					overlayId: 'dialog-overlay',
					containerId: 'dialog-container',
					zIndex: 80, // above main menu and also above "Req received; Contact us and Logoff"
					containerCss:{
						height:h, 
						width:w
					},
					autoPosition: true,
					escClose: true,
					onOpen: function (dialog) {
						dialog.overlay.fadeIn(1, function () {
							dialog.container.fadeIn(1, function () {
								dialog.data.fadeIn(1, function () {
									$('#dialog-container form').fadeIn(1, function () {
										wait.hide();
									});
								});
							});
						});
					},
					onShow: function (dialog) {
						$('#tdTitle').html(t.title);

						$("#btnClose").click(function() {
							$.modal.close();
						});

                        $('.tooltip').not('.tooltipstered').tooltipster({
                            theme: 'tooltipster-shadow',
                            side: 'bottom',
                            contentAsHTML: true
                        });

						t.pageView();
					},
					onClose: function (dialog) {
						$('#dialog-container .dialog-message').fadeOut();
						$('#dialog-container form').fadeOut(1);
						dialog.data.fadeOut(1, function () {
							dialog.container.fadeOut(1, function () {
								dialog.overlay.fadeOut(1, function () {
									$.modal.close();
								});
							});
						});
					}
				});
			});
		});
	}

	this.validate = function () {
	}

	this.pageView = function() {
		var pagemode = id("reservation_list_popup_mode").value;
		switch (pagemode) {
			case "modeNew":
				break;
			case "modeEdit":
				break;
			case "modeView":
				this.readOnly();
				break;
			default:
				this.readOnly();
				break;
		}
	}

	this.readOnly = function() {
	}
};
