var wetuLandingURL = 'https://wetu.com/Itinerary/Landing/';
var actionRegenerate = 0;
var wetuID = '';

function yes() {
	alert("yes");
}

function no() {
	alert("no");
}

function viewWetu(wetuID) {
	url = wetuLandingURL+wetuID;
	window.open(url,'_blank');
}

function viewWetuOutdated(wetuID) {
	// Display warning
	var buttons = {
		'a':{'label':'View', 'callback':'viewWetu(\''+wetuID+'\')', 'class':''},
		'b':{'label':'Regenerate', 'callback':'generateWetu(\''+record+'\')', 'class':''},
		'c':{'label':'Cancel', 'callback':'', 'class':''}
	};
	overlayPopup('',
		'Your existing Wetu itinerary might be out of date and probably needs to be regenerated.',
		buttons
	);
}

function generateWetu(record) {
	wait.show();
	url = "reservation.php?3004+" + record;
	aRequestPost(url,processWetuAJAX,"","");
}

function regenerateWetu(record) {
	var buttons = {
		'a':{'label':'Yes', 'callback':'generateWetu(\''+record+'\')', 'class':''},
		'b':{'label':'No', 'callback':'', 'class':''}
	};
	overlayPopup('',
		'Your booking has been changed. Regenerating will replace your Wetu itinerary.<br><br>Are you sure you want to continue?',
		buttons
	);
}

function processWetuAJAX(result,response) {
	if (result) {
		wait.hide();
		var result = JSON.parse(response);

		switch(result.status) {
			case 0: 	// Success
				wait.hide();
				$("#wetuButtonText").text("View Wetu");
				$("#wetuButtonText").attr("onclick","viewWetu('"+result.desc[0]+"')");
				url = wetuLandingURL+result.desc[0];
				window.open(url,'_blank');
                $("#trans").remove();
				break;
			case 10: 	// No data
				overlayPopup('', 'No data received from Wetu');
				break;
			case 20: 	// Missing mapping
				var buttons = {
					'a':{'label':'OK', 'callback':'', 'class':''},
					'b':{'label':'Mapping page', 'callback':'openMapping()', 'class':''}
				};
				overlayPopup('Mapping',
					'All properties must be mapped before Wetu documents can be displayed.<br><br>The following properties and / or accommodations are not mapped:<br><br>'+result.desc,
					buttons
				);
				break;
			case 30: 	// Overlapping itineraries
				overlayPopup('Overlapping Itineraries', 'There are overlapping itineraries on the following dates:<br><br>'+result.desc);
				break;
			case 40: 	// Itinerary gaps
				overlayPopup('Itinerary Gaps', 'There are gaps in your itineraries on the following dates:<br><br>'+result.desc);
				break;
			case 50: 	// Error
				overlayPopup('Error', 'An error occurred:<br><br>'+result.desc);
				break;
			default: 	// Fallback response
				overlayPopup('', 'An unknown error has occurred. Please try again.');
		}
	}
	
}

function openMapping() {
	window.location.href = "reservation.php?3005";
}

function wetuGenerate() {
	id("runWetu").value = "generate";
	document.forms[0].submit();
}

function refreshWetuButtons(record) {
	if ($(".wetuButton").length) {
		$.post("reservation.php?3004", {record: record, action: "wetuGenerationStatus"})
		.done(function( result ) {
			$(".wetuButton").remove();
			$("#documentsDropdown").append(result);
		});
	}
}