function initialisePage(){
	try {
		opener.document.body.setCapture();
	} catch(e) {}
	document.body.className = "colLt";
	updateCurrency();
	updateTotal();

	id("expiryDay").selectedIndex = expiryDay;
	id("expiryMonth").selectedIndex = expiryMonth;
	id("expiryYear").value = expiryYear;

	if(bankCount == "0") {
		id("missingBankDiv").className="";
		selectList = document.getElementsByTagName("select");
		for(count=0;count<selectList.length;count++) {
			selectList[count].style.visibility = "hidden";
		}
	}
	id("selBank").focus();

	if(needGL == "1") {
		id("glCell").className = "expand";
	}

	if (missingFolio == "1"){
		opener.missingFolio();
		window.close();
	}	
	
}

function windowClose(){   
	try {
		opener.document.body.releaseCapture();
	} catch(e) {}
	window.close();
}

function processForm(pShowFolio,ignoreGLExchange) {
	checkAmountReceipted();
	updateTotal();

	if ( selValue("selMethod") == "0" ) {
		id("selMethod").focus();
		openMessage("Please select a valid method of payment","a",100);
		return false;
	}

	if ( id("amountPaid").value == "" || id("amountPaid").value == 0 ) {
		id("amountPaid").focus();
		openMessage("Please enter a valid amount paid","a",100);
		return false;
	}

	var recAmount = parseFloat(id("amountReceipt").value);
	var folioAmount = parseFloat(id("amount_total").value);

	if (allowVoid != 1) {
		if(recAmount < 0 || folioAmount < 0) {
			id("amountReceipt").focus();
			openMessage("Negative amounts are not allowed when access to void is disabled.");
			return false;
		}
	}

	if(recAmount > 9999999999999.99 || folioAmount > 9999999999999.99) {
		id("amountPaid").focus();
		openMessage("No payment amount may exceed 9,999,999,999,999.99. If you need to pay an amount in excess of this it will need to be split over multiple payments.");
		return false;
	}

	if(id("paymentCurr").innerHTML != id("folioCurr").innerHTML) {
		if(isNaN(parseFloat(id("exchangeRate").value.toString()))) {
			openMessage("Please enter a valid exchange rate.","a",100);
			return false;
		}
	}

	if(needGL == "1" && "!gl_currency_id!" != "!folio_currency_id!" && !ignoreGLExchange) {
		if(isNaN(parseFloat(id("glExchangeRate").value.toString()))) {
			//openMessage("Please enter a valid GL exchange rate.","a",100);
			confirmAction = "glExchangeRate";
			confirmShowFolio = pShowFolio;
			openConfirm("You have not entered a valid GL exchange rate. Would you like to continue?");
			return false;
		}
	}

	if ( pShowFolio ) {
		id("showFolio").value = "1";
	}
	if(ignoreGLExchange) {
		id("glExchangeRate").value = "";
	}
	id("glExchangeRate").disabled = false;
	$(".saveButton").attr("disabled", "disabled");
	$(".saveButton").val("Saving");
	id("payForm").submit();
}

function requestClick() {
	if(id("requestCheck").checked && id("requestReason").value == "") {
		id("requestReason").value = FirstName + " " + LastName + ": " + dateNow + "\n";
	}
}

var confirmAction;
var confirmShowFolio;
function processResponse() {
	if(confirmAction == "glExchangeRate") {
		processForm(confirmShowFolio,true);
	}
}

function updateCurrency() {

	
	id("paymentCurr").innerHTML = bankCurrencyNameArray[selValue("selBank")];
	id("selCurrency").value = bankCurrencyIdArray[selValue("selBank")];
	id("payment_currency_id").value = bankCurrencyIdArray[selValue("selBank")];
	id("amountPaidCurrency").value = bankCurrencyNameArray[selValue("selBank")];
	id("amountReceiptCurrency").value = bankCurrencyNameArray[selValue("selBank")];
	id("changeNeededCurrency").value = bankCurrencyNameArray[selValue("selBank")];
	id("changePaymentCurrency").innerHTML = selLabel("changeCurrency");;
	id("changeReceiptCurrency").innerHTML = bankCurrencyNameArray[selValue("selBank")];;
	id("changeConvertedCurrency").value = selLabel("changeCurrency");

	if(id("paymentCurr").innerHTML == id("folioCurr").innerHTML) {
		id("exchangeRate").disabled = true;
		id("expiryDay").disabled = true;
		id("expiryMonth").disabled = true;
		id("expiryYear").disabled = true;
		id("exchangeTable").style.display = "none";
		
	} else {
		id("exchangeRate").disabled = false;
		id("expiryDay").disabled = false;
		id("expiryMonth").disabled = false;
		id("expiryYear").disabled = false;
		id("exchangeTable").style.display = "";
		if(id("curr"+id("payment_currency_id").value+"_"+id("folio_currency_id").value)) {
			id("exchangeRate").value = id("curr"+id("payment_currency_id").value+"_"+id("folio_currency_id").value).value;
		}
	}
	if(selValue("changeCurrency") == bankCurrencyIdArray[selValue("selBank")]) {
		id("changeExchangeTable").style.display = "none";
		id("changeExchangeRate").value = "1";
	} else {
		id("changeExchangeTable").style.display = "";
		var changeExchangeKey = "curr"+id("payment_currency_id").value+"_"+selValue("changeCurrency");
		if(id(changeExchangeKey)) {
			id("changeExchangeRate").value = id(changeExchangeKey).value;
		} else {
			id("changeExchangeRate").value = "";
		}
	}

/*	id("invoiceCurrency").value = bankCurrencyNameArray[selValue("selBank")];
	id("invoiceCurrency2").innerHTML = bankCurrencyNameArray[selValue("selBank")];
	if(id("invoiceCurrency").value == id("glCurrency").value) {
		id("glExchangeRate").value = 1;
	}

	if(needGL == "1" && id("invoiceCurrency").value != id("glCurrency").value) {
		id("glCell").className = "expand";
	} else {
		//id("glCell").className = "collapse printCollapse";
	}*/
	
	updateTotal();
}

function updateTotal() {
	totalPaid = id("amountPaid").value;
	total = id("amountReceipt").value;
	changeNeeded = totalPaid - total;
	if(id("paymentCurr").innerHTML != id("folioCurr").innerHTML) {
		total = total * id("exchangeRate").value;
	}

	var glTotal = total * id("glExchangeRate").value;

	if(id("changeExchangeRate").value != "") {
		changeExchange = parseFloat(id("changeExchangeRate").value);
	} else {
		changeExchange = 1;
	}
	changeConvertedValue = changeNeeded * changeExchange;
	
	if(!isNaN(parseFloat(total))) {
		id("amount_total").value = parseFloat(total).toFixed(2);
		id("invoiceAmount").value = parseFloat(total).toFixed(2);
	} else {
		id("amount_total").value = "0.00";
		id("invoiceAmount").value = "0.00";
	}
	if(!isNaN(parseFloat(glTotal))) {
		id("glAmount").value = parseFloat(glTotal).toFixed(2);
	} else {
		id("glAmount").value = "0.00";
	}
	if(!isNaN(parseFloat(changeNeeded))) { 
		id("changeNeeded").value = parseFloat(changeNeeded).toFixed(2);
	} else {
		id("changeNeeded").value = "0.00";
	}
//	alert(changeConvertedValue);
	if(!isNaN(parseFloat(changeConvertedValue))) {
		id("changeConverted").value = parseFloat(changeConvertedValue).toFixed(2);
	} else {
		id("changeConverted").value = "0.00";
	}

	
}

function billing_contact_popup() {
   openPopup("reservation.php?692+9",350,525);
}

function selectContact(e) {
	if(!e) { e = event; }
	if (id("contactList").style.display == 'none') {
	id("contactList").style.display = "";
	id("contactList").style.left = getLeft("btnContact") + id("btnContact").offsetWidth - id("contactList").offsetWidth + 2;
	id("contactList").style.top = id("btnContact").offsetHeight + getTop("btnContact") + 2;
	e.cancelBubble = true;
	return false;
	} else {
		id("contactList").style.display = "none";
	}
}

function closeContact() {
	if(id("contactList").style.display == "") {
		id("contactList").style.display = "none";
	}
}

function getLeft(objId) {
	curr = id(objId);
	currLeft = 0;
	while(curr && curr.tagName != "BODY") {
		currLeft += curr.offsetLeft;
		curr = curr.offsetParent;
	}
	return currLeft;
}


function getTop(objId) {
	curr = id(objId);
	currTop = 0;
	while(curr && curr.tagName != "BODY") {
		currTop += curr.offsetTop;
		curr = curr.offsetParent;
	}
	return currTop;
}

function pickContact(name,pr_persona_ix) {
	id("billing_contact").value = unescape(name);
	id("rv_billing_persona_id").value = pr_persona_ix;
	id("contactList").style.display = "none";
	id("selMethod").style.visibility = "";
	id("selBank").style.visibility = "";
}

function checkAmountReceipted() {
	if(id("amountReceipt").value == "") {
		id("amountReceipt").value = id("amountPaid").value;
	}
}

