var is_ie = document.all ? true : false;

function itinScroll() {
    id("roomRowDiv").scrollTop = id("itinrows").scrollTop;
    id("colRows").scrollLeft = id("itinrows").scrollLeft;
}

function colScroll() {
    id("itinrows").scrollLeft = id("colRows").scrollLeft;
}

function initialisePage(){
    Set_Cookie("mainWindowPage",mainWindowPage);
    dateSelector();
    initTop();
    enableButtons(enabledButtons);
    toolbar['Print'].disable();

    // Get print info ------------------------------------------------------------
    id("user").innerHTML = FirstName + " " + LastName;
    id("server").innerHTML = Domain;

    // Rooming calendar loaded
    id("loading_notify").style.display = "none";
    id("urlForm").style.visibility = "visible";
    id("unallocated_res").style.visibility = "visible";
    document.body.style.cursor = "default";

    // Set the date picker to the generated date ---------------------------------
    populateDateFields("fromYear", fromY, "fromMonth", fromM, "fromDay", fromD);

    id("showHideForm").style.display = "none";

    id("resItemListDiv").style.height = "130px";
    id("resItemListDiv").style.width = "770px";
    id("resItemListDiv").style.overflowY = "scroll";

    id("colRows").style.overflowX = "hidden";
    id("colRows").style.width = "672px";
    id("colRows").onscroll = colScroll;

    id("itinrows").onscroll = itinScroll;

    if ( startupMessage != "" ) {
        showMessage(startupMessage);
    }

    if ( startupList.length > 0 ) {
        showList(startupList, startupListTitle);
    }

    resetCalendar();

    var tmpScroll;
    tmpScroll = Get_Cookie("roomingCalendarScrollLeft");

    if ( tmpScroll ) {
        id("itinrows").scrollLeft = tmpScroll;
    }

    tmpScroll = Get_Cookie("roomingCalendarScrollTop");
    if ( tmpScroll ) {
        id("itinrows").scrollTop = tmpScroll;
    }

    // IE vs Firefox measurements ------------------------------------------------
    if ( is_ie ) {
        id("colTopLeft").style.height = "50px";
        id("btnNextDays").style.marginBottom = "17px";
    } else {
        id("colTopLeft").style.height = "63px";
        id("btnNextDays").style.marginBottom = "20px";
    }

    if(Get_Cookie("roomingCalendarFullSize") == "1") {
        resizeGrid();
    }
}

function select_daymonth_changed() {
    setDayList(id("fromDay"),id("fromMonth").options[id("fromMonth").selectedIndex].value,id("fromYear").value);
}

function showHideFilters() {
    var filters = id("filters");
    var filterBut = id("filterBut");

    if ( filters.className == "expand" || filters.className == "" ) {
        filters.className = "collapse printCollapse";
        filterBut.value = ">> Show Filters";
    } else {
        filters.className = "expand";
        filterBut.value = "<< Hide Filters";
    }
}

function showHide(e, above, headDate) {

    if ( !e )	var e = window.event;

    if ( id("showHideForm").style.display == "none" || id("headDate").value != headDate ) {
        // Figure out where the mouse is...
        var clickX = 0;
        var clickY = 0;

        if ( e.pageX || e.pageY ) 	{
            clickX = e.pageX;
            clickY = e.pageY;
        } else if ( e.clientX || e.clientY ) 	{
            clickX = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
            clickY = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
        }

        screenW = windowWidth();
        screenH = windowHeight();

        id("showHideForm").style.display = "";

        /*
        clickX = e.x + window.document.body.scrollLeft;
        clickY = e.y + window.document.body.scrollTop;
*/
        newX = clickX - id("showHideForm").offsetWidth;
        newY = clickY+4;

        if ( e.y > (screenH / 2) ) {
            newY = clickY - id("showHideForm").offsetHeight-4;
        }

        id("showHideForm").style.left = newX;
        id("showHideForm").style.top = newY;
    } else {
        id("showHideForm").style.display = "none";
    }

    id("headDate").value = headDate;

    e.cancelBubble = true;
    if (e.stopPropagation) e.stopPropagation();
}

function openFilter(filter){
    var selectedArray = id(filter + "Ids").value;

    url = "reservation.php?661+"
        + filter
        + "+"
        + selectedArray;

    openPopup(url,280,360);
}

function buildURL(renderOption,newDate) {

    renderOption &= 7;

    if(!(id("filters").className == "expand")) {
        renderOption += 8;
    }

    _urlCount++;

    if(!buildDate("from")) {
        return false;
    }
    if(newDate) {
        fromDate = newDate;
    } else {
        fromDate = buildDate("from");
    }

    var accommSort = 0;
    if(id('accommSortRoom').checked) {
        var accommSort = 1;
    }

    var advancedDisplay = "1";
    if ( id("advancedForm").className != "colLt" ) {
        advancedDisplay = "0";
    }
    url = new Array("reservation.php?234",
        /*  1 */ fromDate,
        /*  2 */ id("accommIds").value, //selValue("propertyId"),
        /*  3 */ renderOption, // options
        /*  4 */ _randomId + "_" + _urlCount.toString(),
        /*  5 */ accommSort, // accommodation sort
        /*  6 */ id("days").value,
        /*  7 */ (id("showResNum").checked?"1":"0"),
        /*  8 */ (id("showResName").checked?"1":"0"),
        /*  9 */ (id("showGuestName").checked?"1":"0"),
        /* 10 */ advancedDisplay
    );
    return url.join("+");
}

function buildDate(prefix) {
    dayValue = id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
    monthValue = id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

    dayValue = dayValue<10?"0"+dayValue:dayValue;
    monthValue = monthValue<10?"0"+monthValue:monthValue;

    resultDate = id(prefix+"Year").value+"-"+monthValue+"-"+dayValue;

    if(dayValue < 1) {
        id(prefix+"Day").focus();
        openMessage("Please enter a valid "+prefix+" date","a",100);
        return false;
    }
    if(monthValue < 1) {
        id(prefix+"Month").focus();
        openMessage("Please enter a valid "+prefix+" date","a",100);
        return false;
    }
    if(id(prefix+"Year").value == "") {
        id(prefix+"Year").focus();
        openMessage("Please enter a valid "+prefix+" date","a",100);
        return false;
    }
    if(id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
        id(prefix+"Year").focus();
        openMessage("Please enter a valid "+prefix+" date","a",100);
        return false;
    }

    return resultDate;
}

function generateReport(num,newDate) {
    Set_Cookie("roomingCalendarScrollLeft",id("itinrows").scrollLeft);
    Set_Cookie("roomingCalendarScrollTop",id("itinrows").scrollTop);
    url = buildURL(num,newDate);
    if(url) {
        id("urlForm").target = "_self";
        id("url").value = url;
        id("urlForm").submit();
    }
}

function openPDF() {
    url = buildURL(1)
    if(url) {
        id("url").value = url;
        id("urlForm").target = "pdfWin";
        pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
    }
}

function sendPDF(){
    url = buildURL(2);
    if(url) {
        id("url").value = url;
        id("urlForm").target = "pdfWin";
        pdfWin = openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",775,615,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
    }
}

function openCSV(){
    var url = buildURL(4);
    if(url) {
        id("urlForm").target = "_self";
        id("url").value = url;
        id("urlForm").submit();
    }
}


function openPax(paxType) {
    /*if(propId == "DISABLED") {
        openMessage("This report is disabled when multiple properties are selected.");
        return false;
    }*/
    if(paxType) {
        var perHead = "Date";
        var endDate = toDate;
        var type = "range";
    } else {
        var perHead = "Accomm";
        var endDate = "";
        var type = "day";
    }
    var startDate = id("headDate").value;
    var url = new Array(
        "reservation.php?737",
        /*  1 */ "",
        /*  2 */ startDate,
        /*  3 */ endDate,
        /*  4 */ "",
        /*  5 */ "",
        /*  6 */ type,
        /*  7 */ "",
        /*  8 */ "",
        /*  9 */ "", // nationality ids
        /* 10 */ "", // render option
        /* 11 */ "1", // confirmed
        /* 12 */ "1", // provisional
        /* 13 */ "", // source ids
        /* 14 */ "", // random id
        /* 15 */ "",
        /* 16 */ id("accommIds").value
    );

    //alert(url);
    openPopup(url.join("+"),1000,600,'','',false,1);
}

function openArrDep(){
    if(propId == "DISABLED") {
        openMessage("This report is disabled when multiple properties are selected.");
        return false;
    }
    var startDate = id("headDate").value;
    var endDate = "range";
    var perHead = "Date";
    var url = new Array(
        "reservation.php?742",
        propId,		//1
        startDate,//2
        endDate,  //3
        "", 		  //4
        perHead	  //5	
    );
    openPopup(url.join("+"),695,500);
}

function openExtras(){
    if(propId == "DISABLED") {
        openMessage("This report is disabled when multiple properties are selected.");
        return false;
    }
    var startDate = id("headDate").value;
    var url = new Array(
        "reservation.php?739",
        propId,		//1
        startDate//2
    );
    openPopup(url.join("+"),1000,600,'','','',1);
}

function openDaySheet() {
    if(propId == "DISABLED") {
        openMessage("This report is disabled when multiple properties are selected.");
        return false;
    }
    var startDate = id("headDate").value;
    var endDate = "";
    var url = new Array(
        "reservation.php?741",
        propId,		//1
        startDate,//2
        endDate  //3
    );

    //alert(url);
    openPopup(url.join("+"),1000,600,'','','',1);
}

function openFoliosReport(reportType){
    if(propId == "DISABLED") {
        openMessage("This report is disabled when multiple properties are selected.");
        return false;
    }
    var startDate = id("headDate").value;
    var url = new Array(
        "reservation.php?740",
        propId,		 //1
        startDate, //2
        '',        //3
        '',        //4
        reportType //5
    );
    openPopup(url.join("+"),1000,600,'','','',1);
}

function disableFunction(fName) {
    if(id("btn"+fName)) {
        id("btn"+fName).disabled = true;
        id("btn"+fName).style.color = "#838383";
    }
    if(id("row"+fName)) {
        id("row"+fName).style.display = "none";
    }
}

function enableFunction(fName) {
    if(id("btn"+fName)) {
        id("btn"+fName).disabled = false;
        id("btn"+fName).style.color = "#000000";
    }
    if(id("row"+fName)) {
        id("row"+fName).style.display = "";
    }
}

function disableButtons() {
    disableFunction("Find");
    disableFunction("CheckIn");
    disableFunction("CheckOut");
    disableFunction("RoomFunctions");
    disableFunction("AddGuestNames");
    disableFunction("AddExtra");
    disableFunction("AddPayment");
    disableFunction("ShowReservation");
    disableFunction("ResDetails");
    disableFunction("Notify");
}

function resetCalendar() {
    disableButtons();
    enableFunction("Find");
    if(allowCheckIn) {
        enableFunction("CheckIn");
        enableFunction("CheckOut");
    }
    if(selectedResItem != null) {
        selectedResItem.style.backgroundColor = selectedResItemColour;
        selectedResItem = null;
    }
    if(selectedCell != null) {
        if(selectedResItemGroupId != null) {
            for(count=0; count < roomCells[selectedResItemGroupId].length; count++) {
                id("roomCell_" + roomCells[selectedResItemGroupId][count]).style.backgroundColor = oldColArray[count];
            }
        }
        //selectedCell.style.backgroundColor = selectedCellColour;
        selectedCell = null;
    }
    selectedResId = null;
    selectedResItemId = null;
    selectedResItemGroupId = null;
    selectedRoomId = null;
}

function selectResItem(obj,resId,resItemId,resItemGroupId) {
    if(selectedResItem != null) {
        selectedResItem.style.backgroundColor = selectedResItemColour;
    }

    if(selectedCell != null) {
        if(selectedResItemGroupId != null) {
            for(count=0; count < roomCells[selectedResItemGroupId].length; count++) {
                id("roomCell_" + roomCells[selectedResItemGroupId][count]).style.backgroundColor = oldColArray[count];
            }
        }
        //selectedCell.style.backgroundColor = selectedCellColour;
        selectedCell = null;
        selectedRoomId = null;
    }

    selectedResItem = obj;
    selectedResId = resId;
    selectedResItemId = resItemId;
    selectedResItemGroupId = resItemGroupId;
    selectedResItemColour = selectedResItem.style.backgroundColor;
    selectedResItem.style.backgroundColor = '#CCFFCC';

    disableButtons();
    if(allowRoomFunctions) {
        enableFunction("RoomFunctions");
        enableFunction("ShowReservation");
        enableFunction("AddPayment");
    }
    if(readonly !== "1") {
        enableFunction("AddExtra");
    }
    enableFunction("AddGuestNames");
    enableFunction("ResDetails");
    enableFunction("Notify");
    if(readonly == "1") {
        disableFunction("AddGuestNames");
        disableFunction("ResDetails");
        disableFunction("AddPayment");
    }
    if (reservationTabsAccess !== "1") {
        disableFunction("ShowReservation");
    }
}

var oldColArray = new Array();

function selectCell(obj,resId, resItemId,resItemGroupId,roomId,resItemGroupStatus,canCheck) {
    /*if(selectedCell != null) {
        selectedCell.style.backgroundColor = selectedCellColour;
    }*/
    if(selectedCell != null) {
        if(selectedResItemGroupId != null) {
            for(count=0; count < roomCells[selectedResItemGroupId].length; count++) {
                id("roomCell_" + roomCells[selectedResItemGroupId][count]).style.backgroundColor = oldColArray[count];
            }
        }
    }

    if(selectedResItem != null) {
        selectedResItem.style.backgroundColor = selectedResItemColour;
        selectedResItem = null;
    }

    selectedCell = obj;
    selectedResId = resId;
    selectedResItemId = resItemId;
    selectedResItemGroupId = resItemGroupId;
    selectedRoomId = roomId;
    //selectedCellColour = selectedCell.style.backgroundColor;

    for(count=0; count < roomCells[resItemGroupId].length; count++) {
        oldColArray[count] = id("roomCell_" + roomCells[resItemGroupId][count]).style.backgroundColor;
        id("roomCell_" + roomCells[resItemGroupId][count]).style.backgroundColor = '#CCFFCC';
    }
    selectedCell.style.backgroundColor = '#CCFFCC';
    var propAllowed = allowedProps.includes(selectedCell.getAttribute('prop'));

    disableButtons();
    if(resItemGroupStatus != 5 && allowCheckIn && canCheck && propAllowed) {
        enableFunction("CheckIn");
    }
    if ((resItemGroupStatus == 5 || resItemGroupStatus == 8) && allowCheckOut && propAllowed) {
        if (resItemGroupStatus == 5 || allowMultiCheckout) {
            // Only users with Management user access can check a room out multiple times
            // With Update access a room can only be checked-out once
            enableFunction("CheckOut");
        }        
    }
    if(allowRoomFunctions) {
        enableFunction("RoomFunctions");
    }
    enableFunction("ShowReservation");
    enableFunction("AddPayment");
    enableFunction("AddGuestNames");
    if(readonly !== "1") {
        enableFunction("AddExtra");
    }
    enableFunction("ResDetails");
    enableFunction("Notify");
    if(readonly == "1") {
        disableFunction("AddPayment");
        disableFunction("AddGuestNames");
        disableFunction("ResDetails");
    }
    if (reservationTabsAccess !== "1") {
        disableFunction("ShowReservation");
    }
}

function getLeft(obj) {
    curr = obj;
    currLeft = 0;
    while(curr && curr.tagName != "BODY") {
        currLeft += curr.offsetLeft;
        curr = curr.offsetParent;
    }
    return currLeft;
}


function getTop(obj) {
    curr = obj;
    currTop = 0;
    while(curr && curr.tagName != "BODY") {
        currTop += curr.offsetTop;
        curr = curr.offsetParent;
    }
    return currTop;
}

function showResItemDropDown(e,obj,resId) {
    if ( !resId ) {
        resId = selectedResId;
    } else {
        click();
    }

    if ( id("resItemDropDown").style.display != "" || resItemDropDownObj != obj ) {
        id("resItemDropDown").style.display = "";
        id("resItemDropDown").style.left =getLeft(obj) + obj.offsetWidth - id("resItemDropDown").offsetWidth + 2;
        id("resItemDropDown").style.top = $(obj).offset().top + obj.offsetHeight + 2;

        resItemDropDownId = resId;
        resItemDropDownObj = obj;

        if ( resNotes[resId] != "" ) {
            id("resNoteRow").style.display = "";
        } else {
            id("resNoteRow").style.display = "none";
        }

        if ( resMemos[resId] != "" ) {
            id("resMemoRow").style.display = "";
        } else {
            id("resMemoRow").style.display = "none";
        }

        if ( guestNotes[resId] != "" ) {
            id("guestNoteRow").style.display = "";
        } else {
            id("guestNoteRow").style.display = "none";
        }
    } else {
        id("resItemDropDown").style.display = "none";
    }

    if (!e) var e = window.event;
    e.cancelBubble = true;
    if ( e.stopPropagation ) e.stopPropagation();
}

function showRoomingFunctionDropDown(e,obj) {
    click();
    if(id("roomingFunctionDropDown").style.display != "") {
        id("roomingFunctionDropDown").style.display = "";
        id("roomingFunctionDropDown").style.left =getLeft(obj) + obj.offsetWidth - id("roomingFunctionDropDown").offsetWidth + 2;
        id("roomingFunctionDropDown").style.top = obj.offsetHeight + getTop(obj) + 2;
    } else {
        id("roomingFunctionDropDown").style.display = "none";
    }
    if (!e) var e = window.event;
    e.cancelBubble = true;
    if ( e.stopPropagation ) e.stopPropagation();
}

function showCheckInDropDown(e,obj) {
    if ( id("checkInDropDown").style.display != "" ) {
        id("checkInDropDown").style.display = "";
        var newLeft = getLeft(obj) + obj.offsetWidth - id("checkInDropDown").offsetWidth + 2;
        if(newLeft < 2) { newLeft = 2; }
        id("checkInDropDown").style.left = newLeft;
        id("checkInDropDown").style.top = obj.offsetHeight + getTop(obj) + 2;
    } else {
        id("checkInDropDown").style.display = "none";
    }

    if ( id("roomingFunctionDropDown").style.display == "" ) {
        id("roomingFunctionDropDown").style.display = "none";
    }

    if (!e) var e = window.event;
    e.cancelBubble = true;
    if ( e.stopPropagation ) e.stopPropagation();
}

function showCheckOutDropDown(e,obj) {
    if ( id("checkOutDropDown").style.display != "" ) {
        id("checkOutDropDown").style.display = "";
        id("checkOutDropDown").style.left =getLeft(obj) + obj.offsetWidth - id("checkOutDropDown").offsetWidth + 2;
        id("checkOutDropDown").style.top = obj.offsetHeight + getTop(obj) + 2;

        if ( id("checkOutDropDown").style.left < 0) {
            id("checkOutDropDown").style.left = 0;
        }
    } else {
        id("checkOutDropDown").style.display = "none";
    }

    if ( id("roomingFunctionDropDown").style.display == "" ) {
        id("roomingFunctionDropDown").style.display = "none";
    }

    if (!e) var e = window.event;
    e.cancelBubble = true;
    if ( e.stopPropagation ) e.stopPropagation();
}

function showHideRange(e,obj) {
    if ( id("showHideRange").style.display != "" ) {
        id("showHideRange").style.display = "";
        id("showHideRange").style.left = getLeft(obj) + obj.offsetWidth - id("showHideRange").offsetWidth + 2;
        id("showHideRange").style.top = obj.offsetHeight + getTop(obj) + 2;

        if ( id("showHideRange").style.left < 0 ) {
            id("showHideRange").style.left = 0;
        }

    } else {
        id("showHideRange").style.display = "none";
    }

    if (!e) var e = window.event;
    e.cancelBubble = true;
    if ( e.stopPropagation ) e.stopPropagation();

    id("headDate").value = buildDate("from");
}

function roomAttributePopupShow(e, obj, title, attributes) {
    id("roomAttributeHeader").innerHTML = title;
    id("roomAttributeData").innerHTML = attributes;

    id("roomAttributePopup").style.display = "";
    id("roomAttributePopup").style.left = (document.body.offsetWidth / 2) - (id("roomAttributePopup").offsetWidth / 2);
    id("roomAttributePopup").style.top = (document.body.scrollTop) + (document.body.offsetHeight / 2) - (id("roomAttributePopup").offsetHeight / 2);

    if (!e) var e = window.event;
    e.cancelBubble = true;
    if ( e.stopPropagation ) e.stopPropagation();
}

function roomAttributePopupClose() {
    id("roomAttributePopup").style.display = "none";
}

function click(closing) {
    if(id("resItemDropDown").style.display == "") {
        id("resItemDropDown").style.display = "none";
    }
    if(id("showHideForm").style.display == "") {
        id("showHideForm").style.display = "none";
    }
    if(id("roomingFunctionDropDown").style.display == "") {
        id("roomingFunctionDropDown").style.display = "none";
    }
    if(id("checkInDropDown").style.display == "") {
        id("checkInDropDown").style.display = "none";
    }
    if(id("checkOutDropDown").style.display == "") {
        id("checkOutDropDown").style.display = "none";
    }
    if(id("showHideRange").style.display == "") {
        id("showHideRange").style.display = "none";
    }
    if(id("roomFindDiv").style.display == "") {
        id("roomFindDiv").style.display = "none";
    }
    if(roomFindResultsActive) { roomFindResultsActive = false; }
}

function showNote(sHeading,sValue) {
    var is_ie = document.all ? true : false;

    newWindow = openPopup('reservation.php?685++'+sHeading,350,300);
    newWindow.name = "noteWindow";

    newForm = document.createElement("FORM");
    document.body.appendChild(newForm);
    newForm.setAttribute("method","post");
    newForm.setAttribute("action","reservation.php?685++"+sHeading);
    newForm.setAttribute("target","noteWindow");

    if ( is_ie ) {
        noteInput = document.createElement("<input type='hidden'>");
    } else {
        noteInput = document.createElement("input");
        noteInput.setAttribute("type","hidden");
    }
    noteInput.setAttribute("name","note");
    noteInput.setAttribute("id","note");
    noteInput.setAttribute("value",sValue);
    newForm.appendChild(noteInput);

    if ( is_ie ) {
        noteInput = document.createElement("<input type='hidden'>");
    } else {
        noteInput = document.createElement("input");
        noteInput.setAttribute("type","hidden");
    }
    noteInput.setAttribute("name","noteName");
    noteInput.setAttribute("value",resItemDropDownId + " - " + sHeading);
    newForm.appendChild(noteInput);
    newForm.submit();

    if ( is_ie ) {
        newForm.removeNode(true);
    }
}

function showResNote() {
    openPopup('reservation.php?685++Reservation Note+9+' + resItemDropDownId + '+1',350,350);
}

function showResMemo() {
    openPopup('reservation.php?685++Internal Memo+8+' + resItemDropDownId + '+1',350,340);
}

function showGuestNote() {
    openPopup('reservation.php?685++Guest Note+7+' + resItemDropDownId + '+1',350,340);
}

function showGuestNames(resId,resItemGroupId) {
    resItemDropDownId = resId;
    showNote("Guest Names",guestNames[resItemGroupId]);
}

function showContactDetails() {
    openPopup('reservation.php?685++Contact Details+5+' + resItemDropDownId + '+1',350,450);
}

function showFinancialDetails() {
    openPopup('reservation.php?685++Financial Details+6+' + resItemDropDownId + '+1',350,300);
}

function checkInRoom(e) {
    if(selectedResItemGroupId == null) {
        _groupId = "";

        var targ;

        if (!e) var e = window.event;

        if (e.target) {
            targ = e.target;
        }  else if (e.srcElement) {
            targ = e.srcElement;
        }

        if (targ.nodeType == 3) {
            // defeat Safari bug
            targ = targ.parentNode;
        }

        showCheckInDropDown(e,targ);
    } else {
        _groupId = selectedResItemGroupId;
        id("roomAction").value = "checkin";
        setRoomId(_groupId,"");
    }
//	openPopup("reservation.php?224+"+_groupId+"+"+selectedRoomId+"+"+selectedResItemId+"+checkin",320,450);
}

function batchCheckInProcess() {
    checkInList = document.getElementsByName("batchCheckIn");
    groupList = "";
    for(count=0; count<checkInList.length; count++) {
        if(checkInList[count].checked) {
            if(groupList != "") {
                groupList += "|";
            }
            groupList += checkInList[count].id;
        }
    }
    id("roomAction").value = "batchCheckIn";
    id("batchCheckInList").value = groupList;
    processForm();
}

function batchCheckOutProcess() {
    checkOutList = document.getElementsByName("batchCheckOut");
    groupList = "";
    for(count=0; count<checkOutList.length; count++) {
        if(checkOutList[count].checked) {
            if(groupList != "") {
                groupList += "|";
            }
            groupList += checkOutList[count].id;
        }
    }
    id("roomAction").value = "batchCheckOut";
    id("batchCheckOutList").value = groupList;
    processForm();
}

function checkOutRoom(e) {
    if ( selectedResItemGroupId == null ) {
        _groupId = "";

        var targ;

        if (!e) var e = window.event;

        if (e.target) {
            targ = e.target;
        }  else if (e.srcElement) {
            targ = e.srcElement;
        }

        if (targ.nodeType == 3) {
            // defeat Safari bug
            targ = targ.parentNode;
        }

        showCheckOutDropDown(e,targ);
    } else {
        _groupId = selectedResItemGroupId;
        openPopup("/reservation.php?235+"+_groupId+"+"+selectedRoomId+"+"+selectedResItemId,670,300);
    }
}

function addPayment() {
    _groupId = selectedResItemGroupId;
    openPopup("/reservation.php?244+"+_groupId+"+"+selectedRoomId+"+"+selectedResItemId,750,400);
}

function roomFunctions() {
    if(selectedResItemGroupId == null) {
        _groupId = "";
    } else {
        _groupId = selectedResItemGroupId;
    }
    id("roomAction").value = "upgrade";
    openPopup("/reservation.php?224+"+_groupId+"+"+selectedRoomId+"+"+selectedResItemId+"+upgrade",475,720);
}

function editGuestNames() {
//	return;
    if(selectedResItemGroupId == null) {
        _groupId = "";
    } else {
        _groupId = selectedResItemGroupId;
    }
    openPopup("/reservation.php?242+"+_groupId+"+"+selectedResItemId,1040,600);
}

function showReservation() {
    window.location = "/reservation.php?"+resJob+"+"+selectedResId;
}

function setRoomId(groupId,roomId,resItemId,requestCheck,requestReason) {
    id("setRoomId").value = groupId + "+" + roomId + "+" + resItemId + "+" + requestCheck;
    id("requestReason").value = requestReason;
    processForm();
}

function processForm() {
    Set_Cookie("roomingCalendarScrollLeft",id("itinrows").scrollLeft);
    Set_Cookie("roomingCalendarScrollTop",id("itinrows").scrollTop);
    url = buildURL();
    if(url) {
        id("url").value = url;
        id("urlForm").target = "_self";
        id("urlForm").submit();

    }
}

var fullSize = false;
function resizeGrid() {
    var itinrows = id("itinrows");
    if(fullSize) {

        itinrows.style.width = 685;
        itinrows.style.height = 262;
        id("itinCol").style.width = 685;
        id("roomRowDiv").style.height = "245px";

        id("colRows").style.width=parseInt(itinrows.style.width,10)-13;
        id("colRows").style.overflowX = "hidden";

        document.body.style.overflowY = "scroll";
        id("sizeButton").className = "button bMax";
        fullSize = false;
        Set_Cookie("roomingCalendarFullSize","0");

    } else {
        document.body.style.overflowY = "hidden";
        id("itinrows").style.width = document.body.clientWidth-parseInt(id("roomRowDiv").offsetWidth,10)-3;
        id("itinCol").style.width = document.body.clientWidth-parseInt(id("roomRowDiv").offsetWidth,10);
        id("itinrows").style.height = document.body.clientHeight-parseInt(id("colRows").offsetHeight,10);
        id("roomRowDiv").style.height = document.body.clientHeight-parseInt(id("colRows").offsetHeight,10);
        id("colRows").style.width = parseInt(id("itinrows").style.width,10)-13;
        document.body.scrollTop = id("dataTable").offsetTop;
        id("sizeButton").className = "button bMin";
        fullSize = true;
        Set_Cookie("roomingCalendarFullSize","1");
    }

}

function openFolioPDF(oFolioId) {
    //payPlanCheck, resNoteCheck, bankDetailsCheck, guestInformationCheck, commisionCheck, extraNoteCheck, exchNoteCheckm, propertyNoteCheck, internalMemoCheck

    _urlCount++;
    /* toggleMap = 0;

     toggleMap += id("payPlanCheck").checked?1:0;
     toggleMap += id("resNoteCheck").checked?2:0;
     toggleMap += id("bankDetailsCheck").checked?4:0;
     toggleMap += id("guestInformationCheck").checked?8:0;
     toggleMap += id("commisionCheck").checked?16:0;
     toggleMap += id("extraNoteCheck").checked?32:0;
     toggleMap += id("exchNoteCheck").checked?64:0;
     toggleMap += id("propertyNoteCheck").checked?128:0;
     toggleMap += id("internalMemoCheck").checked?256:0;
     // 512 for comment
     toggleMap += id("cancelNoteCheck").checked?1024:0;
     toggleMap += id("costComponentCheck").checked?2048:0;
     toggleMap += id("costSummaryCheck").checked?4096:0;
     toggleMap += id("roomingCheck").checked?8192:0;
     toggleMap += id("guestNoteCheck").checked?16384:0;
     toggleMap += id("guestMemoCheck").checked?32768:0;
     toggleMap += id("folioCheck").checked?65536:0;
     toggleMap += id("invoiceCheck").checked?131072:0;
     toggleMap += id("cancelPayCheck").checked?262144:0;
     toggleMap += id("resDetCheck").checked?524288:0;
       toggleMap += id("creditCardCheck").checked?1048576:0;

     if(id("commentArrow").value == " >> Remove comments") {
        toggleMap += 512;

     }
     var addressTemp = "";
     try {
         addressTemp = escape(eval(id("addressSelect").options[id("addressSelect").selectedIndex].value ));
     } catch(e) {
         addressTemp = "";
     }*/
    _reservationId = "";
    _invoiceId = "";
    toggleMap = 0;
    toggleMap += 1; //payplan
    toggleMap += 4096; // cost summary
    addressTemp = "";
    commentText = "";
    _folioId = oFolioId;

    if(_customIds != ""){
        var customList = _customIds.split(",");
    }

    if(_folioId != "") {
        url = '/reservation.php?642+'+_reservationId+'+1+'+_folioId+"+"+_invoiceId+'+!randomId!_'+(_urlCount.toString())+'+'+toggleMap+'+++++'+customList;
        url = url + "+" + addressTemp + "+" + commentText;

        pdfPopup=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","window.location='"+url+"';");
    } else {
        openMessage("Please select at least one folio in order to generate the PDF");
    }

}

function openNotify() {
    openPopup('reservation.php?642+'+selectedResId+'+4',1024,575);
}

function addExtra() {
    if ( selectedResItemGroupId == null ) {
        _groupId = "";
    } else {
        _groupId = selectedResItemGroupId;
    }
    var pId = "";
    openPopup('reservation.php?243+'+_groupId+"+"+selectedResItemId+"+"+selectedResId+"+"+pId+":"+pId,1215,600);
}

function keyDown(e) {
    if (!e) var e = window.event;

    switch(e.keyCode) {
        case 113: // F2
            if(id("btnCheckIn").disabled == false) {
                checkInRoom();
            } else if(id("btnFind").disabled == false) {
                findCells();
            }
            e.keyCode = 0;
            e.cancelBubble = true;
            if ( e.stopPropagation ) e.stopPropagation();
            return false;
        case 114: // F3
            if(id("btnCheckOut").disabled == false) {
                checkOutRoom();
            }
            e.keyCode = 0;
            e.cancelBubble = true;
            if ( e.stopPropagation ) e.stopPropagation();
            return false;
        case 115: // F4
            if(id("btnRoomFunctions").disabled == false) {
                roomFunctions();
            }
            e.keyCode = 0;
            e.cancelBubble = true;
            if ( e.stopPropagation ) e.stopPropagation();
            return false;
        case 116: // F5
            if(id("btnAddGuestNames").disabled == false) {
                editGuestNames();
            }
            e.keyCode = 0;
            e.cancelBubble = true;
            if ( e.stopPropagation ) e.stopPropagation();
            return false;
        case 117: // F6
            if(id("btnAddExtra").disabled == false) {
                addExtra();
            }
            e.keyCode = 0;
            e.cancelBubble = true;
            if ( e.stopPropagation ) e.stopPropagation();
            return false;
        case 118: // F7
            if(id("btnAddPayment").disabled == false) {
                addPayment();
            }
            e.keyCode = 0;
            e.cancelBubble = true;
            if ( e.stopPropagation ) e.stopPropagation();
            return false;
        case 119: // F8
            if(id("btnShowReservation").disabled == false) {
                showReservation();
            }
            e.keyCode = 0;
            e.cancelBubble = true;
            if ( e.stopPropagation ) e.stopPropagation();
            return false;
        case 27: // ESC
            if(id("btnReset").disabled == false) {
                resetCalendar();
            }
            e.keyCode = 0;
            e.cancelBubble = true;
            if ( e.stopPropagation ) e.stopPropagation();
            return false;
    }
}

function toggle(obj) {
    if ( id(obj).className == "collapse" ) {
        id(obj).className = "expand";
    } else {
        id(obj).className = "collapse";
    }
}

function findCells(e,rightAlign) {
    if(e) {
        // Figure out where the mouse is...
        var clickX = 0;
        var clickY = 0;

        if ( e.pageX || e.pageY ) 	{
            clickX = e.pageX;
            clickY = e.pageY;
        } else if ( e.clientX || e.clientY ) 	{
            clickX = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
            clickY = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
        }
    } else {
        clickX = getLeft(id("btnFind"));
        clickY = getTop(id("btnFind"));
    }
    id("resList").style.top = clickY;
    id("findResults").className = "collapse printCollapse";
    id("findResNum").value = "";
    id("findResName").value = "";
    id("findVoucherRef").value = "";
    id("findGuestName").value = "";
    toggle("resList");
    if(!rightAlign) {
        id("resList").style.left = clickX;
    } else {
        id("resList").style.left = clickX - id("resList").offsetWidth;
    }

    id("findGuestName").focus();

    return true;
}

function findExecute() {
    if(id("findResNum").value == "") { id("findResNum").value = "*"; }
    if(id("findResName").value == "") { id("findResName").value = "*"; }
    if(id("findVoucherRef").value == "") { id("findVoucherRef").value = "*"; }
    if(id("findGuestName").value == "") { id("findGuestName").value = "*"; }
    aRequestReset();
    var url = buildURL();
    var names = ['url','action','findResNum','findResName','findVoucherRef','findGuestName'];
    var values = [url,"findRes",id("findResNum").value,id("findResName").value,id("findVoucherRef").value,id("findGuestName").value];
    aRequestPost("reservation.php?234",findCallback,names,values);

}

function findCallback(fResult,fOutput) {
    if(fResult) {
        id("resRows").innerHTML = fOutput;
        id("findResults").className = "expand";
    }
}

function findSelectCell(resId, resItemId,resItemGroupId,roomId,resItemGroupStatus,canCheck) {
    resetCalendar();
    if(roomId != "") {
        obj = id("roomCell_" + roomCells[resItemGroupId][0]);
        selectCell(obj,resId, resItemId,resItemGroupId,roomId,resItemGroupStatus,canCheck);
        var newScrollLeft = selectedCell.offsetLeft + selectedCell.offsetParent.offsetParent.offsetLeft;
        var newScrollTop = selectedCell.offsetTop + selectedCell.offsetParent.offsetParent.offsetParent.offsetTop;
        id("itinrows").scrollLeft = newScrollLeft;
        id("itinrows").scrollTop = newScrollTop;
    } else {
        var row = 0;
        while(id("unallocRow_" + row.toString())) {
            var currResItemId = id("unallocRow_" + row.toString()).getAttribute("resItemId");
            var currResGroupId = id("unallocRow_" + row.toString()).getAttribute("resGroupId");
            if(resItemId == currResItemId && resItemGroupId == currResGroupId) {
                obj = id("unallocRow_" + row.toString());
            }
            row++;
        }
        selectResItem(obj,resId,resItemId,resItemGroupId);
        id("resItemListDiv").scrollTop = obj.offsetTop;
    }
    toggle("resList");
}

function findKeyPress(e) {
    e.cancelBubble = true;
    if(e.keyCode == 13) {
        findExecute();
    }
}


function searchCompare(search,value) {
    search = search.replace("*","");
    check = new RegExp(search,"i");
    if(value.match(check)) {
        return true;
    } else {
        return false;
    }
}

function roomFindKeyPress() {
    e.cancelBubble = true;
    if(event.keyCode == 13) {
        roomFind();
    }
}


var roomFindResults;
var roomFindResultsActive = false;

function roomFind() {
    var count;
    roomFindResults = new Array();
    first = true;
    firstCell = null;
    for(key in roomCells) {
        for(count=0;count<roomCells[key].length;count++) {
            currRoomCell = id("roomCell_" + roomCells[key][count].toString());
            found = false;
            if(id("roomFindResId").value      != "" && searchCompare(id("roomFindResId").value,     currRoomCell.getAttribute("resId"))) { found = true; }
            if(id("roomFindResName").value    != "" && searchCompare(id("roomFindResName").value,   currRoomCell.getAttribute("resName"))) { found = true; }
            if(id("roomFindVoucherRef").value != "" && searchCompare(id("roomFindVoucherRef").value,currRoomCell.getAttribute("agentRef"))) { found = true; }
            if(found) {
                currRoomCell.oldBackgroundColor = currRoomCell.style.backgroundColor;
                roomFindResults[roomFindResults.length] = currRoomCell;
                if(first) {
                    first = false;
                    firstCell = currRoomCell;
                }
            }
        }
    }
    count=0;
    while(id("unallocRow_" + count.toString())) {
        currRoomCell = id("unallocRow_" + count.toString());
        found = false;
        if(id("roomFindResId").value      != "" && searchCompare(id("roomFindResId").value,     currRoomCell.getAttribute("resId"))) { found = true; }
        if(id("roomFindResName").value    != "" && searchCompare(id("roomFindResName").value,   currRoomCell.getAttribute("resName"))) { found = true; }
        if(id("roomFindVoucherRef").value != "" && searchCompare(id("roomFindVoucherRef").value,currRoomCell.getAttribute("agentRef"))) { found = true; }
        if(found) {
            currRoomCell.oldBackgroundColor = currRoomCell.style.backgroundColor;
            roomFindResults[roomFindResults.length] = currRoomCell;
            if(first) {
                first = false;
                firstCell = currRoomCell;
            }
        }
        count++;
    }
    roomFindHide();
    resetCalendar();
    if(roomFindResults.length > 0) {
        roomFindResultsActive = true;
        roomFindResultsFlash();
        firstCell.onclick();
    } else {
        showMessage("No results found to match your search");
    }
}

function roomFindResultsFlash() {
    var count;
    var count2;
    for(count=0;count<roomFindResults.length;count++) {
        if(roomFindResults[count].style.backgroundColor == roomFindResults[count].oldBackgroundColor && roomFindResultsActive) {
            roomFindResults[count].style.backgroundColor = "#ffc000";
        } else {
            roomFindResults[count].style.backgroundColor = roomFindResults[count].oldBackgroundColor;
            if(!roomFindResultsActive) {
                if(selectedCell != null) {
                    if(selectedResItemGroupId != null) {
                        for(count2=0; count2 < roomCells[selectedResItemGroupId].length; count2++) {
                            if("roomCell_" + roomCells[selectedResItemGroupId][count2] == roomFindResults[count].id) {
                                roomFindResults[count].style.backgroundColor = '#CCFFCC';
                                oldColArray[count2] = roomFindResults[count].oldBackgroundColor;
                            }
                        }
                    }
                }
                if(selectedResItem != null) {
                    if(roomFindResults[count].id == selectedResItem.id) {
                        selectedResItem.style.backgroundColor = '#CCFFCC';
                        selectedResItemColour = selectedResItem.oldBackgroundColor;
                    }
                }
            }
        }
    }
    if(roomFindResultsActive == true) {
        setTimeout("roomFindResultsFlash();",300);
    }
}

function roomFindHide() {
    id("roomFindDiv").style.display = "none";
}

function goToToday() {
    var todayArray = today.split("-");
    id("fromDay").selectedIndex = parseInt(todayArray[2],10);
    id("fromMonth").selectedIndex = parseInt(todayArray[1],10);
    id("fromYear").value = todayArray[0];
    generateReport();
}

function openPropFilter() {
    var accomm = id("accommIds").value;
    openPopup("reservation.php?293+"+accomm,556,407);
}

function toggleOptions() {
    if ( id("advancedForm").className == "collapse printCollapse" ) {
        id("advancedForm").className = "colLt";
        id("advancedTag").value = ">> Hide";
    } else {
        id("advancedForm").className = "collapse printCollapse";
        id("advancedTag").value = "<< More";
    }
}
