// Basic variables required ---------------------------------------------------
var rsFrameCount	= 0;
var rsFrameIdList	= [];
var rsBusy				= 0;
var rsDebug				= false;
var varNameArray	= [];
var varValueArray	= [];

// Empty data / key arrays  - DB
function resetData() {
	varNameArray.length		= 0;
	varValueArray.length	= 0;
}

// Add data to data / key arrays - DB
function addData(key,value) {
	varNameArray[varNameArray.length] = key;

	if ( value ) {
		varValueArray[varValueArray.length] = value;
	} else {
		if ( id(key) ) {
			varValueArray[varValueArray.length] = id(key).value;
		} else {
			varValueArray[varValueArray.length] = "";
		}
	}
}

function tempFunc(funcName) {
	this.run = funcName;
}

// Execute a RS request GET ---------------------------------------------------
function rsRequest(url) {
	var fId = "rsFrame" + (parseInt(rsFrameCount++,10));
	var sId = fId + "span";

	rsBusy = 1;

	if ( !rsDebug ) {
		id("rsFrameSpan").innerHTML += '<span id="'+sId+'"><iframe id="'+fId+'" src="'+url+'+'+fId+'" width="0" height="0" onload="rsUpdate(this.id)" style="display: none;"></iframe></span>';
	} else {
		id("rsFrameSpan").innerHTML += '<span id="'+sId+'"><iframe id="'+fId+'" src="'+url+'+'+fId+'" width="600" height="400" onload="rsUpdate(this.id)"></iframe></span>';
	}
}

// Execute a RS request POST --------------------------------------------------
function rsRequestPost(url,nameArray,valueArray) {
	rsFrameCount++;
	var fId				= 'rsFrame' + rsFrameCount.toString();
	var sId				= fId + 'span';
	var frameCode	= "";

	rsBusy = 1;

	if ( !rsDebug ) {
		frameCode = '<span id="'+sId+'"><iframe id="'+fId+'" name="'+fId+'" width="0" height="0" style="display: none"></iframe></span>';
	} else {
		frameCode = '<span id="'+sId+'"><iframe id="'+fId+'" name="'+fId+'" width="600" height="400"></iframe></span>';
	}
	id(rsFrameSpan()).innerHTML += frameCode;

	submitForm = document.createElement("form");

	submitForm.setAttribute("method","post");
	submitForm.setAttribute("action",url);
	submitForm.setAttribute("target",fId);

	for ( var i = 0; i < nameArray.length; i++ ) {
		if ( is_ie ) {
			submitInput = document.createElement("<input type=\"hidden\">");
		} else {
			submitInput = document.createElement("input");
			submitInput.setAttribute("type","hidden");
		}

		submitInput.setAttribute("name",nameArray[i]);
		submitInput.setAttribute("value",valueArray[i]);
		submitForm.appendChild(submitInput);
	}

	document.body.appendChild(submitForm);

	var frameLoad = function(fId) {
		return function() {
			rsUpdate(fId);
		}
	}(fId);

	if (id(fId).addEventListener) {
		id(fId).addEventListener("load",frameLoad,false);
	} else if (id(fId).attachEvent) {
		id(fId).attachEvent("onload",frameLoad);
	}	

	submitForm.submit();
	document.body.removeChild(submitForm);

	function rsFrameSpan() {
		return "rsFrameSpan";
	}
}

// This function runs when an RS call returns ---------------------------------
function rsUpdate(fId) {
	// Get the iFrame object -----------------------------------------------------
	if ( is_ie ) {
		rpFrame = window.frames[fId];
	} else {
		rpFrame = id(fId).contentWindow;
	}

	rsFrameIdList[rsFrameIdList.length] = fId;
	// If we recieved a valid RS response ----------------------------------------
	if ( rpFrame.rsResponse == "success" ) {
		// Update the 'innerHTML' values, such as table rows -----------------------
		if ( rpFrame.rsUpdateInnerHTML.length > 0 ) {
			for ( i = 0; i < rpFrame.rsUpdateInnerHTML.length; i++ ) {
				eId = rpFrame.rsUpdateInnerHTML[i];
				if ( !id(eId) ) {
					if ( rsDebug) {
						alert("Cannot find parent element: " + eId );
					}
					continue;
				}
				var elementId = id(eId);
				if ( !id(eId) ) {
					if ( rsDebug ) {
						alert("Cannot find frame element: " + eId);
					}
					continue;
				}
				var valueId = rpFrame.document.getElementById(eId);
				var html = valueId.innerHTML;
				elementId.innerHTML = html;
				valueId.parentNode.removeChild(valueId);
			}
		}

		// Update the 'value' values, such as input boxes ---------------------------
		if ( rpFrame.rsUpdateValue.length > 0 ) {
			for( i = 0; i < rpFrame.rsUpdateValue.length; i++ ) {
				eId = rpFrame.rsUpdateValue[i];
				if ( !id(eId) ) {
					if ( rsDebug) {
						alert("Cannot find parent element: " + eId);
					}
					continue;
				}

				var elementId = id(eId);
				if ( !id(eId) ) {
					if ( rsDebug ) {
						alert("Cannot find frame element: " + eId);
					}
					continue;
				}
				var valueId = rpFrame.document.getElementById(eId);
				elementId.value = valueId.innerHTML;
				valueId.parentNode.removeChild(valueId);
			}
		}
		rpFrame.initFrame();
	}

	if ( !rsDebug ) {
		rsRemove(fId);
	} else { 
		// DB - This will end up duplicating the button for the first box due to the
		// onload running again when the innerHTML is updated on lines ~45 and line
		// ~58. Rather close the debug after each call.
		var newButton = document.createElement("button");
		newButton.setAttribute("type","button");
		newButton.innerHTML = "Close";
		eval("newButton.onclick = function() { rsRemove('" + fId + "'); };");
		id(fId+"span").appendChild(newButton);
	}
	rsBusy = 0;
}

var fidFF;
var spanID;

function rsRemove(fId) {
	fidFF		= id(fId);
	spanID	= fId + "span";

	// We need to delay the firing of these calls otherwise Firefox presents us
	// with a beautiful hourglass that won't go away...
	setTimeout("fidFF.parentNode.removeChild(fidFF)",100);
	setTimeout("id(spanID).innerHTML = ''",100);
}
