/*****************************************
  PHP compatible JS serializer
  by Dr.Slump, aka Ivn Montes
  Sponsored by Cytek NT <www.cyteknt.com>
 
  based on the toSource extensions v1.0 by Bjrn Rosell www.prototypeDHTML.net
 *****************************************/

/*Number.prototype.toPHP=function() {
   if (Math.round(this) == this)
       return 'i:'+this+';'; //integer
   else
       return 'd:'+this+';'; //float
}

String.prototype.toPHP=function() {
   var s = this;
   s=s.replace(/\\/g, "\\\\");
   s=s.replace(/\"/g, "\\\"");
   s=s.replace(/\n/g, "\\n");
   s=s.replace(/\r/g, "");
   return 's:'+s.length+':"'+s+'";';
}

Boolean.prototype.toPHP=function() {
   if (variable == true)
       return 'b:1;';
   else
       return 'b:0;';
}

Function.prototype.toPHP=function() {
   return 'N;'; //returns a Null variable for functions
}

Array.prototype.toPHP=function() {
   var a=this;
   var s = 'a:'+a.length+':{';

   for (var i=0; i<a.length; i++) {
           s += 'i:'+i+';'+a[i].toPHP();
   }
   s += '}';
   return s;
}

Object.prototype.toPHP=function() {
   var o=this;

   if (o==null) return 'N;';

   var s='';
   var count=0;
   for (var item in o) {
       if (item=="toPHP") continue;
       count++;

       s += 's:'+item.length+':"'+item+'";';
       if (o[item]==null)
           s +='N;';
       else
           s += o[item].toPHP();
   }
   s = 'a:'+count+':{'+s+'}';
  
   return s;
}*/

/*================================

to serialize the JS variable just do:
phpserialized = myvar.toPHP();

then just pass this data into PHP by a hidden form field and call PHP's unserialize() on it to build the variable into PHP.

I'm looking for a function that makes the other way round, I mean, that serializes a PHP variable into a JS friendly format. If someone does it please let me know ;)

ciao,
ivan
*/
function serializeLength(s) {
	// Ref: http://stackoverflow.com/questions/2219526/how-many-bytes-in-a-javascript-string
	return ((s.length > 0) ? encodeURI(s).match(/%..|./g) : s).length;
}

/* Alternate code */
function serialize (variable)
{
    switch (typeof variable)
    {
        case 'number':
            if (Math.round(variable) == variable)
                return 'i:'+variable+';';
            else
                return 'd:'+variable+';';
        case 'boolean':
            if (variable == true)
                return 'b:1;';
            else
                return 'b:0;';
        case 'string': return 's:'+serializeLength(variable)+':"'+variable+'";';
        case 'object':
			var i=0;
			var tmp = "";
			for (var item in variable) {
				tmp += serialize(item) + serialize(variable[item]);
				i++;
			}
			return 'a:' + i + ':{' + tmp + '}';

            break;
        default:
            return 'unkown type: '+typeof variable;
    }
} 

