var enabledButtons = ["Back", "Forward", "Refresh", "Calendar", "Internet", "Home", "Help", "NewWindow"];

function initialisePage() {
	initTop();
	enableButtons(enabledButtons);

	if(readOnly == 1) {
		["saveButton","addSpecialsButton","removeSpecialsButton"].forEach((objId) => {
			id(objId).disabled = true;
			id(objId).className = "txtg";
		})
	}

	reloadComboList();
}

function editCombo(sp_combo_id) {
	if(!sp_combo_id) {
		sp_combo_id = "";
	}
	aRequestPostEx("/reservation.php?1027", {
		action: "load_combo",
		sp_combo_id
	}, (data) => {
		id("sp_combo_id").value = data.sp_combo_id;
		id("sp_combo_name").value = data.sp_combo_name;
		id("sp_combo_limit").value = data.sp_combo_limit;
		window.specials = data.specials;
		window.periods = data.periods;

		populateSpecials();
		populatePeriods();
		$('#fullPageLoader').hide();
		openCombo();
	});
}

function populateSpecials() {
	$('#unallocatedSpecials tbody > tr').remove();
	$('#allocatedSpecials tbody > tr').remove();
	window.specials.forEach((special) => {
		let disabled = "";
		if(readOnly == 1) {
			disabled = "disabled";
		}
		if(special.allocated == "0") {
			$("#unallocatedSpecials tbody").append(`
				<tr>
						<td><input type="checkbox" class="unallocatedSpecialCheck uk-checkbox" id="${special.sp_special_ix}" ${disabled}></td>
						<td><label for="${special.sp_special_ix}">${special.sp_special_desc}</label></td>
					</tr>
			`);
		} else {
			$("#allocatedSpecials tbody").append(`
				<tr>
						<td><input type="checkbox" class="allocatedSpecialCheck uk-checkbox" id="${special.sp_special_ix}" ${disabled}></td>
						<td><label for="${special.sp_special_ix}">${special.sp_special_desc}</label></td>
					</tr>
			`);
		}
	});
}

function populatePeriods() {
	let allocatedCount = window.periods.reduce((total, period) => {
		if(period.allocated == "1") {
			total += 1;
		}
		return total;
	},0);

	let unallocatedCount = window.periods.reduce((total, period) => {
		if(period.allocated == "0") {
			total += 1;
		}
		return total;
	},0);

	if(allocatedCount == window.periods.length || unallocatedCount == window.periods.length) {
		id("ratePeriodFilter").innerHTML = "All";
		id("ratePeriodIds").value = "";
	} else {
		let allocatedPeriods = window.periods.filter(period => {
			return period.allocated == "1";
		});
		id("ratePeriodFilter").innerHTML = allocatedPeriods.map(period => {
			return period.rt_period_desc;
		}).join(", ");
		id("ratePeriodIds").value = allocatedPeriods.map(period => {
			return period.rt_period_ix;
		}).join(":");
	}
}

function openCombo() {
	applyTrans(1);
	id("comboDetailDiv").style.display = "block";
	id("comboDetailDiv").classList = "uk-modal uk-flex-top uk-open";
}

function closeCombo() {
	applyTrans(0);
	id("comboDetailDiv").style.display = "none";
	id("comboDetailDiv").classList = "uk-modal";
}
	
function saveCombo() {
	if(id("sp_combo_name").value == "") {
		id("sp_combo_name").focus();
		openMessage("You must specify a name for this combo.",null,null,null,null,true);
		return false;
	}

	let sp_combo_limit = parseInt(id("sp_combo_limit").value,10);
	if(isNaN(sp_combo_limit) || sp_combo_limit < 1) {
		id("sp_combo_limit").focus();
		openMessage("You must specify a maximum number of specials of 1 or more.",null,null,null,null,true);
		return false;
	}

	let periods = id("ratePeriodIds").value;
	if(periods == "") {
		periods = window.periods.map(period => {
			return period.rt_period_ix;
		});
	} else {
		periods = periods.split(":");
	}

	closeCombo();
	$('#fullPageLoader').show();
	aRequestPostEx("/reservation.php?1027", {
		action: "save_combo",
		sp_combo_id: id("sp_combo_id").value,
		sp_combo_name: id("sp_combo_name").value,
		sp_combo_limit,
		specials: JSON.stringify(window.specials),
		periods: JSON.stringify(periods)
	}, (data) => {
		reloadComboList();
	});
}

function reloadComboList() {
	deselectCombo();
	aRequestPostEx("/reservation.php?1027", {
		action: "list_combos"
	}, (data) => {
		let comboOptions = "";
		let sp_combo_id = id("selectCombo").value;
		let hasSelected = false;

		id("selectCombo").innerHTML = "";
		data.forEach((combo) => {
			let selected = "";
			if(combo.sp_combo_ix == sp_combo_id) {
				selected = "selected";
				hasSelected = true;
			}
			comboOptions += "<option value=\"" + combo.sp_combo_ix + "\" onclick=\"selectCombo();\"  ondblclick=\"editCombo('" + combo.sp_combo_ix + "');\" " + selected + ">" + combo.sp_combo_name + "</option>";
		});
		id("selectCombo").innerHTML = comboOptions;
		if(hasSelected) {
			selectCombo();
		}
		$('#fullPageLoader').hide();
	});
}

function selectCombo() {
	// Enable buttons
	if (readOnly == 1) {
		$('#buttonEditCombo').prop('disabled',false).removeClass("buttonDisabled");
	} else {
		$('.disableable').prop('disabled',false).removeClass("buttonDisabled");
	}
}

function deselectCombo() {
	// Initially disable buttons
	$('.disableable').prop('disabled',true).addClass("buttonDisabled");
	if (readOnly == 1) {
		$('#buttonNewCombo').prop('disabled',true).addClass("buttonDisabled");
		$('#buttonEditCombo').text('View');
	}
}

function moveCombo(direction) {
	aRequestPostEx("/reservation.php?1027", {
		action: "move_combo",
		sp_combo_id: id("selectCombo").value,
		direction
	}, (data) => {
		reloadComboList();
	});
}

function confirmDeleteCombo() {
	openConfirm("Are you sure you want to delete this combo?");
}

function processResponse() {
	deleteCombo();
}

function deleteCombo() {
	$('#fullPageLoader').show();
	aRequestPostEx("/reservation.php?1027", {
		action: "delete_combo",
		sp_combo_id: id("selectCombo").value
	}, (data) => {
		reloadComboList();
	});
}

function addSpecials() {
	$('.unallocatedSpecialCheck:checkbox:checked').each((index, elem) => {
		window.specials.forEach((special) => {
			if(special.sp_special_ix == elem.id) {
				special.allocated = "1";
			}
		});
	});
	populateSpecials();
}

function removeSpecials() {
	$('.allocatedSpecialCheck:checkbox:checked').each((index, elem) => {
		window.specials.forEach((special) => {
			if(special.sp_special_ix == elem.id) {
				special.allocated = "0";
			}
		});
	});
	populateSpecials();
}
