///////////////////////////////////////////////////////////////////////////
// This system include contains the following functions:                 //
//                                                                       //
// setOnChange()       set onchange handler for forms                    //
// openPopup()         open a modal dialog box                           //
// openMessage()       open generic OK message box                       //
// Installer updated:  Thu Sep 18 09:34:58 SAST 2003                     //
///////////////////////////////////////////////////////////////////////////

/*----------------------------------------------------------------------------------------------
  NOTE: The lines starting with '//UNCOMMENT' comment out the error trapping for debug purposes.
        The upgrade script will uncooment these before upload
        Do not touch these lines!
  ----------------------------------------------------------------------------------------------*/
//UNCOMMENTwindow.onerror = handleError;
//UNCOMMENTfunction handleError(){window.status = ""}
//window.onerror = handleError;
//function handleError(){window.status = ""}

//document.oncontextmenu = handleRightClick;
//function handleRightClick(){return false}
function findShadowRoot(element){
  if(element.shadowRoot) return element;
  if(!element.parentNode) return null;
  return findShadowRoot(element.parentNode);
}

var me = document.currentScript;
shadow = findShadowRoot(me);
shadowName = typeof shadow !== 'undefined' && shadow !== null ? shadow.tagName : "";
documentRoot = document;
documentRootChildren = document;
documentRootElement = document;
if (shadowName) {
  documentRoot = document.querySelector("rr-main-header").shadowRoot;
  documentRootChildren = document.querySelector("rr-main-header").shadowRoot.children;
  documentRootElement = document.querySelector("rr-main-header");
}

var isToolBarPage = false;
var monthNames = ["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sept","Oct","Nov","Dec"];
var saved_date;
var mainWindowPage;
var selectedProperties = "";
var selectedPropertyNames = "";
var selectedStatuses = "0:0:1:1:0";
var inputchange = false;        // Flag to test for field changes on a form
var savePressedButton = "";     // Save the putton pressed - used if save prompt triggered on toolbar
var saveURL = "";               // Save the menu URL - used if save prompt triggered on menu
var infoPopup = false;					// Popup window handle
var screenWidth=screen.availWidth;
var screenHeight=screen.availHeight;
var flag;
var flagSrc;
var timerID = "";
var infoTimer;
var delay = 800;
var popCal;
var pasteFieldId = false;                    // Id of focussed field into which 'Paste' toolbutton will paste
var dateElement;
var gotoCal = "";                            // Used to force goto Occ Cal from menu (see buttonPressGeneric_continue in tolbar.js)
var serverLocationLabel = "local";
var is_ie = document.all ? true : false;
var responseFunctions = new Array("processResponse");
var cancelFunctions = new Array();
var confirmAction = "";
var internalAPIBase = "api/";
var internalAPIVersion = "v1/";
var internalAPIReminderEndPoint = internalAPIBase + internalAPIVersion + "reminders/";
var tailDatePicker = null;

//////////////////////////////////////////////////////////////////////////
// initialisePage() is called onLoad of all forms in system              //
// - setup toolbar image arrays and disable initial buttons              //
///////////////////////////////////////////////////////////////////////////


function initTop() {  
	var hostName				= parent.location.hostname;
	var hostNameArray		= hostName.split(".");
	if(hostNameArray.length > 1 && hostNameArray[0].match(/archive-\d{2}/)) {
		var archive = hostNameArray.shift();
	}
	var serverLocation	= hostNameArray[1];

	// Setup the URL links in the country drop-downs
	// to take the user to the correct client on the web
	if(id("serverSelect") ) {
		if(hostNameArray.length > 2) {
			id("serverSelect").options[1].value = SAServer;
			id("serverSelect").options[2].value = USServer;
		} else {
			id("serverSelect").options[0].value = "";
			id("serverSelect").options[1].value = SAServer;
			id("serverSelect").options[2].value = USServer;
		}
	}
  
	// If we are !localhost then remove "local" option
	// Else set local option and flag
	if(hostNameArray.length > 2) {
		if(id("serverSelect")) {
			id("serverSelect").remove(0);
		}
    
		switch ( serverLocation ) {
		case "us":
			serverLocationLabel = "US";
			if(id("serverSelect")) {
				id("serverSelect").selectedIndex = 1;
			}
			break;
		case "eu":
			serverLocationLabel = "EU";
			if(id("serverSelect")) {
				id("serverSelect").selectedIndex = 2;
			}
			break;
		case "za":
			serverLocationLabel = "ZA";
			if(id("serverSelect")) {
				id("serverSelect").selectedIndex = 0;
			}
			break;
		default:
			if(id("serverSelect")) {
				id("serverSelect").selectedIndex = 0;
			}
		}
	} else {
		if(id("serverSelect")) {
			id("serverSelect").selectedIndex = 0;
		}
	}

	if(parent.LastUpdateDash) {
		/* Logged by MDB - (3/8/2004) ***********************************************
		The variable 'LastUpdate' has been changed to '01 Jan 2004' format
		'LastUpdateDash' is in 'DD-MM-YYYY' format.
		this is set up in reservation.php
		************************************************************************** */
		var _year = parent.LastUpdateDash.substr(0,4);
		var _month = parseInt(parent.LastUpdateDash.substr(5,2),10)-1;
		var _day = parent.LastUpdateDash.substr(8,2);
		var _time = parent.LastUpdateDash.substr(11,5);
	}
	if(id("top_clientlogo")) {
		id("top_clientlogo").src = LogoSrc;
	}
	if(id("topClientLogoCircle")) {
		id("topClientLogoCircle").setAttribute('xlink:href',LogoSrc);
	}


}

/*function showHideBrowser() {
	alert();
  //id("getBrowser").style.visibility = "hidden";
}*/

function concatElements() {
	for ( count = 0; count < arguments.length; count++ ) {
		elementNodeList = document.getElementsByTagName(arguments[count]);
		var nodeLength = elementNodeList.length;
		
		for ( countNode = 0; countNode < nodeLength; countNode++ ) {
			var sItem = elementNodeList.item(countNode);
			var ignoreSetOnChange = sItem.classList.contains("ignoreSetOnChange");
			
			if (!ignoreSetOnChange) {
				
			if ( !sItem.onchange ) {
				try {
					sItem.onchange = function() { inputchange = -1; };
				} catch(xxx) {}
			}
			
			if ( !sItem.onfocus ) {
				try {
					sItem.onfocus = function() { pasteFieldId = this.id; };
				}catch(xxx){}
				}

			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////
// This function will set the onchange event for all                     //
// input and select fields on a document                                 //
///////////////////////////////////////////////////////////////////////////
function setOnChange(){
   inputchange = false;
	concatElements('input', 'textarea', 'select');
}

///////////////////////////////////////////////////////////////////////////
// Open a popup window based on a set of parameters                      //
// passed                                                                //
///////////////////////////////////////////////////////////////////////////
var dialogWin = {};
dialogWin.dialogList = [];

if ( is_ie ) {
	if ( opener && !opener.closed && opener.dialogWin ) {
		dialogWin.topWindow = opener.dialogWin.topWindow;
	} else {
		dialogWin.topWindow = window;
	}
}

var busyFocus = 0;

function checkModal() {
	if ( !opener || opener.closed ) {
		return true;
	}

  if ( dialogWin.topWindow.busyFocus === false ) {
		dialogWin.topWindow.focus();
    return true;
	}

  if ( !dialogWin.win || dialogWin.win.closed ) {
		dialogWin.topWindow.busyFocus = false;
    current = window;
    //current.doneFocus = false;
		while ( current.opener && !current.opener.closed ) {
			current.doneFocus = false;
      current = opener;
		}
    dialogWin.topWindow.doneFocus = false;
			return true;
		}

		if ( dialogWin.win.doneFocus !== true ) {
   		// setTimeout("dialogWin.win.doneFocus = true; dialogWin.win.focus();",200);
      dialogWin.win.focus();
   	}
	return true;
}

function checkModalTop() {
	if ( busyFocus ) {
		return false;
  }
  busyFocus = true;

	if ( !dialogWin || !dialogWin.win || dialogWin.win.closed ) {
		busyFocus = false;
    return true;
	}

	if ( dialogWin.win.doneFocus !== true ) {
		dialogWin.win.focus();
	}
	return true;
}

//**************************
//  END MODAL DIALOG CODE
//**************************

// In order for the modal popups to work, the master window must have ONFOCUS set to 'checkModalTop',
// while the popup windows must have ONFOCUS set to 'checkModal'.

function closeAll() {
	if ( !dialogWin.topWindow.closed ) {
		return false;
  }
  
	for ( count = 0; count < dialogWin.dialogList.length; count++ ) {
		try {
    	dialogWin.dialogList[count].close();
		} catch(xxx) {}
	}
	return true;
}

function closeCheck() {
	if ( !opener || opener.closed ) {
		window.close();
	} else {
  	setTimeout("closeCheck();",100);
	}
}

function openPopup(url,w,h,x,y,scroll,resize,name,onactivate,recheckDisabled,transAfter, postParam=false) {
	// Special cases for V3 imagesets, trigger sidenav in parent (imageset) page
	if (typeof v3Imageset !== 'undefined' && typeof publicPage !== 'undefined' && publicPage) {
		if (v3Imageset && url == '/calendar_booking_info.php') {
			parent.openBookingInfo();
			return;
		}
		if (v3Imageset && url == '/legend_avail.php') {
			parent.openLegend();
			return;
		}
	}

	var funcCheck;
	try { 
		funcCheck = (eval("nd instanceof Function"));
	} catch(xxx){}
	if ( funcCheck ) {
		nd();
	}

	if(!w) {w=300;}                          // Default width is 300px
	if(!h) {h=150;}                          // Default height is 150px
	
	
	var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : screen.left;
	var dualScreenTop = window.screenTop != undefined ? window.screenTop : screen.top;
	width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
	height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;
	
	var systemZoom = width / window.screen.availWidth;

	if(!x) {x=((width / 2) - (w / 2))/ systemZoom + dualScreenLeft;}    // X co-ord to center screen horizontally
	if(!y) {y=((height - h)/2)}   // X co-ord to center screen virtically

	if (!name) { name=""; }
	if (postParam && name == "") {
		// For post requests, we need to generate and use a unique name for the window (if no name is provided already)
		name = "ResRequestWin" + Math.floor(Math.random()*100000);
	}

	if(!onactivate) {onactivate="";}

	var sFeatures = "fullscreen=0,width=" + w + ",height=" + h + ",top=" + y + ",left=" + x + ",screenX=" + x + ",screenY=" + y;

	if(scroll) { sFeatures += ",scrollbars=yes"; }

	if(resize) { sFeatures += ",resizable=yes"; }

	if(is_ie) {
		if ( opener && !opener.closed && opener.dialogWin ) {
			dialogWin.topWindow = opener.dialogWin.topWindow;
		} else {
			dialogWin.topWindow = window;
		}
	}

	url = (url && 0 !== url.length) && url.charAt(0) != "/" && !url.startsWith("http") ? url = "/" + url : url;

	if(Get_Cookie("open_in_tab") && /^ResRequestWin/.test(name)) {
		dialogWin.win = window.open(url,name);
		dialogWin.win.name = name;
		return dialogWin.win;
	} 

    // remove new lines for Chrome. ref: https://www.chromestatus.com/feature/5735596811091968
	dialogWin.win = window.open(url.replace(/\n|\r/g, ""),name,sFeatures);

	if(!transAfter) {
		dialogWin.win.onbeforeunload = function () {
			applyTrans(0);
		}
	}
	dialogWin.win.name = name;

	if ( !recheckDisabled ) {
		if ( is_ie ) {
			try {
				dialogWin.win.setTimeout("function window.reCheck() { var ccType=false; try { ccType = (closeCheck instanceof Function); } catch(xxx){} if( ccType == true) { try{ if(opener && !opener.closed){ if(opener.nd) { opener.nd(); } } } catch(xxx){} closeCheck(); "+ onactivate +"} else { setTimeout('window.reCheck();',400); } } window.reCheck();",400);
			} catch(xxx) {}
		} else {
			setTimeout((function(newWindow,onWindowLoad) {
				return function() {
					newWindow.reCheck = function() {
						var ccType=false;
						try {
							ccType = (typeof newWindow.closeCheck == "function");
						} catch(xxx){}
						if(ccType == true) {
							try{
								if(opener && !opener.closed) {
									if(opener.nd){
										opener.nd();
									}
								}
							} catch(xxx){}
							setTimeout(newWindow.closeCheck,100);
							if(onWindowLoad != "") {
								newWindow.eval(onWindowLoad);
							}
						} else {
							setTimeout(newWindow.reCheck,200); 
						} 						
					};
					newWindow.reCheck();
				};
			})(dialogWin.win,onactivate),50);
		}
	}

	if (postParam) {
		// Creates and attaches a form, and send POST data.
		// POST data should be an array with 2 values, for name and values, ie. ['rate', selectedArray]
		var form = document.createElement("form");
		form.setAttribute("method", "post");
		form.setAttribute("action", url);
		form.setAttribute("target", name);

		var hiddenField = document.createElement("input"); 
		hiddenField.setAttribute("type", "hidden");
		hiddenField.setAttribute("name", postParam[0]);
		hiddenField.setAttribute("value", postParam[1]);

		form.appendChild(hiddenField);
		document.body.appendChild(form);
		form.submit();
	}

	return dialogWin.win;
}

///////////////////////////////////////////////////////////////////////////
// Close message window                                                  //
//                                                                       //
///////////////////////////////////////////////////////////////////////////
function closePopup(){
   try { opener.document.body.releaseCapture(); } catch(xxx) {}
   window.close();
}

///////////////////////////////////////////////////////////////////////////
// Open a modal message box (with OK button only)                        //
// openMessage (message,height,type,x-coord,ycoord)                      //
///////////////////////////////////////////////////////////////////////////
function openMessage(message,type,h,x,y,transAfter) {
  var w = 318;                             // Width is 318px
  
	// Default height
	if ( !h ) {
		h = 120;
	}                           
  
	// Default to info box (as opposed to alert box)
	if ( !type ) {
		type = "i";
	}                     
	return openPopup("prompt.php?type=" + type + "&message=" + message,318,h,null,null,null,null,null,null,null,transAfter);
}

function gotoMessage(message,type) {
	// Default to info box (as opposed to alert box)
	if ( !type ) {
		type = "i";
	}
  window.location = "/prompt.php?type=" + type + "&message=" + message;
}

///////////////////////////////////////////////////////////////////////////
// Open a modal message box (with OK button only)                        //
// openMessage (message,height,type,x-coord,ycoord)                      //
///////////////////////////////////////////////////////////////////////////
function openConfirm(message,w,h,transAfter) {
	
	if ( !w ) {
		w = 308;
	}
  
	if ( !h ) {
		h = 155;
	}                           
	return openPopup("confirm_yn.php?message=" + message,w,h,null,null,null,null,null,null,null,transAfter);
}

///////////////////////////////////////////////////////////////////////////
// Add new contact - open type select (org/ind)                          //
///////////////////////////////////////////////////////////////////////////
function showContactType() {
	if ( inputchange ) {
		savePressedButton = "newContact";
		openPopup("/resource/Resrequest/Application/public/html/savechanges.htm");
	} else {
  	openPopup('/resource/Resrequest/Application/public/html/contact_orgind.htm',358,180);
	}
}

function Get_Cookie(name) {
	var start = document.cookie.indexOf(name+"=");
  var len = start+name.length+1;
  
	if ( (!start) && (name != document.cookie.substring(0,name.length)) ) {
		return null;
	}
  
	if (start == -1) {
		return null;
	}
  
	var end = document.cookie.indexOf(";",len);
  
	if (end == -1) {
		end = document.cookie.length;
	}
  return unescape(document.cookie.substring(len,end));
}

function Set_Cookie(name,value,expires,path,domain,secure=false) {
	secure = !secure && document.location.protocol === 'https:';
	document.cookie = name + "=" +escape(value) +
		((expires) ? ";expires=" + expires.toGMTString() : "") +
		((path) ? ";path=" + path : "") +
		((domain) ? ";domain=" + domain : "") +
		((secure) ? ";SameSite=None; Secure" : "");
  
}

///////////////////////////////////////////////////////////////////////////
// yesNoCancel() is called when a change is made on a form and the user  //
// tries to leave that form.                                             //
///////////////////////////////////////////////////////////////////////////
function yesNoCancel(returnValue) {
	switch(returnValue) {
		case "yes":
			inputchange = 0;
			if ( savePressedButton !== "" ) {
				Set_Cookie("savePressedButton",savePressedButton);
			}
			if ( saveURL !== "" ) {
				Set_Cookie("saveURL",saveURL);
			}
			buttonPressGeneric_continue("Save");
			break;
		case "no":
			inputchange = 0;
			if ( savePressedButton !== "" ) {
				buttonPressGeneric_continue(savePressedButton,false,"");
			}
			if ( saveURL !== "" ) {
				var getUrl = window.location;
				var baseUrl = getUrl .protocol + "//" + getUrl.host;
				if (!saveURL.startsWith('/')) {
					baseUrl += '/';
				}
				window.location = baseUrl + saveURL;
			}
			break;
		case "cancel":
			saveURL = "";
			break;
	}
}

function showAbout() {
	openPopup('about.php',430,510);
}

///////////////////////////////////////////////////////////////////////////
// mainWindowFocus() - make sure popup is always in focus                //
// popupFocus() - focus the main window then the popup                   //
///////////////////////////////////////////////////////////////////////////
function mainWindowFocus(){
   // Turn this code below on to enable popup autofocus (and in popupFocus() )
   /*
   checkModalTop();
   */
   // END
   return true;
}

var oldActive;

function popupFocus(e){
// Turn this code below on to enable popup autofocus (and in mainWindowFocus() )
   /*
   checkModal();
   if(document.activeElement.tagName != "BODY") {
      oldActive = document.activeElement;
      setTimeout("oldActive.setActive(); oldActive.focus();",100);
   }
   */
// END
   return true;
}

function popupUnload(){
   try { opener.document.body.releaseCapture(); } catch(xxx) {}
}

function openInfoPop(url,e,w,h,x,y){
  if ( !w ) { w = 500; }            // Default width
  if ( !h ) { h = 370; }            // Default height
	if ( !x ) { x = e.screenX; }     // Default Mouse Position
   
	if ( !y ) {
		y = e.screenY;
  	if ( (y+h) > window.screen.height ) {
			y = window.screen.height - (h + 50);
		}
	}
  infoTimer = setTimeout("openInfoPop_timeout('"+url+"',"+w+","+h+","+x+","+y+")",delay);
}

function closeInfoPop() {
   window.close();
}

function setupInfoPop() {
   // This is for use later to get onblur closure of the info popup
}

function openInfoPop_timeout(url,w,h,x,y){
	infoPopup = openPopup(url,w,h,x+20,y+20,0,0,"infoPopup");
  infoPopup.focus();
  dialogWin.win.setTimeout("function window.reCheckInfoPop() { var ccType=false; try { ccType = (setupInfoPop instanceof Function); } catch(xxx){} if( ccType == true) { setupInfoPop(); } else { setTimeout('window.reCheckInfoPop();',100); } } window.reCheckInfoPop();",100);
}

function cancelTimer(){
	clearTimeout(infoTimer);
}

function windowUnload(){
	// Called by most forms on unload
}

/////////////////////////////////////////////////////////////
// Function to open menu link                              //
/////////////////////////////////////////////////////////////
function gotoLink(URL) {
	if ( inputchange ) {
		saveURL = URL;
    openPopup("/resource/Resrequest/Application/public/html/savechanges.htm");
    return true;
	}

  // If we are going to Occ Cal then check if we must filter by agent
  if ( URL == "reservation.php?29" ) {
		window.location = "/reservation.php?29";
    return true;
	}
  
	// DEBUG - cludge for 'About resrequest.com'
  if ( URL == "reservation.php?533" ) {
		openPopup(URL,400,450);
		return true;
	}

	window.location = "/"+URL;
  return true;
}

function dataTransfer() {
	openPopup('reservation.php?128',358,270);
}

function dbStatusChange(job) {
	switch (job) {
	case 4:
   	openPopup('reservation.php?704',358,213);
     break;

	case 3:
  	openPopup('reservation.php?703',358,213);
		break;

	case 2:
  	openPopup('reservation.php?702',358,213);
    break;

	default:
  	openPopup('reservation.php?701',358,213);      
	}
}

function cacheClear() {
	openPopup('reservation.php?263',358,213);
}

function visitWebsite() {
	window.open(sysURL,'website','resizable=yes');
}

function visitOnlineSurvey() {
	window.open('http://www.divtech.co.za/bizapp/login.cfm','onlinesurvey','resizable=yes');
}

function visitAnalytics() {
	window.open('http://analytics.google.com','analytics','resizable=yes');
}


/////////////////////////////////////////////////////////////
// Date picker window                                      //
/////////////////////////////////////////////////////////////
function openCalendar(srcForm,dateEl,w,h) {
	// Save a pointer to the date drop-down we want to set
	// Used for reports with more than one date select on screen
  dateElement = dateEl;
	var form;
	var formIndex = 0;

	if (typeof(publicPage) !== "undefined") {
		if ( publicPage === true && document.getElementById('pageHeader')) {
			formIndex++;
		}
	}

	form = document.forms[formIndex];

	switch ( dateElement ) {
	case 'start':
  	form.selectDay.value		= form.startday.selectedIndex;
    form.selectMonth.value	= form.startmonth.selectedIndex;
    form.selectYear.value	= form.startyear.value;
    break;
	
	case 'end':
  	form.selectDay.value		= form.endday.selectedIndex;
    form.selectMonth.value	= form.endmonth.selectedIndex;
    form.selectYear.value	= form.endyear.value;
		break;

	case 'quickstart':
  	form.selectDay.value		= id("select_day").selectedIndex;
    form.selectMonth.value	= id("select_month").selectedIndex;
    form.selectYear.value	= id("year").value;
    break;
	
	default:
  	form.selectDay.value		= form.select_day.selectedIndex;
    form.selectMonth.value	= form.select_month.selectedIndex;
    form.selectYear.value	= form.year.value;
	}

	if ( isNaN(form.selectYear.value) || form.selectYear.length < 4 ) {
		openMessage("Please enter a valid year");
    return 0;
	}

	var screenWidth		= screen.availWidth;
  var screenHeight	= screen.availHeight;

	// Horribly non-cross-browser friendly. Let's just ignore.
	// screenPosX = event.screenX;
	// screenPosY = event.screenY;
  
	openPopup(srcForm,300,150);//,screenPosX,screenPosY);

	return true;
}

function setSelectedDate(date) {
	var dateArray = date.split("-");

	var year		= dateArray[0];
	var month	= dateArray[1];
	var day		= dateArray[2];

	var form;
	var formIndex = 0;

	if(typeof(publicPage) !== "undefined") {

		if ( publicPage === true && document.getElementById('responsiveLogin')) {
			formIndex = 2;
		} else if( publicPage === true && document.getElementById('pageHeader')) {
			formIndex = 1;
		}
	}

	form = document.forms[formIndex];

	switch ( dateElement ) {
		case 'start':
			form.startday[day].selected			= true;
			form.startmonth[month].selected		= true;
			form.startyear.value					= year;
			break;

		case 'end':
			form.endday[day].selected				= true;
			form.endmonth[month].selected			= true;
			form.endyear.value						= year;
			break;

		case 'quickstart':
			changed_date = year + "-" + month + "-" + day;
			gotoQuick(changed_date);
			//return 0;
			break;

		default:
			if (
					mainWindowPage != "reportExtra"
					&& mainWindowPage != "resExtras"
					&& mainWindowPage != "wizard_step_2_int"
					&& mainWindowPage != "reportSurvey"
					&& mainWindowPage != "reviewSurvey"
					&& mainWindowPage != "wizard_step_2_int"
					&& mainWindowPage != "quickExtrasEntry"
					&& mainWindowPage != "roomExtrasEntry"
					&& mainWindowPage != "rep_guest_history"
					&& mainWindowPage != "invoice_report"
					&& mainWindowPage != "contactCRM_pop"
					&& mainWindowPage != "rep_crm_custom"
					&& mainWindowPage != "tax_analysis_report"
					&& mainWindowPage != "discrepancy_report"
					&& useID == 0	// check for global variable to indicate use of date fields ID's instead of form names
			   ) {
				form.select_Month[month].selected = true;
				form.select_Year.value = year;
				setDayList(select_Day,month,year);
				form.select_Day[day].selected = true;
			} else {
				id(dateObj+"Month").selectedIndex = month;
				id(dateObj+"Year").value = year;
				id(dateObj+"Month").onchange();
				id(dateObj+"Day").selectedIndex	= day;
				if( mainWindowPage == "resExtras" || mainWindowPage == "wizard_step_2_int") {
					setArrDepDate(dateObj);
				}
			}
	}

	if (	mainWindowPage != "reportExtra"
			&& mainWindowPage != "resExtras"
			&& mainWindowPage != "wizard_step_2_int"
			&& mainWindowPage != "reportSurvey"
			&& mainWindowPage != "reviewSurvey"
			&& mainWindowPage != "quickExtrasEntry"
			&& mainWindowPage != "roomExtrasEntry"
			&& mainWindowPage != "rep_guest_history"
			&& mainWindowPage != "invoice_report"
			&& mainWindowPage != "contactCRM_pop"
			&& mainWindowPage != "rep_crm_custom"
			&& mainWindowPage != "codePeriodDates"
			&& mainWindowPage != "tax_analysis_report"
			&& mainWindowPage != "discrepancy_report"
			&& useID == 0	// check for global variable to indicate use of date fields ID's instead of form names
	   ) {
		reloadPage();
	}

	try {
		document.body.releaseCapture(); 
	} catch(xxx) {}
}

function openHelp() {
	openPopup('/resource/Resrequest/Application/public/html/help/help_frame.htm',690,430,120,100,1,1,'Help_Window');
}

function openHelpdesk() {
	var url				= "//helpdesk.resrequest.com";
	var name			= "Helpdesk";
	var sFeatures = "fullscreen=0,width=700,height=500,top=100,left=100,screenX=100,screenY=100,scrollbars=yes,resizable=yes";
	var helpdesk	= window.open(url,name,sFeatures);
}

/////////////////////////////////////////////////////////////
// Date manipulation functions                             //
/////////////////////////////////////////////////////////////
function DayAdd(startDate,numDays) {
	return DateAdd(startDate,numDays,0,0);
}

function DateAdd(startDate,numDays,numMonths,numYears) {
	var returnDate	= new Date(startDate.getTime());
  var yearsToAdd	= numYears;
	var month 			= returnDate.getMonth() + numMonths;
  
	if ( month > 11 ) {
		yearsToAdd	= Math.floor((month+1)/12);
    month				-= 12*yearsToAdd;
    yearsToAdd	+= numYears;    
	}
   
	returnDate.setMonth(month);
  	returnDate.setFullYear(returnDate.getFullYear() + yearsToAdd);
	returnDate.setDate(returnDate.getDate() + numDays);

  return returnDate;
}

function chngDate(startDate) {
	var dateArray = startDate.split("-");
  
	newY = parseInt(dateArray[0],10);
  newM = parseInt(dateArray[1],10);
  newD = parseInt(dateArray[2],10);
  newMonth = monthNames[newM-1];
  newDate = newD + " " + newMonth + " " + newY;
	
	return newDate;
}

/////////////////////////////////////////////////////////////
// Calculates valid days in a month/year combo             //
// (includes leap year support)                            //
/////////////////////////////////////////////////////////////
function getMonthDays(month,year) {
	if ( month == "2" ) {
		daysTmp = "28";    
		if ( year % 100 == "0" ) {			
			if ( year % 400 == "0" ) {
				daysTmp = 29;
			}
		} else {
    	if ( year % 4 == "0" ) {
				daysTmp = 29;
			}
		}
	} else if (month == "4" || month == "6" || month == "9" || month == "11") {
		daysTmp = "30";
	} else {
  	daysTmp = "31";
	}
  return parseInt(daysTmp,10);
}

/////////////////////////////////////////////////////////////
// Sets a day dropdown depending on the month/year combo   //
/////////////////////////////////////////////////////////////
function setDayList(dayObject,month,year) {
	daysTmp = getMonthDays(month,year);

  day = dayObject.selectedIndex;  
	dayObject.options.length = 0;
  dayObject.options[0] = new Option("",0);

	for ( i = 1; i < daysTmp + 1; i++ ) {
		dayObject.options[i] = new Option((i<10?"0"+i.toString():i),i);
	}
  if ( day > daysTmp ) {
		day = daysTmp;
	}
  dayObject.selectedIndex = day;
}

function setDayList2(dayObject,month,year) {
	daysTmp = getMonthDays(month,year);

	day = dayObject.selectedIndex;
  dayObject.options.length = 0;
  
	for ( i = 1; i < daysTmp + 1; i++ ) {
		dayObject.options[i-1] = new Option((i<10?"0"+i.toString():i),i);
	}
  
	if ( day > daysTmp ) {
		day = daysTmp;
	}
	dayObject.selectedIndex = day;
}

/////////////////////////////////////////////////////////////
// Shortening for document.getElementById(tagID)           //
/////////////////////////////////////////////////////////////
function id(tagId) {
  if (typeof shadow !== 'undefined' && shadow !== null) {
    return document.querySelector(shadow.tagName).shadowRoot.querySelector("#"+tagId);
  } else {
    return (document.getElementById) ? document.getElementById(tagId) : document.all[tagId];
  }
}

function selIndex(objectId) {
	return id(objectId).options[id(objectId).selectedIndex].index;
}

function selValue(objectId) {
	if (typeof id(objectId).options[id(objectId).selectedIndex] != 'undefined') {
		return id(objectId).options[id(objectId).selectedIndex].value;
	}
}

function selLabel(objectId) {
	return id(objectId).options[id(objectId).selectedIndex].innerHTML;
}

function selMIndex(objectId) {
	var result = [];
	var element = id(objectId).options;
	
	for ( i = 0; i < element.length; i++ ) {
		if ( element[i].selected ) {
			result[result.length] = element[i].index;
		}
	}
	return result;
}

function selMValue(objectId) {
	var result = [];
  var element = id(objectId).options;
  
	for ( i = 0; i < element.length; i++ ) {
		if ( element[i].selected ) {
			result[result.length] = element[i].value;
		}
	}
  return result;
}

function selMLabel(objectId) {
	var result = [];
  var element = id(objectId).options;
  
	for ( i = 0; i < element.length; i++ ) {
		if ( element[i].selected ) {
			result[result.length] = element[i].innerHTML;
		}
	}
  return result;
}

/////////////////////////////////////////////////////////////
// Check an input for 2 decimal places                     //
/////////////////////////////////////////////////////////////
function checkDecimal(obj) {
	if ( obj.value.search(/\.\d{3,}$/) != -1 ) {
		obj.focus();
    openMessage("Please enter a" + (name.substr(0,1).search(/[aeiouAEIOU]/)?"":"n") + " " + name + " with only 2 decimal places");
		return false;
	}
  return true;
}

/////////////////////////////////////////////////////////////
// Check an input for a percentage with 2 decimal places   //
/////////////////////////////////////////////////////////////
function checkPercent(obj,name,range) {
	if ( !range ) {
		range = "";
	}
  
	obj.value = obj.value.replace(/\s+/g,"");
  
	if ( checkDecimal(obj) === false ) {
		return false;
	}
  
	if ( obj.value.search(/^\d{1,3}(\.\d{1,2})*$/) == -1 ) {
		obj.focus();
    openMessage("Please enter a"+(name.substr(0,1).search(/[aeiouAEIOU]/)?"":"n")+" "+name+" "+range);
    return false;
	}
  
	if ( obj.value < 0 || obj.value > 100 ) {
		obj.focus();
    openMessage("Please enter a" + (name.substr(0,1).search(/[aeiouAEIOU]/)?"":"n") + " " + name + " " + range);
    return false;
	}
	return true;
}

/////////////////////////////////////////////////////////////
// Check an input for a number with 2 decimal places       //
/////////////////////////////////////////////////////////////
function checkNumber(obj,name) {
	obj.value = obj.value.replace(/\s+/g,"");
  
	if ( checkDecimal(obj) === false ) {
		return false;
	}
  
	if ( obj.value.search(/^\d+(\.\d+)*$/) == -1 ) {
		obj.focus();
		openMessage("Please enter a valid "+name);
    return false;
	}
	return true;
}

/////////////////////////////////////////////////////////////
// Clear date slect boxes                                  //
/////////////////////////////////////////////////////////////
function resetDate() {
	id("select_day").selectedIndex = 0;
  id("select_month").selectedIndex = 0;
  id("year").value = "";
  inputchange = -1;
}

function getBrowserVersion() {
	// convert all characters to lowercase to simplify testing
  var agt = navigator.userAgent.toLowerCase();

	// *** BROWSER VERSION ***
  // Note: On IE5, these return 4, so use is_ie5up to detect IE5.
  var is_major = parseInt(navigator.appVersion,10);
  var is_minor = parseFloat(navigator.appVersion);

  var is_ie     	= ((agt.indexOf("msie") != -1) && (agt.indexOf("opera") == -1));
  var is_ie3    	= (is_ie && (is_major < 4));
  var is_ie4    	= (is_ie && (is_major == 4) && (agt.indexOf("msie 4")!=-1) );
  var is_ie5    	= (is_ie && (is_major == 4) && (agt.indexOf("msie 5.0")!=-1) );
  var is_ie5_5up	= (is_ie && !is_ie3 && !is_ie4 && !is_ie5);

	if ( !is_ie ) {
		return "nav";
	}

	if ( is_ie5_5up ) {
		return true;
	} else {
		return false;
	}
}

var browserVersion = getBrowserVersion();

// [MN] - toggleColumn()
// If showHide is true -> Expand Columns
// If showHide is false -> Collapse Column
// Must have: 2 showHide buttons by the names of showBut & showBut2
// Rows to have NAME='x' AND ID='x'
// Header to have NAME='xHeader' ID='xHeader'
// Footer (bottom border) to have NAME='xFooter' ID='xFooter'
// Add '<td id="extraCol" style="width:0;"></td>' in header row and rows as last <td>

//NOTE: Need to handle columns with class that give a bgcolor.
//eg. Comm columns on the extras report, onclick of 'show all' the bgcolor class was replaced by txt
function toggleColumn(showHide) {
	extraCols = document.getElementsByName("extraCol");
  if ( showHide === true ) {
		for ( i = 0; i < extraCols.length; i++ ) {
			extraCols[i].style.width = 0;
		}
    headClass = "outLt";
    rowClass = "txt";
  
    footClass = "bt";
    id("showBut").className		= "collapse printCollapse";
    id("showBut2").className	= "collapse printCollapse";
	} else {
		headClass = rowClass	= footClass = "collapse printCollapse";
  	
		id("showBut").className		= "button bArrDes";
  	id("showBut2").className	= "button bArrDes";
	}
	
	for ( i = 1; i < arguments.length; i++ ) {
		headList = document.getElementsByName(arguments[i]+"Header");
    footList = document.getElementsByName(arguments[i]+"Footer");
    
		for ( l = 0; l < headList.length; l++ ) {
			headList[l].className = headClass;
		}
    
		for ( l = 0; l < footList.length; l++ ) {
			footList[l].className = footClass;
		}
    
		if ( showHide !== true ) {
			for ( e = 0; e < extraCols.length; e++ ) {
				extraCols[e].style.width = parseInt(extraCols[e].style.width,10) + parseInt(headList[0].offsetWidth,10);
        if ( parseInt(extraCols[e].style.width,10) > 130 ) {
					extraCols[e].style.width = 130;
				}
			}
		}
    itemList = document.getElementsByName(arguments[i]);
    
		for (l = 0; l < itemList.length; l++ ) {
			itemList[l].className = rowClass;
		}
	}
}

// Function set the amount of decimal places on a number
// Takes 'val' and ensures that is has 'num' decimal places
function fixAmtDisplay(val, num) {
  if ( isNaN(val) ) {
		return false;
	}

  if ( !num ) {
	 	num = 2;
	}

	// Round off any extra decimal places
  val = ( Math.round(parseFloat(val) * Math.pow(10,num)) / Math.pow(10,num) ).toString();

  // Add any extra decimal places required
  list = val.split(".");
  
	if ( list.length == 1 ) {
		list[1] = "";
	}
	
	diff = num - list[1].length;
  
	for ( c = 0; c < diff; c++ ) {
		list[1] += "0";
	}
  return list.join(".");
}

var mnuSelectArray = []; // Name needs to be changed at some stage

function buildSelectArray() {
	mnuSelectArray = [];
	var selectList = document.getElementsByTagName("SELECT");

	var currElement, currLeft, currTop;
	for(var count = 0; count < selectList.length; count++) {
		selectList[count].startClass = selectList[count].className;
		currElement = selectList[count];
		currLeft = 0;
		currTop = 0;
      
		while ( currElement ) {
			currLeft			+= currElement.offsetLeft;
			currTop 			+= currElement.offsetTop;
			currElement	= currElement.offsetParent;
		}

		var selectItem = {};
		selectItem.left			= currLeft;
		selectItem.top			= currTop;
		selectItem.width		= selectList[count].offsetWidth;
		selectItem.height		= selectList[count].offsetHeight;
		selectItem.right		= currLeft + selectList[count].offsetWidth;
		selectItem.bottom		= currTop + selectList[count].offsetHeight;
		selectItem.element	= selectList[count];

		if (!selectList[count].classList.contains('excludeFromMenuFix')) {
			mnuSelectArray[mnuSelectArray.length] = selectItem;
		}
	}
}

function openPaxMenu() {
	var startDate = "";
	openPopup('reservation.php?736+'+startDate,690,330);
}

function getLeft(obj) {
	curr = obj;
	currLeft = 0;
	while(curr && curr.tagName != "BODY") {
		currLeft += curr.offsetLeft;
		curr = curr.offsetParent;
	}
	return currLeft;
}


function getTop(obj) {
	curr = obj;
	currTop = 0;
	while(curr && curr.tagName != "BODY") {
		currTop += curr.offsetTop;
		curr = curr.offsetParent;
	}
	return currTop;
}

function _getLeft(obj) {
	curr = obj;
	currLeft = 0;
	while(curr && curr.tagName != "BODY") {
		currLeft += curr.offsetLeft;
		curr = curr.offsetParent;
	}
	return currLeft;
}


function _getTop(obj) {
	curr = obj;
	currTop = 0;
	while(curr && curr.tagName != "BODY") {
		currTop += curr.offsetTop;
		curr = curr.offsetParent;
	}
	return currTop;
}

function setRowHover(obj) {
	obj.style.backgroundColor = '#CCFFCC';
}

function clearRowHover(obj) {
	obj.style.backgroundColor = '';
}

function chngBox(boxId){
	var box = id(boxId);
  
	if ( box.getAttribute("type") == "checkbox" ) {
		box.checked = !box.checked;
	} else {
  	box.checked = true;
	}
}

var messageZIndex = messageZIndex >= 101 ? messageZIndex : 0;
function showMessage(sMessage,sTitle,sWidth,sHeight,posLeft,posTop,focusAfter,transAfter) {
	if(!sTitle) { sTitle = "Notice"; }
	if(!sWidth) { sWidth = 300; }
	// z-index above "wait" div
	applyTrans(1);
	if(messageZIndex == 0) {messageZIndex = 101;} else { messageZIndex += 1; };
	var randLetter = String.fromCharCode(65 + Math.floor(Math.random() * 26));
	var uniqueId = randLetter + Date.now() + messageZIndex;
	var tempDiv = document.createElement("div");
	tempDiv.id = uniqueId;
	tempDiv.name = "tempMessageDiv";
	tempDiv.style.width = sWidth;
	if(sHeight) {
		tempDiv.style.height = sHeight;
	}
	tempDiv.style.zIndex = messageZIndex;
	tempDiv.style.position = "absolute";

	var destroyParams = ["false","false"];
	if(focusAfter) {
		destroyParams[0] = "'" + focusAfter + "'";
	}
	if(transAfter) {
		destroyParams[1] = "'" + transAfter + "'";
	}
	destroyParams = "," + destroyParams.join(",");

	tempDiv.innerHTML = 
		"<table class=\"overlayPopup \" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">" +
		"<tr><td class=\"overlayPopupHeader colDk txtb bb \" align=\"center\">" + sTitle + "</td></tr>" +
		"<tr><td align=\"center\" style=\"padding: 10px 0 10px 0;\">" + sMessage + "</td></tr>" +
		"<tr class=\"colLt\"><td class=\"bt\" height=\"4\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td></tr>" +
		"<tr><td class=\"overlayPopupFooter\" align=\"center\"><input type=\"button\" id=\"showMessageOkButton\" class=\"button masterButton\" value=\" Ok \" onclick=\"destroyShowMessage(this" + destroyParams + ");\"></td></tr>" +
		"</table>";
  if (shadowName) {
    $(shadow).append(tempDiv);
  } else {
    $("body").append(tempDiv);
  }
	if(!posLeft || typeof posLeft == "undefined") { posLeft = document.body.offsetWidth / 2 - tempDiv.offsetWidth / 2; }
	if(!posTop || typeof posTop == "undefined") { posTop = document.body.scrollTop + ((windowHeight() / 2) - (tempDiv.offsetHeight / 2)); }
	id(uniqueId).style.top = (posTop < 0) ? "0px" : posTop + "px"; 
	id(uniqueId).style.left = (posLeft < 0) ? "0px" : posLeft + "px"; 
	id('showMessageOkButton').focus();
}

function destroyShowMessage(element,focusAfter,transAfter) {
	var messageId = element.parentNode.parentNode.parentNode.parentNode.parentNode.id;
	var div = document.getElementById(messageId);
	div.parentNode.removeChild(div);
	if(!transAfter) {
		applyTrans(0);
	}
	if(focusAfter && id(focusAfter)) {
		id(focusAfter).focus();
	}
}

function showList(sList,sTitle,sWidth,sHeight) {
	if(!sTitle) { sTitle = "Notice"; }
	if(!sWidth) { sWidth = 300; }
	if(!sHeight) { sHeight =  200; }
	// z-index above "wait" div
	applyTrans(1);
	if(messageZIndex == 0) {messageZIndex = 101;} else { messageZIndex += 1; };
	var tempDiv = document.createElement("div");
	var randLetter = String.fromCharCode(65 + Math.floor(Math.random() * 26));
	var uniqueId = randLetter + Date.now() + messageZIndex;
	tempDiv.id = uniqueId;
	tempDiv.name = "tempListDiv";
	tempDiv.style.width = sWidth;
	if(sHeight) {
		tempDiv.style.height = sHeight;
	}
	tempDiv.style.position = "absolute";
	tempDiv.style.zIndex = messageZIndex;
	listRows = "";
	for(count = 0; count < sList.length; count++) {
		listRows += "<tr><td>" + sList[count] + "</td></tr>";
	}
	tempDiv.innerHTML = 
		
		"<table class=\"overlayPopup bAll\" width=\"100%\">" +
		"<tr><td class=\"colDk txtb bb\" align=\"center\">" + sTitle + "</td></tr>" +
		"<tr><td><div class=\"bAll\" style=\"width: " + sWidth + "; height: " + sHeight + "; overflow-y: scroll; background-color: #ffffff;\">" +
		"<table width=\"100%\">" + listRows + "</table></div></td></tr>" + 
		"<tr class=\"colLt\"><td class=\"bt\" height=\"5\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td></tr><tr><td align=\"center\"><input type=\"button masterButton\" class=\"button\" value=\" Ok \" onclick=\"destroyShowList('"+uniqueId+"');\"></td></tr>" +
		"</table>";
	document.body.appendChild(tempDiv);
	tempDiv.style.left = document.body.offsetWidth / 2 - tempDiv.offsetWidth / 2;
	tempDiv.style.top = positionTop = document.body.offsetHeight / 2 - tempDiv.offsetHeight / 2;

	if (positionTop < 100) {	// make sure popup is lower than menu to avoid overlapping
		tempDiv.style.top = 100;
	}
}

function showValidationList(sList,sTitle,sWidth,sHeight) {
	if(!sTitle) { sTitle = "Validation Error"; }
	if(!sWidth) { sWidth = 300; }
	if(!sHeight) { sHeight =  200; }
	if(!sList) { sList =  []; }
	// z-index above "wait" div
	applyTrans(1);
	if(messageZIndex == 0) {messageZIndex = 101;} else { messageZIndex += 1; };
	var tempDiv = document.createElement("div");
	var randLetter = String.fromCharCode(65 + Math.floor(Math.random() * 26));
	var uniqueId = randLetter + Date.now() + messageZIndex;
	tempDiv.id = uniqueId;
	tempDiv.name = "validationListDiv";
	tempDiv.style.width = sWidth;
	if(sHeight) {
		tempDiv.style.height = sHeight;
	}
	tempDiv.style.position = "absolute";
	tempDiv.style.zIndex = messageZIndex;
	listRows = "<tr><td><u>Please correct the following</u>:</td></tr>";
	for(count = 0; count < sList.length; count++) {
		var itemNumber = count + 1;
		listRows += "<tr><td class='validationMessage'>&nbsp;&nbsp;" + itemNumber + ") " + sList[count] + "</td></tr>";
	}
	tempDiv.innerHTML = 
		"<table class=\"overlayPopup bAll\" width=\"100%\">" +
		"<tr><td class=\"colDk txtb bb\" align=\"center\">" + sTitle + "</td></tr>" +
		"<tr><td><div class=\"bAll\" style=\"width: " + sWidth + "; height: " + sHeight + "; overflow-y: scroll; background-color: #ffffff;\">" +
		"<table width=\"100%\">" + listRows + "</table></div></td></tr>" + 
		"<tr class=\"colLt\"><td class=\"bt\" height=\"5\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td></tr><tr><td align=\"center\"><input type=\"button\" class=\"button masterButton\" value=\" Ok \" onclick=\"destroyShowList('"+uniqueId+"');\"></td></tr>" +
		"</table>";
	document.body.appendChild(tempDiv);
	tempDiv.style.left = document.body.offsetWidth / 2 - tempDiv.offsetWidth / 2;
	tempDiv.style.top = document.body.offsetHeight / 2 - tempDiv.offsetHeight / 2;
}

function destroyShowList(uniqueId) {
	var div = id(uniqueId);
	document.body.removeChild(div);
	applyTrans(0);
}


function checkEmail(cEmail) {
    var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(cEmail);
}

function windowWidth() {
	var frameWidth = 0;
	if ( self.innerWidth ) {	// All browsers except Explorer
		frameWidth = self.innerWidth;
	}	else if (document.documentElement && document.documentElement.clientWidth) {	// IE 6 Strict mode
		frameWidth = document.documentElement.clientWidth;
	} else if (document.body) {	// All other IE versions
		frameWidth = document.body.clientWidth;
	} else {
		return false;
	}

	return frameWidth;

}

function windowHeight() {
	var frameHeight = 0;
	if ( self.innerHeight ) {	// All browsers except Explorer
		frameHeight = self.innerHeight;
	} else if (document.documentElement && document.documentElement.clientHeight) {	// IE 6 Strict mode
		frameHeight = document.documentElement.clientHeight;
	} else if (document.body) {	// All other IE versions
		frameHeight = document.body.clientHeight;
	} else {
		return false;
	}
	return frameHeight;
}

function windowResize(w,h) {
	window.resizeBy(w-windowWidth(), h-windowHeight());
}

// Returns the height of the entire HTML page
// i.e. including areas outside the viewport
function pageHeight() {
	var docHeight;

	if ( typeof document.height != 'undefined' ) {
		docHeight = document.height;
	} else if ( document.compatMode && document.compatMode != 'BackCompat' ) {
		docHeight = document.documentElement.scrollHeight;
	} else if ( document.body && typeof document.body.scrollHeight != 'undefined' ) {
		docHeight = document.body.scrollHeight;
	}
	
	return docHeight;
}

function applyTrans(action,zIndexOverride) {
	if (typeof jQuery === 'undefined') {
		// Jquery is NOT loaded on this page, so we need this old-style Javascript fallback (original function).
		// This typically happens with popups, where the central code is not including Jquery in the popup HTML
		var i = action;
		var docHeight = pageHeight();
		
		// If docHeight < windowHeight, we're going to look a bit stupid, so make sure
		// it is at least the same as the window height
		if ( docHeight < windowHeight() ) {
			docHeight = windowHeight();
		}

		if ( !id("trans") ) {
			// The transparent div doesn't exist, so bung it in
			var transDiv;
			transDiv = document.createElement("DIV");
			transDiv.id = "trans";		
			transDiv.style.display = "none";
			transDiv.className = "lightbox";
			document.body.appendChild(transDiv);
		}

		if(zIndexOverride) {
			id("trans").style.zIndex = zIndexOverride;
		} else {
			id("trans").style.zIndex = "";
		}

		// Find all the select elements that IE6 will display through any divs
		var s;
		s = document.getElementsByTagName("SELECT");
		var count;

		if ( i > 0 ) {
			for ( count = 0; count < s.length; count++ ) {
				if ( s[count].style.zIndex < 99 && s[count].style.display != "none" && s[count].style.visibility != "hidden" ) {
					s[count].style.display = "none";
				}			
			}
			
			id("trans").style.height = docHeight + "px";
			id("trans").style.width = windowWidth() + "px";
			id("trans").style.display = "";
		} else {
			for ( count = 0; count < s.length; count++ ) {
				if ( s[count].style.zIndex < 99 ) {
					s[count].style.display = "";
				}			
			}
			id("trans").style.display = "none";
		}
	} else {
		action = action == undefined ? '' : action;
		zindex = zIndexOverride == undefined ? 99 : zIndexOverride;
		switch (action) {
		case 1:
			overlayBackground = `<div id="trans" style="
				position: fixed;
				top: 0px;
				left: 0px;
				height: 100%;
				width: 100%;
				z-index: `+zindex+`;
				background-color: #000;
				opacity: 0.6;
				-moz-opacity: 0.6;
				filter: alpha(opacity=60);
			"></div>`;

			if (!id('trans')) {
				if (shadowName) {
					$(shadow.shadowRoot).append(overlayBackground);
				} else {
					$("body").append(overlayBackground);
				}
			}
			break;
		default:
			$(id('trans')).remove();
		}
	}
}

function centerDivOnPage(aID) {
	id(aID).style.display = "";
	divWidth	= parseInt(id(aID).offsetWidth,10);
	divHeight = parseInt(id(aID).offsetHeight,10);

	// Hide while moving to avoid IE bug
	id(aID).style.display = "none";
	var scrollTop = f_scrollTop();
	if(id(aID).style.position == "fixed") {
		scrollTop = 0;
	}
	id(aID).style.top = (windowHeight()-divHeight)/2 + scrollTop + "px";
	id(aID).style.left = (windowWidth()-divWidth)/2 + "px";
	id(aID).style.display = "";
}

function getClickPosition(e,axis) {
	var posx = 0;
	var posy = 0;

	if (!e) {
		e = window.event;
	}

	if ( e.pageX || e.pageY ) 	{
		posx = e.pageX;
		posy = e.pageY;
	}	else if ( e.clientX || e.clientY ) 	{
		posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
		posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
	}
	if ( axis == "x" ) {
		return posx;
	} else {
		return posy;
	}
}

function getEventTarget(e) {
	if (!e) {
		e = window.event;
	}

	var targ;
	if ( e.target ) {
		targ = e.target;
	}  else if ( e.srcElement ) {
		targ = e.srcElement;
	}

	if ( targ.nodeType == 3 ) {
		// defeat Safari bug
		targ = targ.parentNode;
	}
	return targ;
}

function stopBubble(e) {
	if ( !e ) {
		e = window.event;
	}
	e.cancelBubble = true;
	if (e.stopPropagation) {
		e.stopPropagation();
	}
}

/* 
	URL encoding and decoding functions to be used instead of "escape" to match up with
	the php urlencode and urldecode functions.

	Source: http://cass-hacks.com/articles/code/js_url_encode_decode/ 
*/
function URLEncode (clearString) {
  var output = '';
  var x = 0;
  clearString = clearString.toString();
  var regex = /(^[a-zA-Z0-9_.]*)/;
  while (x < clearString.length) {
    var match = regex.exec(clearString.substr(x));
    if (match !== null && match.length > 1 && match[1] !== '') {
    	output += match[1];
      x += match[1].length;
    } else {
      if (clearString[x] == ' ') {
    		output += '+';
			} else {
        var charCode = clearString.charCodeAt(x);
        var hexVal = charCode.toString(16);
		if(hexVal.length == 1) {
			hexVal = "0" + hexVal;
		}
        output += '%' + hexVal.toUpperCase();
      }
      x++;
    }
  }
  return output;
}

function URLDecode (encodedString) {
  var output = encodedString;
  var binVal, thisString;
  var myregexp = /(%[0-9ABCDEFabcdef]{2})/;
  while ((match = myregexp.exec(output)) !== null
             && match.length > 1
             && match[1] !== '') {
    binVal = parseInt(match[1].substr(1),16);
    thisString = String.fromCharCode(binVal);
    output = output.replace(match[1], thisString);
  }
  return output;
}

	
function alignDivToElement(aElm, tElm, x, y, extraX, extraY) {
// PARAMETERS /////////////////////////////////////////////////////////////////
//	aElm: string id of element you want to align                             //
//	tElm: string id of element you want to align to                          //
//	x: string "left" or "right"                                              //
//	y: string "top" or "bottom"                                              //
//	extraX: integer value for any extra horizontal positioning in pixels     //
//	extraY: integer value for any extra vertical positioning in pixels       //
///////////////////////////////////////////////////////////////////////////////
	if ( !x )				{ x = "left"; }
	if ( !y )				{ y = "bottom"; }
	if ( !extraX )	{ extraX = 0; }
	if ( !extraY )	{ extraY = 0; }

	// Get the target element's position
	tPos = findPos(id(tElm));

	if ( x == "left" ) {
		id(aElm).style.left = tPos[0] + extraX;
	} else {
		id(aElm).style.left = id(tElm).offsetWidth + tPos[0] + extraX;
	}

	if ( y == "top" ) {
		id(aElm).style.top = tPos[1] - id(aElm).offsetHeight + extraY;
	} else {
		id(aElm).style.top = id(tElm).offsetHeight + tPos[1] + extraY;
	}
}

function findPos(obj) {
	var curleft	= 0;
	var curtop	= 0;

	if (obj.offsetParent) {
		curleft = obj.offsetLeft;
		curtop = obj.offsetTop;

		var currObj = obj.offsetParent;
		while (currObj) {
			curleft += currObj.offsetLeft;
			curtop += currObj.offsetTop;
			currObj = currObj.offsetParent;
		}
	}
	return [curleft,curtop];
}


// START - Input number handling routines
function isInteger(e,max) {
	var result = false;
	var code = e.keyCode;

	isAllowed = (code < 47) || (code > 111 && code < 124); // Control keys and F keys

	if(isAllowed) {
		result = true;
	} else {
		if(code >= 96 && code <= 105) code -= 48; // Fix numeric pad 0-9
		var codeChar = String.fromCharCode(code);
		var codeNum = parseInt(codeChar,10);		
		var targ;
		if (e.target) {
			targ = e.target;
		} else if (e.srcElement) {
			targ = e.srcElement;
		}

		if (targ.nodeType == 3) targ = targ.parentNode;

		var val = targ.value.toString();
		
		if(codeNum >= 0 && codeNum <= 9 && (val.length < max || !max)) {
			result = true;
		} else {
			result = false;
		}

	}
	e.returnValue = result;
	return result;
}


function isFloat(e, max) {
	var result = false;
	var code = e.keyCode;

	isAllowed = (code < 47) || (code > 111 && code < 124); // Control keys and F keys

	if(isAllowed) {
		result = true;
	} else {
		if(code >= 96 && code <= 105) code -= 48; // Fix numeric pad 0-9
		if(code == 110) code = 190; // Fix numeric pad .
		if(code == 189 || code == 173) code = 109; // Fix -
		var codeChar = String.fromCharCode(code);
		var codeNum = parseInt(codeChar,10);
		// Code to compensate for the broken fromCharCode / keyCode routines.
		var period = 190;
		var dash = 109;

		var targ;
		if (e.target) {
			targ = e.target;
		} else if (e.srcElement) {
			targ = e.srcElement;
		}

		if (targ.nodeType == 3) targ = targ.parentNode;

		var val = targ.value.toString();

		if(is_ie) {
			targ.focus();
			var range = document.selection.createRange();
			range.text = String.fromCharCode(code);
			var new_val = targ.value.toString();
		} else {
			var start = targ.selectionStart; 
			var end = targ.selectionEnd;
			if(start == 0) {	
				var new_val = String.fromCharCode(code) + val;
			} else {
				var new_val = val.slice(0,start) + String.fromCharCode(code) + val.slice(end-1,val.length-1);
			}
		}
		
		if(
			(codeNum >= 0 && codeNum <= 9) ||
			(code == period && val.indexOf(".") == -1) ||
			(code == dash && val.indexOf("-") == -1)
		) {
			if( (new_val.indexOf(".") != -1 && new_val.substr(new_val.indexOf(".")+1).length <= max) || new_val.indexOf(".") == -1 || !max) {
				if(code == dash && new_val.charAt(0) != String.fromCharCode(dash)) {
					result = false;
				} else {
					result = true;
				}
			} else {
				result = false;
			}
		}
		if(is_ie) {
			if(document.selection.type != "None") {
				document.selection.clear();
				targ.value = new_val;
			}
			if(result && codeNum >= 0 && codeNum <= 9) {
				result = false;
			} else {
				if(result && code == dash) {
					targ.value = new_val.replace(String.fromCharCode(dash),"-");
					result = false;
				} else if(result && code == period) {
					targ.value = new_val.replace(String.fromCharCode(period),".");
					result = false;
				} else {
					targ.value = val;
				}
			}
		}
	}
	e.returnValue = result;
	return result;
}

function checkInteger(e,min) {
	var targ	= getEventTarget(e);
	var val		= parseInt(targ.value.toString(),10);
	if(val < min || isNaN(val)) {
		val = min;
	}
	targ.value = val;
	return true;
}

function checkFloat(e,max) {
	var targ = getEventTarget(e);
	if ( !max ) {
		max = 2;
	}
	val = parseFloat(targ.value.toString());
	if ( isNaN(val) ) {
		val = "0";
	}

	val = val.toString();

	if ( val.indexOf(".") == -1 ) {
		val += ".";
		for ( count = 0; count < max; count++ ) {
			val += "0";
		}
	} else {
		var upper = max - (val.substr(val.indexOf(".")+1).length);
		for ( count = 0; count < upper; count++ ) {
			val += "0";
		}
	}
	targ.value = val;
}
// END - Input number handling routines

function collapseCol(colID,mode) {
	var column_display;
	var colArray = [];

	if ( !mode ) {
		mode = 0;
	}

	if ( mode > 0 ) {
		column_display = "";
	} else {
		column_display = "none";
	}

	if ( id(colID) ) {
		id(colID).style.display = column_display;
	}

	var colArray = document.getElementsByName(colID);
	for ( var i = 0; i < colArray.length; i++ ) {
		colArray[i].style.display = column_display;
	}
}

function getNextSibling(aID) {
	var n = id(aID);
	do n = n.nextSibling;
	while (n && n.nodeType != 1);
	return n;
}

// This function inserts myValue at the cursor position inside myField.
function insertAtCursor(myField, myValue) {
	//IE support
	if (document.selection) {
		myField.focus();
		sel = document.selection.createRange();
		sel.text = myValue;
	}
	//MOZILLA/NETSCAPE support
	else if (myField.selectionStart || myField.selectionStart == '0') {
		var startPos = myField.selectionStart;
		var endPos = myField.selectionEnd;
		myField.value = myField.value.substring(0, startPos)
		+ myValue
		+ myField.value.substring(endPos, myField.value.length);
	} else {
		myField.value += myValue;
	}
}

function openPreferences(w,h) {
	var funcCheck;
	try { 
		funcCheck = (eval("nd instanceof Function"));
	} catch(xxx){}
	if ( funcCheck ) {
		nd();
	}

	if(!w) {w=300;}                          // Default width is 300px
	if(!h) {h=150;}                          // Default height is 150px
	x=screen.availWidth/2 - w/2;    // X co-ord to center screen horizontally
	y=screen.availHeight/2 - h/2;   // X co-ord to center screen virtically

	var sFeatures = "fullscreen=0,width=" + w + ",height=" + h + ",top=" + y + ",left=" + x + ",screenX=" + x + ",screenY=" + y;

	if(is_ie) {
		if ( opener && !opener.closed && opener.dialogWin ) {
			dialogWin.topWindow = opener.dialogWin.topWindow;
		} else {
			dialogWin.topWindow = window;
		}
	}
	
	referringJob = escape(window.location.search.substr(1,3));

	dialogWin.win = window.open("reservation.php?780+"+referringJob,'',sFeatures);
	dialogWin.win.name = name;

	if ( is_ie ) {
		try {
			dialogWin.win.setTimeout("function window.reCheck() { var ccType=false; try { ccType = (closeCheck instanceof Function); } catch(xxx){} if( ccType == true) { if(opener && !opener.closed){ if(opener.nd) { try{ opener.nd(); } catch(xxx){} } } closeCheck(); } else { setTimeout('window.reCheck();',400); } } window.reCheck();",400);
		} catch(xxx) {}
	} else {
		dialogWin.win.setTimeout("function reCheck() { var ccType=false; try { ccType = (closeCheck instanceof Function); } catch(xxx){} if( ccType == true) { if(opener && !opener.closed){ if(opener.nd) { try{opener.nd();} catch(xxx){} } } closeCheck(); } else { setTimeout('reCheck();',400); } } reCheck();",400);
	}
	return dialogWin.win;
}

function funcExists(name) {
	var funcCheck = false;
	try { 
		funcCheck = (eval(name + " instanceof Function"));
	} catch(e){} 
	return funcCheck;
}

function confirmPopupAction() {
	for (var i in responseFunctions) {
		if (funcExists(responseFunctions[i])) {
			eval(responseFunctions[i]+'();');	
		}
	}
}

function cancelPopupAction() {
	for (var i in cancelFunctions) {
		if (funcExists(cancelFunctions[i])) {
			eval(cancelFunctions[i]+'();');	
		}
	}
}

// The following functions will return window width, window height, horizontal scroll bar position and vertical scroll bar position.
// This should provide a browser-independent method of doing do.
// Source: http://www.softcomplex.com/docs/get_window_size_and_scrollbar_position.html

function f_clientWidth() {
	return f_filterResults (
		window.innerWidth ? window.innerWidth : 0,
		document.documentElement ? document.documentElement.clientWidth : 0,
		document.body ? document.body.clientWidth : 0
	);
}
function f_clientHeight() {
	return f_filterResults (
		window.innerHeight ? window.innerHeight : 0,
		document.documentElement ? document.documentElement.clientHeight : 0,
		document.body ? document.body.clientHeight : 0
	);
}
function f_scrollLeft() {
	return f_filterResults (
		window.pageXOffset ? window.pageXOffset : 0,
		document.documentElement ? document.documentElement.scrollLeft : 0,
		document.body ? document.body.scrollLeft : 0
	);
}
function f_scrollTop() {
	return f_filterResults (
		window.pageYOffset ? window.pageYOffset : 0,
		document.documentElement ? document.documentElement.scrollTop : 0,
		document.body ? document.body.scrollTop : 0
	);
}
function f_filterResults(n_win, n_docel, n_body) {
	var n_result = n_win ? n_win : 0;
	if (n_docel && (!n_result || (n_result > n_docel)))
		n_result = n_docel;
	return n_body && (!n_result || (n_result > n_body)) ? n_body : n_result;
}

var dateObj = "";
var useID = 0;

function openCal(obj,e,id,transAfter) {
	useID = id || 0;
	dateObj = obj;
	screenPosX = getClickPosition(e,'x');
	screenPosY = getClickPosition(e,'y');
	openPopup('/resource/Resrequest/Application/public/html/calendar.htm',300,185,screenPosX,screenPosY,null,null,null,null,null,transAfter);
}

// Decode HTML entities
var decodeHTMLField = (function() {
	var textarea = document.createElement('textarea');

	return function(html) {
		textarea.innerHTML = html;
		return textarea.value;
	}
})();

// Encode HTML entities
var encodeHTMLField = (function() {
	var div = document.createElement('div');
	var textNode = document.createTextNode("");
	div.appendChild(textNode);

	return function(text) {
		textNode.nodeValue = text;
		return div.innerHTML;
	}
})();

// Escape attribute text
function encodeAttribute(string) {
	let entityMap = {
		'&': '&amp;',
		'<': '&lt;',
		'>': '&gt;',
		'"': '&quot;',
		"'": '&#39;',
		'/': '&#x2F;',
		'`': '&#x60;',
		'=': '&#x3D;'
	};
	return String(string).replace(/[&<>"'`=\/]/g, function fromEntityMap (s) {
    	return entityMap[s];
	});
}

// Add method to javascript Date object to get short name of month
Date.prototype.getMonthShortName = function() {
	var m = ['Jan','Feb','Mar','Apr','May','Jun','Jul',
	'Aug','Sep','Oct','Nov','Dec'];
	return m[this.getMonth()];
} 

function isValidDate(d) {
  if ( Object.prototype.toString.call(d) !== "[object Date]" )
    return false;
  return !isNaN(d.getTime());
}

// From https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/keys
if (!Object.keys) {
  Object.keys = (function() {
    'use strict';
    var hasOwnProperty = Object.prototype.hasOwnProperty,
        hasDontEnumBug = !({ toString: null }).propertyIsEnumerable('toString'),
        dontEnums = [
          'toString',
          'toLocaleString',
          'valueOf',
          'hasOwnProperty',
          'isPrototypeOf',
          'propertyIsEnumerable',
          'constructor'
        ],
        dontEnumsLength = dontEnums.length;

    return function(obj) {
      if (typeof obj !== 'object' && (typeof obj !== 'function' || obj === null)) {
        throw new TypeError('Object.keys called on non-object');
      }

      var result = [], prop, i;

      for (prop in obj) {
        if (hasOwnProperty.call(obj, prop)) {
          result.push(prop);
        }
      }

      if (hasDontEnumBug) {
        for (i = 0; i < dontEnumsLength; i++) {
          if (hasOwnProperty.call(obj, dontEnums[i])) {
            result.push(dontEnums[i]);
          }
        }
      }
      return result;
    };
  }());
}

if (!Date.now) {
  Date.now = function now() {
    return new Date().getTime();
  };
}

function dateSelector(callback) {
	var selectors = document.getElementsByClassName("dateSelector");

	/*
		Date Selector Usage
		Examples:
		<span id="dateSelectorAuditFrom" class="dateSelector" idPrefix="auditFrom"></span>
		<span id="dateSelectorFrom" class="dateSelector" idPrefix="s" initialValueDay="!sDay!" initialValueMonth="!sMonth!" initialValueYear="!sYear!" customExcludeCal="exclude" minValueYear="2000" maxValueYear="2035"></span>

		Element must contain and ID, class dateSelector, and an idPrefix which acts as a common identifier for day, month and year (eg. mydateFrom will be used as mydateFromDay, mydateFromMonth and mydateFromYear)

		Optional parameters (do not have to use day, month AND year, can be any combination of them):
		initialValueDay, initialValueMonth, initialValueYear: initial values
		customOnChangeDay, customOnChangeMonth, customOnChangeYear, customOnChangeCal: function to be executed on onchange event
		customOnClickDay, customOnClickMonth, customOnClickYear, customOnClickCal: function to be executed on onclick event
		customOnKeyPressDay, customOnKeyPressMonth, customOnKeyPressYear, customOnKeyPressCal: function to be executed on onkeypress event
		customOnBlurDay, customOnBlurMonth, customOnBlurYear, customOnBlurCal: function to be executed on onblur event

		customDisabledDay, customDisabledMonth, customDisabledYear, customDisabledCal: display element but disabled (non-clickable)
		suffixDay, suffixMonth, suffixYear, suffixCal: override the suffix, eg. "day" as opposed to the default "Day"
		customExcludeDay, customExcludeMonth, customExcludeYear, customExcludeCal: exclude the field from being shown (eg. to hide the cal button)
		additionalClassDay, additionalClassMonth, additionalClassYear, additionalClassCal: add additonal CSS classes
		minValueYear, maxValueYear: validate the Year field to minimum and maximum values (can use one, the other, or both)
	*/

	for(var x = 0; x < selectors.length; x++) {
		
		var container = selectors[x];
		var customOnChange = {};
		var customOnClick = {};
		var customOnKeyPress = {};
		var customOnBlur = {};
		var customDisabled = {};
		var minYearOnBlur = {};
		var maxYearOnBlur = {};

		// Skip if container is already populated
		if (container.hasChildNodes()) {
			continue;
		}

		if (
			container.getAttribute("idPrefix") === null ||
			container.getAttribute("idPrefix").trim() === ""
		) {
			// No prefix
		} else {
			var id = container.getAttribute("id").trim();
			var idPrefix = container.getAttribute("idPrefix").trim();
			customOnChange[idPrefix+"_customOnChangeDay"] = container.getAttribute("customOnChangeDay") !== null ? container.getAttribute("customOnChangeDay").trim() : "";
			customOnChange[idPrefix+"_customOnChangeMonth"] = container.getAttribute("customOnChangeMonth") !== null ? container.getAttribute("customOnChangeMonth").trim() : "";
			customOnChange[idPrefix+"_customOnChangeYear"] = container.getAttribute("customOnChangeYear") !== null ? container.getAttribute("customOnChangeYear").trim() : "";
			customOnChange[idPrefix+"_customOnChangeCal"] = container.getAttribute("customOnChangeCal") !== null ? container.getAttribute("customOnChangeCal").trim() : "";

			customOnClick[idPrefix+"_customOnClickDay"] = container.getAttribute("customOnClickDay") !== null ? container.getAttribute("customOnClickDay").trim() : "";
			customOnClick[idPrefix+"_customOnClickMonth"] = container.getAttribute("customOnClickMonth") !== null ? container.getAttribute("customOnClickMonth").trim() : "";
			customOnClick[idPrefix+"_customOnClickYear"] = container.getAttribute("customOnClickYear") !== null ? container.getAttribute("customOnClickYear").trim() : "";
			customOnClick[idPrefix+"_customOnClickCal"] = container.getAttribute("customOnClickCal") !== null ? container.getAttribute("customOnClickCal").trim() : "";

			customOnKeyPress[idPrefix+"_customOnKeyPressDay"] = container.getAttribute("customOnKeyPressDay") !== null ? container.getAttribute("customOnKeyPressDay").trim() : "";
			customOnKeyPress[idPrefix+"_customOnKeyPressMonth"] = container.getAttribute("customOnKeyPressMonth") !== null ? container.getAttribute("customOnKeyPressMonth").trim() : "";
			customOnKeyPress[idPrefix+"_customOnKeyPressYear"] = container.getAttribute("customOnKeyPressYear") !== null ? container.getAttribute("customOnKeyPressYear").trim() : "";
			customOnKeyPress[idPrefix+"_customOnKeyPressCal"] = container.getAttribute("customOnKeyPressCal") !== null ? container.getAttribute("customOnKeyPressCal").trim() : "";

			customOnBlur[idPrefix+"_customOnBlurDay"] = container.getAttribute("customOnBlurDay") !== null ? container.getAttribute("customOnBlurDay").trim() : "";
			customOnBlur[idPrefix+"_customOnBlurMonth"] = container.getAttribute("customOnBlurMonth") !== null ? container.getAttribute("customOnBlurMonth").trim() : "";
			customOnBlur[idPrefix+"_customOnBlurYear"] = container.getAttribute("customOnBlurYear") !== null ? container.getAttribute("customOnBlurYear").trim() : "";
			customOnBlur[idPrefix+"_customOnBlurCal"] = container.getAttribute("customOnBlurCal") !== null ? container.getAttribute("customOnBlurCal").trim() : "";

			customDisabled[idPrefix+"_customDisabledDay"] = container.getAttribute("customDisabledDay") !== null && container.getAttribute("customDisabledDay") !== "" ? container.getAttribute("customDisabledDay").trim() : "";
			customDisabled[idPrefix+"_customDisabledMonth"] = container.getAttribute("customDisabledMonth") !== null && container.getAttribute("customDisabledMonth") !== "" ? container.getAttribute("customDisabledMonth").trim() : "";
			customDisabled[idPrefix+"_customDisabledYear"] = container.getAttribute("customDisabledYear") !== null && container.getAttribute("customDisabledYear") !== "" ? container.getAttribute("customDisabledYear").trim() : "";
			customDisabled[idPrefix+"_customDisabledCal"] = container.getAttribute("customDisabledCal") !== null && container.getAttribute("customDisabledCal") !== "" ? container.getAttribute("customDisabledCal").trim() : "";

			suffixDay = container.getAttribute("suffixDay") !== null && container.getAttribute("suffixDay") !== "" ? container.getAttribute("suffixDay").trim() : "Day";
			suffixMonth = container.getAttribute("suffixMonth") !== null && container.getAttribute("suffixMonth") !== "" ? container.getAttribute("suffixMonth").trim() : "Month";
			suffixYear = container.getAttribute("suffixYear") !== null && container.getAttribute("suffixYear") !== "" ? container.getAttribute("suffixYear").trim() : "Year";
			suffixCal = container.getAttribute("suffixCal") !== null && container.getAttribute("suffixCal") !== "" ? container.getAttribute("suffixCal").trim() : "Cal";

			showDay = container.getAttribute("customExcludeDay") !== null && container.getAttribute("customExcludeDay") != "" ? false : true;
			showMonth = container.getAttribute("customExcludeMonth") !== null && container.getAttribute("customExcludeMonth") != "" ? false : true;
			showYear = container.getAttribute("customExcludeYear") !== null && container.getAttribute("customExcludeYear") != "" ? false : true;
			showCal = container.getAttribute("customExcludeCal") !== null && container.getAttribute("customExcludeCal") != "" ? false : true;
			showCalTransAfter = container.getAttribute("customCalTransAfter") !== null && container.getAttribute("customCalTransAfter") != "" ? true : false;

			additionalClassDay = container.getAttribute("additionalClassDay") !== null ? container.getAttribute("additionalClassDay").trim() : "";
			additionalClassMonth = container.getAttribute("additionalClassMonth") !== null ? container.getAttribute("additionalClassMonth").trim() : "";
			additionalClassYear = container.getAttribute("additionalClassYear") !== null ? container.getAttribute("additionalClassYear").trim() : "";

			initialValueDay = container.getAttribute("initialValueDay") !== null ? container.getAttribute("initialValueDay").trim() : "";
			initialValueMonth = container.getAttribute("initialValueMonth") !== null ? container.getAttribute("initialValueMonth").trim().replace(/^0+/, '') : "";
			initialValueYear = container.getAttribute("initialValueYear") !== null ? container.getAttribute("initialValueYear").trim() : "";

			minYearOnBlur[idPrefix+"_minYearOnBlur"] = container.getAttribute("minValueYear") !== null ? container.getAttribute("minValueYear").trim() : "0";
			maxYearOnBlur[idPrefix+"_maxYearOnBlur"] = container.getAttribute("maxValueYear") !== null ? container.getAttribute("maxValueYear").trim() : "0";

			reloadCal = container.getAttribute("reloadCal") !== null ? 0 : 1;

			// Day selector
			var dayArray = ["1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19","20","21","22","23","24","25","26","27","28","29","30","31"];

			var newElement = document.createElement("select");
			newElement.id = idDay = idPrefix+suffixDay;
			newElement.name = idPrefix+suffixDay;
			newElement.className = "calElement "+additionalClassDay;
			if (!showDay) {
				newElement.style.cssText = 'display:none;';
			}
			if (customOnChange[idPrefix+"_customOnChangeDay"] != "") {
				newElement.setAttribute("onchange", customOnChange[idPrefix+"_customOnChangeDay"] + "; changedFilter=true;" );
			} else {
				newElement.setAttribute("onchange", "changedFilter=true;" );
			}
			if (customOnClick[idPrefix+"_customOnClickDay"] != "") {
				newElement.setAttribute("onclick", customOnClick[idPrefix+"_customOnClickDay"]+";" );
			}
			if (customOnKeyPress[idPrefix+"_customOnKeyPressDay"] != "") {
				newElement.setAttribute("onkeypress", customOnKeyPress[idPrefix+"_customOnKeyPressDay"]+";" );
			}
			if (customOnBlur[idPrefix+"_customOnBlurDay"] != "") {
				newElement.setAttribute("onblur", customOnBlur[idPrefix+"_customOnBlurDay"]+";" );
			}
			if (customDisabled[idPrefix+"_customDisabledDay"] != "") {
				newElement.setAttribute("disabled","true");
			}
			container.appendChild(newElement);

			var option = document.createElement("option");
			option.value = "dd";
			option.text = "";
			newElement.appendChild(option);

			for (var i = 0; i < dayArray.length; i++) {
				var option = document.createElement("option");
				option.value = dayArray[i];
				option.text = ("0"+dayArray[i]).slice(-2);
				newElement.appendChild(option);
			}

			// Month selector
			var monthArray = ["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"];

			var newElement = document.createElement("select");
			newElement.id = idMonth = idPrefix+suffixMonth;
			newElement.name = idPrefix+suffixMonth;
			newElement.className = "calElement "+additionalClassMonth;
			newElement.style.cssText = 'margin-left:3px;';
			if (!showMonth) {
				newElement.style.cssText = 'display:none;';
			}
			if (customOnChange[idPrefix+"_customOnChangeMonth"] != "") {
				newElement.setAttribute("onchange", customOnChange[idPrefix+"_customOnChangeMonth"] + "; changedFilter=true; dateSelectorValidate();" );
			} else {
				newElement.setAttribute("onchange", "changedFilter=true; dateSelectorValidate();" );
			}
			if (customOnClick[idPrefix+"_customOnClickMonth"] != "") {
				newElement.setAttribute("onclick", customOnClick[idPrefix+"_customOnClickMonth"]+";" );
			}
			if (customOnKeyPress[idPrefix+"_customOnKeyPressMonth"] != "") {
				newElement.setAttribute("onkeypress", customOnKeyPress[idPrefix+"_customOnKeyPressMonth"]+";" );
			}
			if (customOnClick[idPrefix+"_customOnClickMonth"] != "") {
				newElement.setAttribute("onclick", customOnClick[idPrefix+"_customOnClickMonth"]+";" );
			}
			if (customOnBlur[idPrefix+"_customOnBlurMonth"] != "") {
				newElement.setAttribute("onblur", customOnBlur[idPrefix+"_customOnBlurMonth"]+";" );
			}
			if (customDisabled[idPrefix+"_customDisabledMonth"] != "") {
				newElement.setAttribute("disabled","true");
			}
			container.appendChild(newElement);

			var option = document.createElement("option");
			option.value = "mm";
			option.text = "";
			newElement.appendChild(option);

			for (var i = 0; i < monthArray.length; i++) {
				var option = document.createElement("option");
				option.value = i+1;
				option.text = monthArray[i];
				newElement.appendChild(option);
			}

			// Year input
			var newElement = document.createElement("input");
			newElement.id = idYear = idPrefix+suffixYear;
			newElement.name = idPrefix+suffixYear;
			newElement.className = "calElement txt "+additionalClassDay;
			newElement.type = "text";
			newElement.size = "4";
			newElement.setAttribute("maxlength","4");
			newElement.style.cssText = 'margin-left:3px;';
			if (!showYear) {
				newElement.style.cssText = 'display:none;';
			}
			if (customOnChange[idPrefix+"_customOnChangeYear"] != "") {
				newElement.setAttribute("onchange", customOnChange[idPrefix+"_customOnChangeYear"] + "; changedFilter=true; dateSelectorValidate();" );
			} else {
				newElement.setAttribute("onchange", "changedFilter=true; dateSelectorValidate();" );
			}
			if (customOnClick[idPrefix+"_customOnClickYear"] != "") {
				newElement.setAttribute("onclick", customOnClick[idPrefix+"_customOnClickYear"]+";" );
			}
			if (customOnKeyPress[idPrefix+"_customOnKeyPressYear"] != "") {
				newElement.setAttribute("onkeypress", customOnKeyPress[idPrefix+"_customOnKeyPressYear"]+";" );
			}

			onBlurYear = "";
			if (minYearOnBlur[idPrefix+"_minYearOnBlur"] != "0" || maxYearOnBlur[idPrefix+"_maxYearOnBlur"] != "0") {
				onBlurYear = onBlurYear+"yearRangeValidate('"+idPrefix+suffixYear+"',"+minYearOnBlur[idPrefix+"_minYearOnBlur"]+","+maxYearOnBlur[idPrefix+"_maxYearOnBlur"]+"); "+customOnBlur[idPrefix+"_customOnBlurYear"]+";";
			}
			if (customOnBlur[idPrefix+"_customOnBlurYear"] != "") {
				onBlurYear = onBlurYear+customOnBlur[idPrefix+"_customOnBlurYear"]+";";
			}
			if (onBlurYear != "") {
				newElement.setAttribute("onblur", onBlurYear );
			}

			if (customDisabled[idPrefix+"_customDisabledYear"] != "") {
				newElement.setAttribute("disabled","true");
			}
			container.appendChild(newElement);

			// Calendar button
			if (showCal) {
				var newElement = document.createElement("button");
				newElement.id = idPrefix+suffixCal;
				newElement.name = idPrefix+suffixCal;
				newElement.className = "btn btn-sqr uk-margin-left btn-lgrey btn-cal";
				newElement.type = "button";
				newElement.setAttribute("prefix",idPrefix);
				newElement.style.cssText = 'vertical-align: middle';
				if (customOnChange[idPrefix+"_customOnChangeCal"] != "") {
					newElement.setAttribute("onchange", customOnChange[idPrefix+"_customOnChangeCal"]+";" );
				}
				if (customOnClick[idPrefix+"_customOnClickCal"] != "") {
					newElement.setAttribute("onclick", customOnClick[idPrefix+"_customOnClickCal"]+";" );
				}
				if (customOnKeyPress[idPrefix+"_customOnKeyPressCal"] != "") {
					newElement.setAttribute("onkeypress", customOnKeyPress[idPrefix+"_customOnKeyPressCal"]+";" );
				}
				if (customOnBlur[idPrefix+"_customOnBlurCal"] != "") {
					newElement.setAttribute("onblur", customOnBlur[idPrefix+"_customOnBlurCal"]+";" );
				}
				if (customDisabled[idPrefix+"_customDisabledCal"] != "") {
					newElement.setAttribute("disabled","true");
				}
				newElement.innerHTML = "<i class=\"material-icons\">event</i>"
				container.appendChild(newElement);

				customCalClickHandler = function(transAfter) {
					return function(e) {
						calClickHandler(e,transAfter);
					}
				}(showCalTransAfter);
				if (newElement.addEventListener)
					newElement.addEventListener ('click',customCalClickHandler,false);
				else if (newElement.attachEvent)
					newElement.attachEvent ('click',customCalClickHandler);
			}

			// Hidden date input
			var existingElement =  document.getElementById(idPrefix);
			if (typeof(element) != 'undefined' && element != null) {
				// Element already exists, do nothing
			} else {
				var newElement = document.createElement("input");
				newElement.id = idPrefix;
				newElement.name = idPrefix;
				newElement.type = "hidden";
				newElement.value = "";
				container.appendChild(newElement);
			}

			// Set initial date
			var the_date	= new Date();
			var day			= the_date.getDate();
			var month		= the_date.getMonth()+1;
			var year		= the_date.getFullYear();
			date 			= year+"-"+month+"-"+day;

			var dateSplit = date.split("-");
			document.getElementById(idDay).value = initialValueDay != "" ? initialValueDay : dateSplit[2];
			document.getElementById(idMonth).value = initialValueMonth != "" ? initialValueMonth : dateSplit[1];
			document.getElementById(idYear).value = initialValueYear != "" ? initialValueYear : dateSplit[0];
			

		}
	}
	dateSelectorValidate();
	var callbackFunction = new Function( callback );
	callbackFunction();
}

function calClickHandler(e,transAfter) {
	changedFilter=true;
	var idPrefix = e.currentTarget.getAttribute("prefix");
	openCal(idPrefix, e, reloadCal,transAfter);
}

function populateDateFields(idYear, valueYear, idMonth, valueMonth, idDay, valueDay) {
	// This function sets the date dropdowns to the correct values, after a form has generated.
	// The month and year values needs to be set first, then we perform a validate to
	// populate the correct number of days for the selected month, before setting the day dropdown.
	// This caters for scenarios of 29 Feb, and the 31st (when currently in a 30-day month)
	if (id(idMonth) != null && id(idYear) != null && id(idDay) != null) {
		id(idMonth).selectedIndex = valueMonth;
		id(idYear).value = valueYear;
		dateSelectorValidate();
		id(idDay).selectedIndex = valueDay;
	}
}

function dateSelectorValidate() {
	var selectors = document.getElementsByClassName("dateSelector");

	for(var i = 0; i < selectors.length; i++) {
		var container = selectors[i];
		
		if (
			container.getAttribute("idPrefix") === null ||
			container.getAttribute("idPrefix").trim() === ""
		) {
			// No prefix
		} else {
			var idPrefix = container.getAttribute("idPrefix").trim();
			var suffixDay = container.getAttribute("suffixDay") !== null && container.getAttribute("suffixDay").trim() != "" ? container.getAttribute("suffixDay").trim() : "Day";
			var suffixMonth = container.getAttribute("suffixMonth") !== null && container.getAttribute("suffixMonth").trim() != "" ? container.getAttribute("suffixMonth").trim() : "Month";
			var suffixYear = container.getAttribute("suffixYear") !== null && container.getAttribute("suffixYear").trim() != "" ? container.getAttribute("suffixYear").trim() : "Year";
      var selectedMonth = (id(idPrefix+suffixMonth).selectedIndex < 0?"0":id(idPrefix+suffixMonth).options[id(idPrefix+suffixMonth).selectedIndex].value);

			setDayList(id(idPrefix+suffixDay),selectedMonth,id(idPrefix+suffixYear).value);
		}
	}
}

function yearRangeValidate(id,min,max) {
	value = document.getElementById(id).value;
	currentYear = new Date().getFullYear();
	if (max != "0" && value > max) {
		openMessage("The calendar is restricted to the year "+max,"a",120);
		document.getElementById(id).value = currentYear;
		triggerEvents(id);
	}
	if (min != "0" && value < min) {
		openMessage("The calendar is restricted to a minimum year "+min,"a",120);
		document.getElementById(id).value = currentYear;
		triggerEvents(id);
	}
}

function triggerEvents(id) {
	// This is to trigger a keyup or onchange event for field where other event listeners are in place
	let keyupEvent = new Event('keyup');
	document.getElementById(id).dispatchEvent(keyupEvent);
	let onchangeEvent = new Event('change');
	document.getElementById(id).dispatchEvent(onchangeEvent);
}

function overlayPopup(title, message, buttons, width) {
	// Usage example:
	// var buttons = {
	// 	'a':{'label':'OK', 'callback':'success()', 'class':''},
	// 	'b':{'label':'Yes', 'callback':'yes()', 'class':'masterButton'},
	// 	'c':{'label':'No', 'callback':'no()', 'class':''}
	// };
	// overlayPopup('title', 'message', buttons, 300);
  // include a class of 'doNotClose' for a button to prevent the popup from closing after clicked (only execute callback function)
  if (buttons == undefined || buttons == "") {
    var buttons = { 'a':{'label':'OK', 'callback':'', 'class':''} };
	}
	if (width == undefined) {
		width = '300';
	}
  var container = `<div id="overlayPopup" style="position: absolute; z-index: 100; display:none; width:` + width + `px; -webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; overflow: hidden">`;
	if (title != '') {
		container += `<table width="100%" border="0" cellspacing="0" cellpadding="0" class="colDk bb handle">
				<tr style="background-color: #c9252f; height:50px;">
					<td style="color: #fff; font-size: 20px; font-weight:normal; padding-left: 10px;">` + title + `</td>
					<td align="right" style="padding-right: 10px;">
						<i class="material-icons" style="color: white; cursor: pointer; position: relative; top: 50%; left: 3px;" onclick="closeOverlayPopup();">close</i>
					</td>
				</tr>
			</table>`;
	}

	container += `<table width="100%" border="0" cellspacing="0" cellpadding="0" class="colLt" summary="">
				<tr>
					<td id="messageTextTD" class="txt" style="height: 50px;" valign="middle" align="center">
						<div id="messageText" class="txt" align="center">
							` + message + `
						</div>
					</td>
				</tr>
				<tr>
					<td align="center" id="overlayButtonContainer" class="outDk" style="height: 35px; background-color: #f6f6f6;">`;
	$.each(buttons, function(index, element) {
    var doNotClose = element.class.includes("doNotClose") ? "" : " closeOverlayPopup();";
    var strId = "";
    if(element.hasOwnProperty('id')) {
        strId = (element.id !== "") ? " id=\"" + element.id + "\"" : "";
    }

    container += `<button type="button" ` + strId +`class="button txtc ` + element.class + `" onclick="` + element.callback + `; ` + doNotClose + `">
            ` + element.label + `
    </button>`;
	});
	container += `</td>
				</tr>
			</table>
      <div id="overlayLoadingCircle" style="position: absolute; top:50%; left:50%; margin-top:-20px; margin-left:-20px;"></div>
		</div>
	`;
  applyTrans(1);
  if (shadowName) {
    $(shadow.shadowRoot).append(container);
  } else {
    $("body").append(container);
  }
  $("#overlayPopup", documentRoot).hide().fadeIn(250);
	centerDivOnPage('overlayPopup');

  (function($) {
    $.fn.draggable = function(opt) {
      opt = $.extend({handle:"",cursor:"move"}, opt);

      if(opt.handle === "") {
        var $el = this;
      } else {
        var $el = this.find(opt.handle);
      }
      return $el.css('cursor', opt.cursor).on("mousedown", function(e) {
        if(opt.handle === "") {
          var $drag = $(this).addClass('draggable');
        } else {
          var $drag = $(this).addClass('active-handle').parent().addClass('draggable');
        }
        var z_idx = $drag.css('z-index'),
          drg_h = $drag.outerHeight(),
          drg_w = $drag.outerWidth(),
          pos_y = $drag.offset().top + drg_h - e.pageY,
          pos_x = $drag.offset().left + drg_w - e.pageX;
        $drag.css('z-index', 1000).parents().on("mousemove", function(e) {
          $('.draggable').offset({
            top:e.pageY + pos_y - drg_h,
            left:e.pageX + pos_x - drg_w
          }).on("mouseup", function() {
            $(this).removeClass('draggable').css('z-index', z_idx);
          });
        });
      }).on("mouseup", function() {
        if(opt.handle === "") {
          $(this).removeClass('draggable');
        } else {
          $(this).removeClass('active-handle').parent().removeClass('draggable');
        }
      });
    }
  })(jQuery);

  $('#overlayPopup', documentRoot).draggable({handle:".handle"});

  $(documentRoot).keyup(function(e) {
    if (e.keyCode == 27) {    // ESC
      closeOverlayPopup();
    }
  });
}

function closeOverlayPopup() {
  $(id("overlayPopup")).fadeOut(200, function(){
    id("overlayPopup").remove();
  });
  if (typeof tailDatePicker === "object" && tailDatePicker !== null) {
    tailDatePicker.close();
  }
  applyTrans(0);
}

// Ref: https://stackoverflow.com/questions/105034/create-guid-uuid-in-javascript
function generateUUID() { // Public Domain/MIT
    var d = new Date().getTime();
    if (typeof performance !== 'undefined' && typeof performance.now === 'function'){
        d += performance.now(); //use high-precision timer if available
    }
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        var r = (d + Math.random() * 16) % 16 | 0;
        d = Math.floor(d / 16);
        return (c === 'x' ? r : (r & 0x3 | 0x8)).toString(16);
    });
}

function showHideOverlayLoadingCircle(showHide) {
    switch ( showHide ) {
    case undefined:     // toggle
        if ($("#overlayLoadingCircle", documentRoot).html() == "") {
            $("#overlayLoadingCircle", documentRoot).html('<div class="loaderCircle"></div>');
        } else {
            $("#overlayLoadingCircle", documentRoot).html('');
        }
        break;
    case "show":
        $("#overlayLoadingCircle", documentRoot).html('<div class="loaderCircle"></div>');
        break;
    case "hide":
        $("#overlayLoadingCircle", documentRoot).html('');
        break;
    }
}

function initTooltipster() {
  if (shadowName) {
    $(".tooltip", documentRoot).not(".tooltipstered").tooltipster({
      theme: 'tooltipster-shadow',
      side: 'bottom',
      contentAsHTML: true
    });
  } else {
    $('.tooltip').not(".tooltipstered").tooltipster({
      theme: 'tooltipster-shadow',
      side: 'bottom',
      contentAsHTML: true
    });
  }
}

function reminderPopup(action, reminder_id, pr_persona_detail) {
    var width = 550;
    var buttons, content, title , reReminderReferToId = "";

    if (action === "" || action === undefined || action === null) {
        action = 1;
    }

    if (reminder_id !== "" && reminder_id !== undefined && reminder_id !== null) {
    	reReminderReferToId = reminder_id;
	}

    content = `
				<div style="margin-left: 10px;">
					<table width="100%" cellspacing="0" cellpadding="0px" class="inLt" align="center">
						<tr>
							<td>&nbsp;</td>
						</tr>
						<tr>
							<td class="txt">This note is for:</td></td>
							<td class="txt">
								<input type="hidden" id="reReminderIdValue" name="reReminderIdValue" value="">
								<input type="hidden" id="reReminderUpdated" name="reReminderUpdated" value="1">
								<input type="hidden" id="reReminderReferToIdHidden" name="reReminderReferToIdHidden" value="">
								<select id="reReminderReferToId" name="reReminderReferToId"  class="select2" style="width:400px;height: 20px; !important;">
								</select>
                <span id="reReminderReferToIdSpan" style="width:400px;"></span>
							</td>
						</tr>
						<tr>
							<td>&nbsp;</td>
						</tr>
						<tr>
							<td style="vertical-align: top;">Reminder:</td>
							<td class=""><textarea style="width: 400px;" id="reReminderNote"  name="reReminderNote"  rows="6" placeholder="Add your reminder here ..."></textarea></td>
						</tr>
						<tr>
							<td>&nbsp;</td>
						</tr>
						<tr>
							<td class="txt">Daily repeat:</td>
							<td class="txt">
								<input type="radio" id="reReminderRepeatYes" name="reReminderRepeat" value="1"> Yes &nbsp;&nbsp;<input type="radio" id="reReminderRepeatNo" name="reReminderRepeat" value="0" checked> No<br>
							</td>
						</tr>
						<tr>
							<td>&nbsp;</td>
						</tr>
						<tr>
							<td class="txt">Date and time:</td>
              <td class="txt">
                <div id="reReminderSendDateContainer">
                  <input id="reReminderSendDate"  name="reReminderSendDate" type="text" style="width:400px;height: 22px; !important;" value="">
                </div>
              </td>
						</tr>
						<tr>
							<td>&nbsp;</td>
						</tr>
						<tr>
							<td class="txt">Email reminder to: </td>
							<td  class="txt">
								<label for="reReminderIncludeMe" >Include me</label>
								<input type="checkbox" name="reReminderIncludeMe" id="reReminderIncludeMe" >&nbsp;
							</td>
						</tr>
						
						<tr>
							<td>&nbsp;</td>
						</tr>
						<tr>
							<td class="txt">&nbsp;</td>
							<td class="txt">
								<select id="reReminderPersonaId" name="reReminderPersonaId"  multiple class="select2" style="width:400px;height: 20px; !important;" ></select>
                <br/>
                <span id="reReminderPersonaIdSpan" style="width:400px;"></span>
							</td>
						</tr>
						
					</table>
				</div>
				<div>
				<table width="90%" cellspacing="0px" align="center" style="">
						<tr>
							<td>&nbsp;</td>
						</tr>
						<tr style="height: 40px;">
							<td id ="txtAddReReminderResult" align="center" style="color: #787878;font-size: 9pt;"></td>
						</tr>
						<tr>
							<td colspan="3" class="colLt" height="10"><img src="/resource/Resrequest/Application/public/img/1x1.gif"></td>
						</tr>
					</table>
				</div>
		`;

	if(action === 1 ) {
        title = "Add Reminder";
        buttons =  {
            'a':{ 'id' : 'btnAddReReminder' ,'label':'&nbsp;&nbsp;Add&nbsp;&nbsp;', 'callback':'btnAddReReReminderFunction()', 'class':'masterButton doNotClose'},
            'b':{ 'label':'Close', 'callback':'closeReReminderPopup()', 'class':'doNotClose'}
        };

        overlayPopup(title, content, buttons, width);
        applyTrans(1);
        initialiseReminderPopup(
            pr_persona_detail,
            reReminderReferToId,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            action
        );
	}
	else if(parseInt(action) === 2 && reminder_id !== "") {
        var url = internalAPIReminderEndPoint + 'get_reminder';

        title = "Edit Reminder";

        buttons =  {
            'a':{'id' : 'btnEditReReminder', 'label':'&nbsp;&nbsp;Update&nbsp;&nbsp;', 'callback':'btnEditReReReminderFunction()', 'class':'masterButton doNotClose'},
            'b':{'label':'Close', 'callback':'closeReReminderPopup()', 'class':''}
        };

         $.ajax({
            type:"POST",
            url: url,
            cache: false,
            data: JSON.stringify({reReminderId : reminder_id}),
            beforeSend: function(request) {
            request.setRequestHeader("Accept", "application/json");
            request.setRequestHeader("Content-Type", "application/json");
			},
      success: function(response) {
          if(response.hasOwnProperty('data') && response.data !== undefined) {
              var returnValue = response.data;
              overlayPopup(title, content, buttons, width);
              applyTrans(1);
              initialiseReminderPopup (null, returnValue.ReReminderReferToId, returnValue.ReReminderNote, returnValue.ReReminderRepeat,
              returnValue.ReReminderRecipientCCMe, returnValue.ReReminderSendDate, returnValue.ReReminderRecipientListId,
              returnValue.ReReminderRecipientListName, reminder_id, action);

          }
      }
    });
	}
	return ;
}

function closeReReminderPopup() {
  closeOverlayPopup();
  var value = $('#reReminderUpdated', documentRoot).val();

  if(parseInt(value) === 2) {
    location.reload(true);
  }
}

function initialiseReminderPopup(reReminderContactDetail, reReminderReferToId, reReminderNote, reReminderDailyRepeat, reReminderIncludeMe, reReminderDate, reReminderPersonaId, reReminderPersonaName, reReminderIdValue, action) {
  var min_date = moment().startOf('minutes');
  var startDate;
  if (parseInt(action) === 1) {
    if($(id("reReminderNote")).val().trim() == "") {
      $(id("reReminderIncludeMe")).prop("checked", true);
    }
  }
  var par = shadow ? documentRoot.getElementById("overlayPopup") : $('body');
  $(id('reReminderPersonaId')).select2({
    ajax: {
      url: 'api/v1/reminders/get_user_email',
      type: "POST",
      delay: 250,
      cache: true,
      beforeSend: function(request) {
        request.setRequestHeader("Accept", "application/json");
        request.setRequestHeader("Content-Type", "application/json");
      },
      data: function (params) {
        return JSON.stringify({
          query: params.term
        });
      },
      processResults: function (response) {
        return response;
      }
    },
    minimumInputLength: 2,
    placeholder: "Select recipient users",
    dropdownParent: par
  }).on("select2:open", function (e) {
    if (shadow) {
      // Select2 has a lot of trouble positioning correctly in shadow dom
      var select2Dd = documentRoot.querySelector(".select2-dropdown--below") || documentRoot.querySelector(".select2-dropdown--above");
      if (select2Dd) {
        select2Dd.style.top = (id("reReminderPersonaId").offsetTop - 1) + "px";
        select2Dd.style.left = (id("reReminderPersonaId").offsetLeft - 2) + "px";
      }
    }
  });

  $(id('reReminderReferToId')).select2({
    ajax: {
      url: 'api/v1/reminders/get_refer_to',
      beforeSend: function(request) {
        request.setRequestHeader("Accept", "application/json");
        request.setRequestHeader("Content-Type", "application/json");
      },
      type: "POST",
      delay: 250,
      cache: true,
      data: function (params) {
        return JSON.stringify({
          query: params.term
        });
      },
      processResults: function (response) {
        return response;
      }
    },
    minimumInputLength: 2,
    placeholder: "Select a reservation or contact",
    dropdownParent: par
  }).on("select2:open", function (e) {
    if (shadow) {
      // Select2 has a lot of trouble positioning correctly in shadow dom
      var select2Dd = documentRoot.querySelector(".select2-dropdown--below") || documentRoot.querySelector(".select2-dropdown--above");
      if (select2Dd) {
        select2Dd.style.top = (id("reReminderReferToId").offsetTop - 1) + "px";
        select2Dd.style.left = (id("reReminderReferToId").offsetLeft - 2) + "px";
      }
    }
  });

  if(reReminderNote !== undefined || reReminderNote !== null) {
    $('#reReminderNote', documentRoot).val(reReminderNote);
  }

  if(reReminderDailyRepeat !== undefined || reReminderDailyRepeat !== null) {
    var radValue = (parseInt(reReminderDailyRepeat) === 1) ? 1 : 0;
    $("input[name='reReminderRepeat'][value='"+ radValue +"']", documentRoot).prop('checked', true);
  }

  if(reReminderReferToId !== "" && reReminderReferToId !== undefined && reReminderReferToId !== null) {

    var ReferToSelect = $('#reReminderReferToId', documentRoot);

    var setReferToInfo = reReminderReferToId.split("|");

    var selectText = (reReminderContactDetail !== undefined
      && reReminderContactDetail !== null
      && reReminderContactDetail !== '') ? reReminderContactDetail : setReferToInfo[1];

    var ref_option = new Option(selectText, setReferToInfo[1], true, true);
    ReferToSelect.append(ref_option).trigger('change');
    ReferToSelect.trigger({
      type: 'select2:select',
      params: {
        data: {
          id : reReminderReferToId,
          text : selectText
        }
      }
    });

    ReferToSelect.prop('disabled', 'disabled');
    $('#reReminderReferToIdHidden', documentRoot).val(reReminderReferToId);
  }

  if(reReminderPersonaId !== undefined && reReminderPersonaId !== null && reReminderPersonaId !== "") {
    var UsersSelect = $('#reReminderPersonaId', documentRoot);
    var optUserId = reReminderPersonaId.split(',');
    var optUserName = reReminderPersonaName.split('|');
    for (var i = 0; i < optUserId.length; i++) {
      var option = new Option(optUserName[i], optUserId[i], true, true);
      UsersSelect.append(option).trigger('change');
      UsersSelect.trigger({
        type: 'select2:select',
        params: {
          data: {
            id : optUserId[i],
            text : optUserName[i]
          }
        }
      });
    }
  }

  if(reReminderIdValue !== undefined && reReminderIdValue !== null && reReminderIdValue !== "") {
    $('#reReminderIdValue', documentRoot).val(reReminderIdValue);
  }

  if(reReminderDate !== undefined && reReminderDate !== null && reReminderDate !== ""){
    startDate = reReminderDate;
  }
  else {
    var start = moment();
    var remainder = 5 - (start.minute() % 5);
    startDate = moment(start).add(remainder, "minutes");
  }

  var today = new Date();
  tailDatePicker = tail.DateTime(
    "#reReminderSendDate", 
    { 
      closeButton: true,
      timeSeconds: false,
      timeStepMinutes: 5,
      timeFormat: "HH:ii",
      dateStart: new Date(today.getFullYear(), today.getMonth(), today.getDate()),
      dateEnd: new Date(2099, 12, 31),
      stayOpen: true
    }, 
    documentRoot
  );
}

function btnAddReReReminderFunction() {
  $('#reReminderUpdated', documentRoot).val(1);

  var url = internalAPIReminderEndPoint + 'add_reminder';
  var txtResult = id("txtAddReReminderResult");

  showHideOverlayLoadingCircle("show");

  var reReminderNote = $('#reReminderNote', documentRootChildren).val();
  var reReminderSendDate = $('#reReminderSendDate', documentRootChildren).val();
  var reReminderSendDateTz = Intl.DateTimeFormat().resolvedOptions().timeZone;
  var reReminderReferToId = $('#reReminderReferToId', documentRootChildren).val();
  var reReminderPersonaId = $('#reReminderPersonaId', documentRootChildren).val();
  reReminderPersonaId = (reReminderPersonaId !== null && reReminderPersonaId !== "") ? reReminderPersonaId.join(',') : '';
  var reReminderIncludeMe = ($('#reReminderIncludeMe', documentRootChildren).is(":checked")) ? 1 : 0;
  var reReminderRepeat = $('input[name="reReminderRepeat"]:checked', documentRootChildren).val();

  //Check if reReminderReferToId is disable, to use the hidden value
  if($('#reReminderReferToId', documentRootChildren).is(':disabled') && $('#reReminderReferToIdHidden', documentRootChildren).val() !== "") {
    reReminderReferToId = $('#reReminderReferToIdHidden', documentRootChildren).val();
  }

  var btnAddReReminder = $('#btnAddReReminder', documentRootChildren);

  $.ajax({
    type:"POST",
    url: url,
    cache: false,
    data: JSON.stringify({
      reNote : reReminderNote,
      reSendDate : reReminderSendDate,
      reSendDateTz : reReminderSendDateTz,
      reReferToId : reReminderReferToId,
      rePersonaId : reReminderPersonaId,
      reIncludeMe : reReminderIncludeMe,
      reRepeatYn : reReminderRepeat
    }),
    beforeSend: function(request){
      request.setRequestHeader("Accept", "application/json");
      request.setRequestHeader("Content-Type", "application/json");
      btnAddReReminder.attr('disabled','disabled');
    },
    success: function(response){
      showHideOverlayLoadingCircle("hide");
      if(response.status === "success"){
          txtResult.style.background = "#E2FEE2";
          btnAddReReminder.prop('disabled', true);
          btnAddReReminder.hide();
          $('#reReminderUpdated', documentRoot).val(2);

          setTimeout(function() {
              closeOverlayPopup();
              if (!shadowName) {
                location.reload(true);
              }
          }, 2500);
      }
      else {
        txtResult.style.background = "#FFE5E5";
          btnAddReReminder.removeAttr('disabled');
      }
      txtResult.innerHTML = response.message;
    }
  });
}

function btnEditReReReminderFunction(re_reminder) {
    $('#reReminderUpdated', documentRoot).val(1);

    var url = internalAPIReminderEndPoint + 'edit_reminder';

    var txtResult = id("txtAddReReminderResult");
    showHideOverlayLoadingCircle("show");

    var reReminderIdValue = $('#reReminderIdValue', documentRoot).val();
    var reReminderNote = $('#reReminderNote', documentRoot).val();
    var reReminderSendDate = $('#reReminderSendDate', documentRoot).val();
    var reReminderSendDateTz = Intl.DateTimeFormat().resolvedOptions().timeZone;
    var reReminderReferToId = $('#reReminderReferToId', documentRoot).val();
    var reReminderPersonaId = $('#reReminderPersonaId', documentRoot).val();
    var reReminderIncludeMe = ($('#reReminderIncludeMe', documentRoot).is(":checked")) ? 1 : 0;
    var reReminderRepeat = $('input[name="reReminderRepeat"]:checked', documentRoot).val();

    reReminderPersonaId = (reReminderPersonaId !== null && reReminderPersonaId !== "") ? reReminderPersonaId.join(',') : '';

    //Check if reReminderReferToId is disable, to use the hidden value
    if($('#reReminderReferToId', documentRoot).is(':disabled') && $('#reReminderReferToIdHidden', documentRoot).val() !== "") {
      reReminderReferToId = $('#reReminderReferToIdHidden', documentRoot).val();
    }

    var btnEditReReminder = $('#btnEditReReminder', documentRoot);

    $.ajax({
        type:"POST",
        url: url,
        cache: false,
        data: JSON.stringify({
            reReminderId: reReminderIdValue,
            reNote : reReminderNote,
            reSendDate : reReminderSendDate,
            reSendDateTz : reReminderSendDateTz,
            reReferToId : reReminderReferToId,
            rePersonaId : reReminderPersonaId,
            reIncludeMe : reReminderIncludeMe,
            reRepeatYn : reReminderRepeat
        }),
        beforeSend: function(request){
            btnEditReReminder.attr('disabled','disabled');
            request.setRequestHeader("Accept", "application/json");
            request.setRequestHeader("Content-Type", "application/json");
        },
        success: function(response){
            showHideOverlayLoadingCircle("hide");
            if(response.status === "success"){
                txtResult.style.background = "#E2FEE2";
                btnEditReReminder.prop('disabled', true);
                btnEditReReminder.hide();

                $('#reReminderUpdated', documentRoot).val(2);

                setTimeout(function() {
                    closeOverlayPopup();
                    location.reload(true);
                }, 2500);
            }
            else {
            	txtResult.style.background = "#FFE5E5";
                btnEditReReminder.removeAttr('disabled');
            }

            txtResult.innerHTML = response.message;
        }
    });
}

function btnDeleteReReReminderFunction(reReminderId) {

    if(reReminderId !== "" && reReminderId !== null && reReminderId !== undefined ) {
        showHideOverlayLoadingCircle("show");

        var url = internalAPIReminderEndPoint + 'delete_reminder';

		$.ajax({
            type:"POST",
            url: url,
            cache: false,
            data: JSON.stringify( {reReminderId : reReminderId} ),
            beforeSend: function(request){
                request.setRequestHeader("Accept", "application/json");
                request.setRequestHeader("Content-Type", "application/json");
            },
            success: function(response) {
                if(response.status === "success") {
                    showHideOverlayLoadingCircle("hide");
                    var objRow = $('#reReminderRow_' + reReminderId, documentRoot);
					var referToInd = objRow.data('refertoind');
					objRow.remove();

					//check if reservation does not have any more reminders
					if($('#reReminderTableRow tr', documentRoot).length === 0) {
						var strObject = (referToInd == 1) ? "reservation " : "contact";

						$("#reReminderTableRow tbody", documentRoot).append('<tr style="height: 20px;">\n\t\t<td class="bl br bb" colspan="6" align="center">&nbsp;&nbsp;The '+ strObject +' does not have reminders associated with it.</td>\n\t</tr>');
					}

					closeOverlayPopup();
                }
            }
        });
    }
}

function btnStopReReReminderFunction(reReminderId) {
	if(reReminderId !== "" && reReminderId !== null && reReminderId !== undefined ) {
        showHideOverlayLoadingCircle("show");

        var url = internalAPIReminderEndPoint + 'stop_reminder';

		$.ajax({
            type:"POST",
            url: url,
            cache: false,
            data: JSON.stringify( {reReminderId : reReminderId} ),
            beforeSend: function(request){
                request.setRequestHeader("Accept", "application/json");
                request.setRequestHeader("Content-Type", "application/json");
            },
            success: function(response) {
                if(response.status === "success") {
                    showHideOverlayLoadingCircle("hide");
                    var objRow = $('#reReminderRow_' + reReminderId, documentRoot);
					var referToInd = objRow.data('refertoind');
					setTimeout(function() {
						closeOverlayPopup();
						location.reload(true);
					}, 1000);
					}
            }
        });
    }
}

function reReminderCountByRes(reference_ind_type_id, reference_id) {
    var url = internalAPIReminderEndPoint + 'count_reminders';

    var data = false;

    $.ajax({
        type: "POST",
        url: url,
		beforeSend: function(request) {
            request.setRequestHeader("Accept", "application/json");
            request.setRequestHeader("Content-Type", "application/json");
		},
        cache: false,
        async: false,
        data: JSON.stringify({reReminderReferenceId : reference_id, reReminderReferenceTypeInd: reference_ind_type_id} ),
        success: function(response) {
            data = (response.status === "success");
        }
    });

    return data;
}

// .toggle() doesn't work as expected with shadow dom + jquery
function toggle(elementName) {
  var element = id(elementName);
  if (element.style.display === "none" || element.style.display === "") {
    element.style.display = "block";
  } else {
    element.style.display = "none";
  }
}

var rrURL = function() {
  this.fullUrl = window.location.href;
  this.pathName = window.location.pathname;
  this.search = window.location.search;
  this.base = window.location.origin;
  this.noBase = this.fullUrl.replace(this.base, "");
  this.isLegacy = this.noBase.indexOf("reservation.php?") != -1;
  this.searchParams = new URLSearchParams(this.search);
  this.getParameters = function() {
    if (this.isLegacy) {
      var params = [];
      for (let p of this.searchParams) {
        params.push(p[0]);
      }
      return params;
    }
    return this.searchParams;
  }
  this.getJob = function() {
    if (this.isLegacy) {
      return this.getParameters()[0];
    }
    return null;
  }
}

if ( window.Node )
  Node.prototype.removeNode = function( removeChildren ) {
    var self = this;
    if ( Boolean( removeChildren ) )
    {
      return this.parentNode.removeChild( self );
    }
    else
    {
      var range = document.createRange();
      range.selectNodeContents( self );
      return this.parentNode.replaceChild( range.extractContents(), self );       
    }
  }
