/**
 * TableSearch - transform a text input into an as-you-type dynamic search area for a table
 * @param <jQuery text input object> element 
 * @param string tBodyId
 *
 * Requires:
 * 	- jquery
 *
 * Example usage:
 * 		When using both thead and tbody, use the tbody id
 * 		$("#txtMyTextInput").tablesearch("tbyMyTbody");
 * 		or when not, give the table id
 * 		$("#txtMyTextInput").tablesearch("tblMyTable"); 
 */
this.TableSearch = function(element, tBodyId) {
	this.rows = null;
	this.rowsLength = null;
	this.rowsText = null;
	this.elementName = element;
	this.tBodyId = tBodyId;

	this.init = function() {
		var t = this;

		if (document.createStyleSheet) {
			// for ie
			document.createStyleSheet('/resource/Resrequest/Application/public/css/tableSearch.css');
		} else {
			$("head").append($("<link rel='stylesheet' href='/resource/Resrequest/Application/public/css/tableSearch.css' type='text/css' media='screen' />"));
		}

		//define the properties to search on the tableSearch object
		this.rows = document.getElementById(this.tBodyId).getElementsByTagName('TR');
		this.rowsLength = this.rows.length;
		this.rowsText = [];

		//loop through the table and add the data to
		for (var i = 0; i < this.rowsLength; i++) {
			this.rowsText[i] = (this.rows[i].innerText) ? this.rows[i].innerText.toUpperCase() : this.rows[i].textContent.toUpperCase();
		}

		//add appropriate events to the search box
		var searchElement = $("#" + this.elementName);
		searchElement.addClass("txtSearch");
		searchElement.attr("placeholder", "Quick filter");
		searchElement.attr("title", "Quick filter");
		searchElement.keyup(function() {
			t.runSearch();
			if (searchElement.val().length > 0) {
				searchElement.removeClass("txtSearch");
				if ($(".txtSearchClear").length == 0) {
					searchElement.wrap('<span class="txtSearchClear" />').after($('<span/>').click(function() {
						searchElement.val("");
						searchElement.addClass("txtSearch");
						searchElement.unwrap();
						t.runSearch();
					}));
				}
			} else if (!searchElement.hasClass("txtSearch")) {
				searchElement.addClass("txtSearch");
				searchElement.unwrap();
			}
			searchElement.focus();
		});
	}

	//onlys shows the relevant rows as determined by the search string
	this.runSearch = function() {
		//get the search term
		this.term = document.getElementById(element).value.toUpperCase();

		//loop through the rows and hide rows that do not match the search query
		for (var i = 0, row; row = this.rows[i], rowText = this.rowsText[i]; i++) {
			row.style.display = ((rowText.indexOf(this.term) != -1) || this.term === '') ? '' : 'none';
		}
	}

	this.search = function(e) {
		//checks if the user pressed the enter key, and if they did then run the search
		var keycode;
		if (window.event) { keycode = window.event.keyCode; }
		else if (e) { keycode = e.which; }
		else { return false; }
		if (keycode == 13) {
			this.runSearch();
		}
		else { return false; }
	}
}
$.fn.tablesearch = function(tBodyId) {
	var elementName = this.attr("id");
	var periodSearch = new TableSearch(elementName, tBodyId);
	periodSearch.init();
};
