///////////////////////////////////////////////////////////////////////////
// Global variables                                                      //
///////////////////////////////////////////////////////////////////////////
var mode;   // Mode of Main frame (new,edit,display)
allFunctions = ["New","Open","Edit","Save","Delete","Previous","Next","Back","Forward","Refresh","Print","Copy","Paste","Calendar","Report","Res","ResDrop","Contact","ContactDrop","Internet","Home","Help","NewWindow", "Utils","Dashboards"];
accessControlledFunctions = ["New","Edit","Save","Delete"];
defaultButtons = ["Back","Forward","Refresh","Calendar","Internet","Home","Help","NewWindow"];
toolbar = new Object();
enabledButtons = [];				// For pages that don't define this variable
impressedButtons = [];			// For pages that don't define this variable
resDropSelectHideList = [];
contactDropSelectHideList = [];

// This object defines a single toolbar button --------------------------------
function toolbutton(buttonName,imageLocation) {
	// Define properties of a toolbutton -----------------------------------------
	this.name = buttonName;
	this.id = buttonName;
	this.status = "disabled";

	var imgName = buttonName.charAt(0);

	imgName = imgName.toLowerCase();
	imgName = imgName + buttonName.substr(1,buttonName.length);

	this.standardImage = imgName + "_std.png";
	this.disabledImage = imgName + "_grey.png";
	this.impressedImage = imgName + "_down.png";

	if ( imageLocation ) {
		this.location = imageLocation;
	} else {
		this.location = "/resource/Resrequest/Application/public/img/";
	}

	// Set the initial state on the corresponding button ------------------
	$("#button" + this.name + " i", documentRootChildren).addClass("disabled");

	// Define the methods of a toolbutton ----------------------------------------
	// Press the button
	this.press = function(e) {
		if(this.status == "enabled" || this.status == "impressed") {
			buttonPressGeneric(this.name,e);
		}
	}

	// Impress the button
	this.impress = function() {
		if(this.status == "enabled") {
			this.status = "impressed";
		}
		$("#button" + this.name + " i", documentRootChildren).addClass("impressed");
	}

	// Disable the button
	this.disable = function() {
		if ( this.status == "enabled" ) {
			this.status = "disabled";
			$("#button" + this.name + " i", documentRootChildren).addClass("disabled");
		}
	}

	// Enable the button
	this.enable = function() {
		if ( this.status == "disabled" ) {
			this.status = "enabled";
			$("#button" + this.name + " i", documentRootChildren).removeClass("disabled");
		}
	}
}

/////////////////////////////////////////////////////////////
// This function performs all page initialise functions,   //
// and calls the generateCalendar() function.              //
/////////////////////////////////////////////////////////////
function generateToolbar() {
	isToolBarPage == true;
	var e;
	// Create toolbar object (associative array)
	for (var e in allFunctions) {
		toolbar[allFunctions[e]] = new toolbutton(allFunctions[e]);
	}
}

/////////////////////////////////////////////////////////////
// This function disables all buttons based on hidden      //
// fields passed by PHP in format:  pgJob + buttonName     //
/////////////////////////////////////////////////////////////
function disableButtons() {
	for(var e in accessControlledFunctions) {
		var buttonName = accessControlledFunctions[e];
		var allowButton = id("pgJob" + buttonName).value;
		if(allowButton == 1) {
			toolbar[buttonName].enable();
		} else {
			toolbar[buttonName].disable();
		}
	}
}

/////////////////////////////////////////////////////////////
// This function enables buttons in a passed array         //
/////////////////////////////////////////////////////////////
function enableButtons(enabledButtons) {
	if ( !enabledButtons || enabledButtons == "" ) {
		enabledButtons = defaultButtons;
	}

	if ( reportURL != "" ) {
		enabledButtons = enabledButtons.concat("Report");
	}

	if ( lastResIdArray.length > 0 ) {
		enabledButtons = enabledButtons.concat("Res");
	}

	if ( lastResIdArray.length > 1 ) {
		enabledButtons = enabledButtons.concat("ResDrop");
	}

	if ( lastContactIdArray.length > 0 ) {
		enabledButtons = enabledButtons.concat("Contact");
	}

	if ( lastContactIdArray.length > 1 ) {
		enabledButtons = enabledButtons.concat("ContactDrop");
	}

	if ( userName.toLowerCase() == "censysad" ) {
		enabledButtons = enabledButtons.concat("Utils");
		$("#buttonUtils", documentRootChildren).show();
	} else {
		$("#buttonUtils", documentRootChildren).remove();
	}

	for (var e in enabledButtons ) {
		toolbar[enabledButtons[e]].enable();
	}
}

/////////////////////////////////////////////////////////////
// This function impresses all buttons in passed array     //
/////////////////////////////////////////////////////////////
function impressButtons(impressedButtons) {
	// The parameter impressedButtons is nor redundant
	// as the button to impress is implied by the screen
	// mode (new or edit).
	mode = id("mode").value;

	switch(mode) {
		case "new":
			impressedButtons = ["New"];
			break;
		case "edit":
			impressedButtons = ["Edit"];
			break;
	}

	for (var e in impressedButtons) {
		toolbar[impressedButtons[e]].impress();
	}
}

/////////////////////////////////////////////////////////////
// This function impresses all buttons in passed array     //
/////////////////////////////////////////////////////////////
function impressButtonsMode(pageMode) {
	switch (pageMode) {
		case "new":
			toolbar["New"].impress();
			break;
		case "edit":
			toolbar["Edit"].impress();
			break;
	}
}

function buttonPressGeneric(button,e) {
	e = window.event || e;
	// Check for changes on form and ask for save if required
	savePressedButton = button;
	if ( inputchange && (button != "Print" && button != "Copy" && button != "Paste" && button != "Edit" && button != "Delete" && button != "Save" && button != "Help" && button != "Internet") ) {
		openPopup("/resource/Resrequest/Application/public/html/savechanges.htm");
		return 0;
	} else {
		buttonPressGeneric_continue(button,e);
		return true;
	}
}

function buttonPressGeneric_continue(button,e) {
	var is_ie = document.all ? true : false;

	switch (button) {
		case "goToReqReceived":
			window.location = "/reservation.php?650+reqreceived";
			break;
		case "goToWaitlisted":
			window.location = "/reservation.php?650+waitlisted";
			break;
		case "goToModReqReceived":
			window.location = "/reservation.php?650+modReqReceived";
			break;
		case "newContact":
			showContactType();
			break;
		case "Delete":
			openConfirm('Are you sure you want to delete this record?');
			break;
		case "Back":
			backForm = document.createElement("FORM");
			backForm.setAttribute("method","POST");

			if ( is_ie ) {
				backItem = document.createElement("<INPUT TYPE=HIDDEN>");
			} else {
				backItem = document.createElement("INPUT");
				backItem.setAttribute("type","hidden");
			}
			backItem.setAttribute("name","goback");
			backItem.setAttribute("value","true");

			backForm.appendChild(backItem);
      if (shadow) {
        var url = new rrURL();
        var job = url.getJob() !== null ? url.getJob() : "";
        backForm.action = "/reservation.php?"+job;
        if (job === "") {
          preserveItem = document.createElement("INPUT");
          preserveItem.setAttribute("type","hidden");
          preserveItem.setAttribute("name","preserve");
          preserveItem.setAttribute("value","true");
          backForm.appendChild(preserveItem);
        }
      }
			document.body.appendChild(backForm);
			backForm.submit();
			break;
		case "Forward":
			forwardForm = document.createElement("FORM");
			forwardForm.setAttribute("method","POST");
			if ( is_ie ) {
				forwardItem = document.createElement("<INPUT TYPE=HIDDEN>");
			} else {
				forwardItem = document.createElement("INPUT");
				forwardItem.setAttribute("type","hidden");
			}
			forwardItem.setAttribute("name","goforward");
			forwardItem.setAttribute("value","true");

			forwardForm.appendChild(forwardItem);
			document.body.appendChild(forwardForm);
      if (shadow) {
        var url = new rrURL();
        var job = url.getJob() !== null ? url.getJob() : "";
        forwardForm.action = "/reservation.php?" + job;
	  }
	  		if (job === "") {
				window.location = window.location;
			} else {
				forwardForm.submit();
			}
			break;
		case "Refresh":
			window.location = window.location;
			break;
		case "Print":
			printWindow();
			break;
		case "Calendar":
			mainWindowPage = Get_Cookie("mainWindowPage");

			if ( mainWindowPage == "availability_calendar" ) {
				window.location="/reservation.php?20";
			} else if (mainWindowPage == "quick_search") {
				window.location="/reservation.php?693";
			} else if (mainWindowPage == "room_cal") {
				window.location="/reservation.php?234+last";
			} else if (mainWindowPage == "room_module") {
				window.location="/app/rooming";
			} else {
				window.location="/reservation.php?29";
			}
			break;
		case "Report":
      var lastReportForm = document.createElement('form');
      lastReportForm.id = "lastReportForm";
      lastReportForm.method = "post";
      lastReportForm.action = "reservation.php?" + reportJob;
      lastReportForm.innerHTML = "<input type=\"hidden\" name=\"url\" id=\"lastReportURL\" value=\"\"><input type=\"hidden\" name=\"pf_option_id\" id=\"lastReportProfile\" value=\""+reportProfile+"\">";
      if (shadowName) {
        documentRoot.appendChild(lastReportForm);
      } else {
        document.body.appendChild(lastReportForm);
      }
			id("lastReportURL").value = reportURL;
			id("lastReportForm").submit();
			break;
		case "Res":
			window.location = "/reservation.php?" + lastResJobArray[0] + "+" + lastResIdArray[0];
			break;
		case "ResDrop":
			if ( id("lastResList").style.display != "" ) {
				var obj = id("buttonResDrop");
				var count = 0;

				lastResListHTML = "<table border='0' cellspacing='0' cellpadding='0' class='colLt all' width='220' style='table-layout: fixed;'><col width='220'>";

				for ( var count = 0; count < lastResIdArray.length; count++ ) {
					lastResListHTML += "<tr onmouseover='setRowHover(this);' onmouseout='clearRowHover(this);' onclick='window.location=\"reservation.php?"+lastResJobArray[count]+"+"+lastResIdArray[count]+"\"'>";
					lastResListHTML += "<td height='16' class='imgLink' nowrap style=\"width: 215px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;\">&nbsp;" + lastResIdArray[count] + ": " + lastResNameArray[count] + "&nbsp;</td>";
					lastResListHTML += "</tr>";
				}

				lastResListHTML += "</table>";

				id("lastResList").innerHTML = lastResListHTML;
				id("lastResList").style.display = "";
				id("lastResList").style.left = (_getLeft(obj) + obj.offsetWidth - id("lastResList").offsetWidth + 25).toString() + "px";
				id("lastResList").style.top = "110px";

				if ( mnuInitialise == false ) {
					buildSelectArray();
					mnuInitialise = true;
				}

				for ( var count = 0; count < mnuSelectArray.length; count++ ) {
					X1L = parseInt(id("lastResList").style.left,10);
					Y1L = parseInt(id("lastResList").style.top,10);
					X1R = X1L + parseInt(id("lastResList").offsetWidth,10);
					Y1R = Y1L + parseInt(id("lastResList").offsetHeight,10);

					XOverlap = false;
					YOverlap = false;

					if (
							X1L >= mnuSelectArray[count].left &&
							X1L <= mnuSelectArray[count].right
							||
							X1R >= mnuSelectArray[count].left &&
							X1R <= mnuSelectArray[count].right
							||
							X1L <= mnuSelectArray[count].left &&
							X1R >= mnuSelectArray[count].right
					   ) {
						XOverlap = true;
					}

					if(
							Y1L >= mnuSelectArray[count].top &&
							Y1L <= mnuSelectArray[count].bottom
							||
							Y1R >= mnuSelectArray[count].top &&
							Y1R <= mnuSelectArray[count].bottom
							||
							Y1L <= mnuSelectArray[count].top &&
							Y1R >= mnuSelectArray[count].bottom
					  ) {
						YOverlap = true;
					}

					if ( XOverlap && YOverlap && mnuSelectArray[count].element.style.visibility != "hidden" ) {
						mnuSelectArray[count].element.style.visibility = "hidden";
						resDropSelectHideList[resDropSelectHideList.length] = mnuSelectArray[count].element;
					}
				}
				e.cancelBubble = true;
			} else {
				hideLastResList();
			}
      break;
    case "Dashboards":
      window.location = "/reservation.php?9007";
      break;
		case "Contact":
			window.location = "/reservation.php?" + lastContactJobArray[0] + "+" + lastContactIdArray[0];
			break;
		case "ContactDrop":
			if ( id("lastContactList").style.display != "" ) {
				var obj = id("buttonContactDrop");
				var count = 0;

				lastContactListHTML = "<table border='0' cellspacing='0' cellpadding='0' class='colLt all' width='170' style='table-layout: fixed;'><col width='170'>";

				for ( var count = 0; count < lastContactIdArray.length; count++ ) {
					if (lastContactNameArray[count] != "0"){
						lastContactListHTML += "<tr onmouseover='setRowHover(this);' onmouseout='clearRowHover(this);' onclick='window.location=\"reservation.php?"+lastContactJobArray[count]+"+"+lastContactIdArray[count]+"\"'>";
						lastContactListHTML += "<td height='16' class='imgLink' nowrap>&nbsp;" + lastContactNameArray[count] + "&nbsp;</td>";
						lastContactListHTML += "</tr>";
					}

				}

				lastContactListHTML += "</table>";

				id("lastContactList").innerHTML = lastContactListHTML;
				id("lastContactList").style.display = "";
				id("lastContactList").style.left = (_getLeft(obj) + obj.offsetWidth - id("lastContactList").offsetWidth + 25).toString() + "px";
				id("lastContactList").style.top = "110px";

				if ( mnuInitialise == false ) {
					buildSelectArray();
					mnuInitialise = true;
				}

				for ( var count = 0; count < mnuSelectArray.length; count++ ) {
					X1L = parseInt(id("lastContactList").style.left,10);
					Y1L = parseInt(id("lastContactList").style.top,10);
					X1R = X1L + parseInt(id("lastContactList").offsetWidth,10);
					Y1R = Y1L + parseInt(id("lastContactList").offsetHeight,10);

					XOverlap = false;
					YOverlap = false;

					if (
							X1L >= mnuSelectArray[count].left &&
							X1L <= mnuSelectArray[count].right
							||
							X1R >= mnuSelectArray[count].left &&
							X1R <= mnuSelectArray[count].right
							||
							X1L <= mnuSelectArray[count].left &&
							X1R >= mnuSelectArray[count].right
					   ) {
						XOverlap = true;
					}

					if(
							Y1L >= mnuSelectArray[count].top &&
							Y1L <= mnuSelectArray[count].bottom
							||
							Y1R >= mnuSelectArray[count].top &&
							Y1R <= mnuSelectArray[count].bottom
							||
							Y1L <= mnuSelectArray[count].top &&
							Y1R >= mnuSelectArray[count].bottom
					  ) {
						YOverlap = true;
					}

					if ( XOverlap && YOverlap && mnuSelectArray[count].element.style.visibility != "hidden" ) {
						mnuSelectArray[count].element.style.visibility = "hidden";
						contactDropSelectHideList[contactDropSelectHideList.length] = mnuSelectArray[count].element;
					}
				}
				e.cancelBubble = true;
			} else {
				hideLastContactList();
			}
			break;
		case "Internet":
			var new_window = window.open("http://www.resrequest.com","","toolbar=yes,location=yes,directories=yes,menubar=yes,scrollbars=yes,resizable=yes,copyhistory=yes,titlebar=yes,status=yes,fullscreen=yes");
			break;
		case "Home":
			window.location = "/reservation.php?132";
			break;
		case "Copy":
			if(pasteFieldId != false) {
				var pasteFieldPtr = id(pasteFieldId);
				var copy = pasteFieldPtr.createTextRange().execCommand('Copy');
			}
			toolbar["Paste"].enable();
			break;
		case "Paste":
			if(pasteFieldId != false) {
				var pasteFieldPtr = id(pasteFieldId);
				var paste = pasteFieldPtr.createTextRange().execCommand('Paste');
			}
			inputchange = 1;
			break;
		case "Help":
			window.open('/resource/Resrequest/Application/public/html/help/help_frame.htm','Popup_Window','toolbar=no,titlebar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,copyhistory=no,width=690,height=430,top=100,left=100');
			break;
		case "NewWindow":
			newWindow = openPopup("/reservation.php?132",0,0,0,0,1,1,"ResRequestWin" + generateUUID(),false,true);
			newWindow.moveTo(0,0);
			newWindow.resizeTo(screenWidth,screenHeight);
			break;
		case "Logoff":
			logOff();
			break;
		case "Utils":
			window.open("utils/", "_blank");
			break;
		default:
			buttonPress(button);
	}
}

var mainButtonPressGeneric_continue =  buttonPressGeneric_continue;

///////////////////////////////////////////////////////////////////////////
// printWindow() is called when the print toolbar button is called       //
///////////////////////////////////////////////////////////////////////////
function printWindow() {
	window.print();
}

function hideLastResList() {
	var count;
	id("lastResList").style.display = "none";
	for(count=0; count < resDropSelectHideList.length; count++) {
		resDropSelectHideList[count].style.visibility = "visible";
	}
}

function hideLastContactList() {
	var count;
	id("lastContactList").style.display = "none";
	for(count=0; count < contactDropSelectHideList.length; count++) {
		contactDropSelectHideList[count].style.visibility = "visible";
	}
}
