(function(wait) {
	/* private properties */
	var text = "";
	var newText = "Loading, please wait...";
	var div = id("waitDiv");
	var animation = false;
	var animationPosition = 0;
	var animationFPS = 24;
	var keepTrans = false;

	/* private methods */
	var buildDiv = function(mode) {
		if(!div) {
			div = document.createElement("div");
			div.id = "waitDiv";
			div.style.display = "none";
			div.style.position = "absolute";
			div.style.borderWidth = 3;
			div.style.borderColor = "black";
			div.style.zIndex = "1001";
			document.body.appendChild(div);
		}
        if (mode == "circle") {
            div.innerHTML = "<div class='loaderCircle'></div>";
        } else {
			div.innerHTML = "<table class=\"outDk\"><tr><td class=\"uk-padding-small\" style=\"font-size:15; font-weight:bold\"><span id=\"waitText\"></span></td></tr></table>";
        }
	};

	var buildText = function() {
		var newHTML = new String();
		for(var count=0;count<text.length;count++) {
			newHTML += "<span style=\"font-size:15; font-weight:bold;\" id=\"wait" + count.toString() + "\">" + text.substr(count,1) + "</span>";
		}	
		id("waitText").innerHTML = newHTML;
	};

	var animateText = function() {
		var last;

		if(newText != "") {
			animationPosition = 0;
			text = newText;
			newText = "";
			buildText();
			centerDivOnPage("waitDiv");
		}

		if(animationPosition == 0) {
			last = text.length - 1;
		} else {
			last = animationPosition - 1;
		}

		id("wait"+last.toString()).style.color = '#000000';
		id("wait"+animationPosition.toString()).style.color = '#FFFFFF';

		if(animationPosition==(text.length-1)) {
			animationPosition = 0;
		} else {
			animationPosition++;
		}
		if(animation) {
			setTimeout(animateText,1000/animationFPS);
		}
	};

	/* public methods */
	wait.setText = function(sText) {
		newText = sText;
	};

	wait.show = function(mode) {
        if (mode == "circle") {
            buildDiv(mode);
            if(id("trans") && id("trans").style.display != "none") {
                keepTrans = true;
            } else {
                keepTrans = false;
            }
            applyTrans(1,1000);
            centerDivOnPage("waitDiv");
        } else {
            if(animation != true) {
                newText = newText == "" || !newText ? "Loading, please wait..." : newText;
                buildDiv(true);
                if(id("trans") && id("trans").style.display != "none") {
                    keepTrans = true;
                } else {
                    keepTrans = false;
                }
                applyTrans(1,1000);
                centerDivOnPage("waitDiv");
                animation = true;
                animationPosition = 0;
                animateText();
            }
        }
	};

	wait.hide = function() {
		animation = false;
    if (typeof div !== "undefined" && div !== null) {
      div.style.display = "none";
    }
		if(keepTrans) {
			applyTrans(1);
		} else {
			applyTrans(0);
		}
	};

}(window.wait = window.wait || {}));
