<?php
namespace Resrequest\Application\Chart;

class ChartFactory {
    public function getChart(string $type, array $config, array $datasets) {
        $chartTypeClass = $this->getChartType($type);
        // Create instance of chart type class
        $chart = $chartTypeClass($config, $datasets);

        // Return chart with configuration and datasets
        return $chart;
    }

    /**
     * Returns a FusionCharts chart type class
     *
     * @param string $library Chart library
     * @param string $chartType Chart type class to get
     * @return string Chart type class in the form of a string
     */
    public function getChartTypeClass(string $library, string $chartType) {
        $chartType = ucfirst($chartType);
        $chartTypeClass = '\\' . __NAMESPACE__ . '\\' . $library . '\\' . $chartType;

        if (class_exists($chartTypeClass)) {
            return $chartTypeClass;
        } else {
            return false;
        }
    }
}