<?php

namespace Resrequest\Application\Chart\Config;

class InputMapping
{
    /**
     * The name of the input.
     *
     * @var string
     */
    private $name;

    /**
     * The fields to map the input to.
     *
     * @var array
     */
    private $fields;

    /**
     * Create an instance of an input mapping.
     *
     * @param string $name
     * @param array $fields
     */
    public function __construct($name, $fields=[])
    {
        $this->name = $name;
        $this->fields = $fields;
    }

    /**
     * Sets the name of the input field.
     *
     * @param string $name
     * @return InputMapping
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Adds the fields to the input mapping.
     *
     * @param array $fields
     * @return InputMapping
     */
    public function addFields($fields)
    {
        $this->fields = array_merge($this->fields, $fields);
        return $this;
    }

    /**
     * Add a field to the mapping.
     *
     * @param string $field
     * @return InputMapping
     */
    public function addField($field)
    {
        $this->addFields([$field]);
        return $this;
    }

    /**
     * Returns the array representation of the input mapping.
     *
     * @return array
     */
    public function toArray()
    {
        return [
            'name' => $this->name,
            'fields' => $this->fields
        ];
    }
}