<?php

namespace Resrequest\Application\Chart\Config;

class Option
{
    /**
     * The name of the option.
     *
     * @var string
     */
    private $name;

    /**
     * The value of the option.
     *
     * @var mixed
     */
    private $value;

    /**
     * Creates anew instance of the option config builder.
     *
     * @param string $name The name of the option.
     * @param mixed $value The current value of the option.
     */
    public function __construct($name, $value = null)
    {
        $this->name = $name;
        $this->value = $value;
    }

    /**
     * Sets the name of the option.
     *
     * @param string $name
     * @return Option
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Sets the value of the option.
     *
     * @param mixed $value
     * @return Option
     */
    public function setValue($value)
    {
        $this->value = $value;
        return $this;
    }

    /**
     * Returns the array representation of the option.
     *
     * @return array
     */
    public function toArray()
    {
        return [
            'name' => $this->name,
            'value' => $this->value
        ];
    }
}