<?php

namespace Resrequest\Application\Chart\Config;

class OutputMapping
{
    /**
     * The name of the output.
     *
     * @var string
     */
    private $name;

    /**
     * The fields to map to.
     *
     * @var string
     */
    private $field;

    /**
     * Create an instance of an input mapping.
     *
     * @param string $name The name of the output field.
     * @param string $field The field to map to.
     */
    public function __construct($name, $field='')
    {
        $this->name = $name;
        $this->field = $field;
    }

    /**
     * Sets the name of the input field.
     *
     * @param string $name The name of the output.
     * @return OutputMapping
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Set the field the output should be mapped to.
     *
     * @param string $field The field to map to.
     * @return OutputMapping
     */
    public function setField($field)
    {
        $this->field = $field;
        return $this;
    }

    /**
     * Returns the array representation of the input mapping.
     *
     * @return array
     */
    public function toArray()
    {
        return [
            'name' => $this->name,
            'field' => $this->field
        ];
    }
}