<?php

namespace Resrequest\Application\Chart\Config;

class UiConfig
{
    /**
     * The UI sections.
     *
     * @var array
     */
    private $sections;

    public function __construct()
    {
        $this->sections = [];
    }

    /**
     * Adds sections to the UI.
     *
     * @param array $sections
     * @return UiConfig
     */
    public function addSections($sections)
    {
        $this->sections = array_merge($this->sections, $sections);
        return $this;
    }

    /**
     * Adds a section to the ui.
     *
     * @param UiSection $section
     * @return UiConfig
     */
    public function addSection($section)
    {
        $this->addSections([$section]);
        return $this;
    }

    public function toArray()
    {
        $sections = array_map(function ($section) {
            return $section->toArray();
        }, $this->sections);

        return [
            'menu' => $sections
        ];
    }
}