<?php

namespace Resrequest\Application\Chart\Config;

class UiOption
{
    /**
     * The source option id.
     *
     * @var string
     */
    private $source;

    /**
     * The chart the option belongs to.
     * Used in the chart container UI config.
     * 
     * @var string
     */
    private $chartId;

    /**
     * The sub-options to display.
     *
     * @var array
     */
    private $subOptions;

    /**
     * Creates an instance of UiOption.
     *
     * @param string $source The source option id.
     */
    public function __construct($source, $chartId = '')
    {
        $this->source = $source;
        $this->chartId = $source;
        $this->subOptions = [];
    }

    /**
     * Sets the source of the option.
     *
     * @param string $source
     * @return UiOption
     */
    public function setSource($source)
    {
        $this->source = $source;
        return $this;
    }

    /**
     * Sets the cbart ID of the option.
     *
     * @param string $chartId
     * @return UiOption
     */
    public function setChartId($chartId)
    {
        $this->chartId = $chartId;
        return $this;
    }

    /**
     * Adds options to be rendered.
     *
     * @param array $options
     * @return UiOption
     */
    public function addSubOptions($options)
    {
        $this->subOptions = array_merge($this->subOptions, $options);
        return $this;
    }

    /**
     * Adds an option to be rendered.
     *
     * @param UiSubOption $option The name of the sub-option.
     * @return UiOption
     */
    public function addSubOption($option)
    {
        return $this->addSubOptions([$option]);
    }

    /**
     * Returns the array representation of a ui option.
     *
     * @return array
     */
    public function toArray()
    {
        $options = array_map(function ($option) {
            return $option->toArray();
        }, $this->subOptions);

        return [
            'source' => $this->source,
            'config' => [
                'options' => $options
            ]
        ];
    }
}