<?php

namespace Resrequest\Application\Chart\Config;

class UiPage
{
    /**
     * The name of the page.
     *
     * @var string
     */
    private $name;

    /**
     * The sections in the page.
     *
     * @var array
     */
    private $sections;

    /**
     * Create a new ui page.
     *
     * @param string $name
     */
    public function __construct($name)
    {
        $this->name = $name;
        $this->sections = [];
    }

    /**
     * Sets the name of the page.
     *
     * @param string $name
     * @return UiPage
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Adds sections to the page.
     *
     * @param array $sections
     * @return UiPage
     */
    public function addSections($sections)
    {
        $this->sections = array_merge($this->sections, $sections);
        return $this;
    }

    /**
     * Adds a section to the page.
     *
     * @param UiPageSection $section
     * @return UiPage
     */
    public function addSection($section)
    {
        $this->addSections([$section]);
        return $this;
    }

    public function toArray()
    {
        $sections = array_map(function ($section) {
            return $section->toArray();
        }, $this->sections);

        return [
            'name' => $this->name,
            'config' => [
                'sections' => $sections
            ]
        ];
    }

}