<?php

namespace Resrequest\Application\Chart\Config;

class UiPageSection
{
    /**
     * The title for the section.
     *
     * @var string
     */
    private $title;

    /**
     * The options to render in the section.
     *
     * @var array
     */
    private $options;

    /**
     * Creates a new ui page section.
     *
     * @param string $title The title of the section.
     */
    public function __construct($title='')
    {
        $this->title = $title;
        $this->options = [];
    }

    /**
     * Sets the title of the section.
     *
     * @param string $title
     * @return UiPageSection
     */
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }

    /**
     * Adds ui options to the section.
     *
     * @param array $options
     * @return UiPageSection
     */
    public function addOptions($options)
    {
        $this->options = array_merge($this->options, $options);
        return $this;
    }

    /**
     * Adds a ui option to the section.
     *
     * @param UiOption $option
     * @return UiPageSection
     */
    public function addOption($option)
    {
        $this->addOptions([$option]);
        return $this;
    }

    /**
     * Returns the array representation of a ui section.
     *
     * @return array
     */
    public function toArray()
    {
        $options = array_map(function ($option) {
            return $option->toArray();
        }, $this->options);

        return [
            'title' => $this->title,
            'options' => $options
        ];
    }
}