<?php

namespace Resrequest\Application\Chart\Config;

class UiSection
{
    /**
     * The title of the section.
     *
     * @var string
     */
    private $title;

    /**
     * The pages in the section.
     *
     * @var array
     */
    private $pages;

    /**
     * Create a new ui section.
     *
     * @param string $title
     */
    public function __construct($title='')
    {
        $this->title = $title;
        $this->pages = [];
    }

    /**
     * Sets the title for the section.
     *
     * @param string $title
     * @return UiSection
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }

    /**
     * Adds pages to the section.
     *
     * @param array $pages
     * @return UiSection
     */
    public function addPages($pages)
    {
        $this->pages = array_merge($this->pages, $pages);
        return $this;
    }

    /**
     * Adds a page to the section.
     *
     * @param UiPage $page
     * @return UiSection
     */
    public function addPage($page)
    {
        $this->addPages([$page]);
        return $this;
    }

    /**
     * Returns the array representation of a ui section.
     *
     * @return array
     */
    public function toArray()
    {
        $pages = array_map(function ($page) {
            return $page->toArray();
        }, $this->pages);

        return [
            'title' => $this->title,
            'pages' => $pages
        ];
    }
}