<?php

namespace Resrequest\Application\Chart\Config;

class UiSubOption
{
    /**
     * The name of the sub-option.
     *
     * @var string
     */
    protected $name;

    /**
     * The label of the sub-option.
     *
     * @var string
     */
    protected $label;

    /**
     * The sub options that are linked to this one.
     *
     * @var array
     */
    protected $linkedSubOptions;

    /**
     * Constructs a new UiSubOption
     *
     * @param string $name
     * @param string $label
     */
    public function __construct($name, $label='')
    {
        $this->name = $name;
        $this->label = $label;
        $this->linkedSubOptions = [];
    }

    /**
     * Sets the name of the sub option.
     *
     * @param string $name
     * @return UiSubOption
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Sets the name of the sub option.
     *
     * @param string $label
     * @return UiSubOption
     */
    public function setLabel($label)
    {
        $this->label = $label;
        return $this;
    }

    /**
     * Adds linked sub-options.
     *
     * @param array $links
     * @return UiSubOption
     */
    public function addLinkedSubOptions($links)
    {
        $this->linkedSubOptions = array_merge($this->linkedSubOptions, $links);
        return $this;
    }

    /**
     * Add a linked sub-option.
     *
     * @param string $source
     * @param string $optionName
     * @return UiSubOption
     */
    public function addLinkedSubOption($source, $optionName, $chartId = '')
    {
        return $this->addLinkedSubOptions([[
            'chartId' => $chartId,
            'source' => $source,
            'option' => $optionName
        ]]);
    }

    /**
     * Returns the array representation of a UI sub-option.
     *
     * @return array
     */
    public function toArray()
    {
        return [
            'name' => $this->name,
            'label' => $this->label,
            'links' => $this->linkedSubOptions
        ];
    }
}