<?php

namespace Resrequest\Application\Chart;

abstract class Converter extends Process
{
    protected $type = 'converter';

    public function __construct(string $name, array $config = [])
    {
        parent::__construct($name, $config);
        if (empty($this->config['mappings']['inputs'])) {
            throw new \Exception('No input mappings configured for converter');
        }
    }

    protected function processOptions()
    {
        return [];
    }
    
    public function toArray()
    {
        return [
            'name' => $this->name,
            'type' => $this->getSubType(),
            'id' => $this->id,
            'options' => $this->optionsToArray(),
            'mappings' => $this->config['mappings']
        ];
    }
}