<?php

namespace Resrequest\Application\Chart\Converter;

use Resrequest\Application\Chart\Converter;

/**
 * Accumulates the value of a specified field and stores it in  each data element,
 */
class Accumulator extends Converter
{
    protected $subType = 'accumulator';

    const INITIAL_ACCUMULATOR = [
        'results' => [],
        'groups' => [],
    ];

    protected $supportedInputs = [
        'field',
        'groupBy'
    ];

    protected $supportedOutputs = [
        'result'
    ];

    protected function processData($originalData, $extractedData, $accumulator)
    {
        
        if (isset($extractedData['groupBy'])) {
            $groupBy = join('::', ($extractedData['groupBy']));
        } else {
            $groupBy = 'none';
        }

        $amount = $this->getSingleInput($extractedData['field']);

        if (!isset($accumulator['groups'][$groupBy])) {
            $accumulator['groups'][$groupBy] = 0;
        }

        $accumulator['groups'][$groupBy] = $accumulator['groups'][$groupBy] + $amount;

        $accumulator['results'][] = [
            'outputs' => [
                'result' => $accumulator['groups'][$groupBy]
            ],
            'data' => $originalData
        ];

        return $accumulator;
    }

    protected function finaliseData($accumulator)
    {
        return $accumulator['results'];
    }
}
