<?php

namespace Resrequest\Application\Chart\Converter;

use Resrequest\Application\Chart\Converter;

class Addition extends Converter
{
    protected $subType = 'addition';

    const INITIAL_ACCUMULATOR = [
        'results' => []
    ];

    protected $supportedInputs = [
        'additionFields',
    ];

    protected $supportedOutputs = [
        'result'
    ];

    // Add the specified fields together for each element of the dataset
    protected function processData($originalData, $extractedData, $accumulator)
    {
        if (isset($extractedData['additionFields'])) {
            $sum = array_sum($extractedData['additionFields']);
        } else {
            return $accumulator;
        }

        $accumulator['results'][] = [
            'outputs' => [
                'result' => $sum
            ],
            'data' => $originalData
        ];

        return $accumulator;
    }

    protected function finaliseData($accumulator)
    {
        return $accumulator['results'];
    }
}
