<?php

namespace Resrequest\Application\Chart\Converter;

use Resrequest\Application\Chart\Converter;

class AdditionGroup extends Converter
{
    protected $subType = 'additionGroup';

    const INITIAL_ACCUMULATOR = [
        'groups' => []
    ];

    protected $supportedInputs = [
        'groupBy',
        'additionFields'
    ];

    protected $supportedOutputs = [];


    // Calculate the total value of fields across the entire dataset
    protected function processData($originalData, $extractedData, $accumulator)
    {
        $groupBy = join('::', ($extractedData['groupBy']));
        $additionFields = $extractedData['additionFields'];

        if (!isset($accumulator['groups'][$groupBy])) {
            $accumulator['groups'][$groupBy] = $originalData;
            return $accumulator;
        }

        $group = &$accumulator['groups'][$groupBy];

        foreach ($additionFields as $field => $value) {
            if (!isset($group[$field])) {
                $group[$field] = 0;
            }

            $group[$field] += $value;
        }

        return $accumulator;
    }

    protected function finaliseData($accumulator)
    {
        $result = [];
        foreach ($accumulator['groups'] as $group => $data) {
            $result[] = [
                'outputs' => [],
                'data' => $data
            ];
        }

        return $result;
    }
}
