<?php

namespace Resrequest\Application\Chart\Converter;

use Resrequest\Application\Chart\Converter;

class DatasetRange extends Converter
{
    protected $subType = 'datasetRange';

    const INITIAL_ACCUMULATOR = [
        'results' => [],
        'maximum' => 0,
        'minimum' => 0,
    ];

    protected $supportedInputs = [
        'field',
    ];

    protected $supportedOutputs = [
        'maximum',
        'minimum',
        'range'
    ];

    protected function processData($originalData, $extractedData, $accumulator)
    {
        $field = $this->getSingleInput($extractedData['field']);

        if ($field > $accumulator['maximum']) {
             $accumulator['maximum'] = $field;
        }
        if ($field < $accumulator['minimum']) {
            $accumulator['minimum'] = $field;
        }

        $accumulator['results'][] = [
            'outputs' => [],
            'data' => $originalData
        ];

        return $accumulator;
    }

    protected function finaliseData($accumulator)
    {
        $range = $accumulator['maximum'] - $accumulator['minimum'];

        foreach ($accumulator['results'] as &$result) {
            $result['outputs']['maximum'] = $accumulator['maximum'];
            $result['outputs']['minimum'] = $accumulator['minimum'];
            $result['outputs']['range'] = $range;
        }

        return $accumulator['results'];
    }
}
