<?php

namespace Resrequest\Application\Chart\Converter;

use Resrequest\Application\Chart\Converter;
use Resrequest\Application\Chart\Input;
use Resrequest\Application\Chart\Option;

class DateFormat extends Converter
{
    protected $subType = 'dateFormat';

    const INITIAL_ACCUMULATOR = [
        'results' => [],
        'total' => 0
    ];

    protected $supportedInputs = [
        'date',
    ];

    protected $supportedOutputs = [
        'date'
    ];

    public function generateOptions() {
        return [
            new Option('format', new Input('Y-m-d'))
        ];
    }

    // Calculate the total value of fields across the entire dataset
    protected function processData($originalData, $extractedData, $accumulator)
    {
        $date = $this->getSingleInput($extractedData['date']);
        $accumulator['results'][] = [
            'outputs' => [
                'date' => $date
            ],
            'data' => $originalData
        ];

        return $accumulator;
    }

    protected function finaliseData($accumulator)
    {
        $format = $this->optionByName('format')->input->getValue();

        foreach ($accumulator['results'] as &$result) {
            $date = new \DateTime($result['outputs']['date']);
            $dateString = $date->format($format);
            $result['outputs']['date'] = $dateString;
        }
        return $accumulator['results'];
    }
}
