<?php

namespace Resrequest\Application\Chart\Converter;

use Resrequest\Application\Chart\Converter;
use Resrequest\Application\Chart\Input;
use Resrequest\Application\Chart\Option;

class MathExpression extends Converter
{
    protected $subType = 'mathExpression';

    const INITIAL_ACCUMULATOR = [
        'results' => []
    ];

    protected $supportedInputs = [
        'expressionFields',
    ];

    protected $supportedOutputs = [
        'result'
    ];


    protected function generateOptions() {
        return [
            new Option('expression', new Input())
        ];
    }

    protected function processData($originalData, $extractedData, $accumulator)
    {
        $validOperators = [
            '+',
            '/',
            '-',
            '*',
            '**',
            '%',
            '(',
            ')'
        ];

        $expressions = $this->optionByName('expression')->getValue();
        // Build expression from array
        $expressionString = '';
        $isValidExpression = true;

        foreach ($expressions as $item) {
            // Item is a reference to field in dataset
            if (array_key_exists($item, $extractedData['expressionFields'])) {
                $item = $extractedData['expressionFields'][$item];
            } else if (!(is_numeric($item) || in_array($item, $validOperators))) {
                $isValidExpression = false;
                break;
            }

            $expressionString .= $item;
        }

        if ($isValidExpression) {
            $result = null;
            eval('$result = ' . $expressionString . ';');

            $accumulator['results'][] = [
                'outputs' => [
                    'result' => $result
                ],
                'data' => $originalData
            ];
        } else {
            throw new \Exception("Invalid math expression");
        }

        return $accumulator;
    }

    protected function finaliseData($accumulator)
    {
        return $accumulator['results'];
    }
}
