<?php

namespace Resrequest\Application\Chart\Converter;

use Resrequest\Application\Chart\Converter;
use Resrequest\Application\Chart\Input;
use Resrequest\Application\Chart\Option;

class Max extends Converter
{
    protected $subType = 'max';

    const INITIAL_ACCUMULATOR = [
        'results' => []
    ];

    protected $supportedInputs = [
        'maxFields',
    ];

    protected $supportedOutputs = [
        'result'
    ];


    protected function generateOptions()
    {
        return [
            new Option('constants', new Input())
        ];
    }

    protected function processData($originalData, $extractedData, $accumulator)
    {
        $constants = $this->optionByName('constants')->getValue();
        $maxFields = array_values($extractedData['maxFields']);
        $values = array_merge($constants, $maxFields);
        
        $max = max($values);
       
        $accumulator['results'][] = [
            'outputs' => [
                'result' => $max
            ],
            'data' => $originalData
        ];

        return $accumulator;
    }

    protected function finaliseData($accumulator)
    {
        return $accumulator['results'];
    }
}
