<?php

namespace Resrequest\Application\Chart\Converter;

use Resrequest\Application\Chart\Converter;
use Resrequest\Application\Chart\Input;
use Resrequest\Application\Chart\Option;

class Percentage extends Converter
{
    protected $subType = 'percentage';

    const INITIAL_ACCUMULATOR = [
        'results' => [],
    ];

    protected $supportedInputs = [
        'numerator',
        'denominator'
    ];

    protected $supportedOutputs = [
        'result'
    ];

    protected function generateOptions() {
        return [];
    }

    // Calculate the total value of fields across the entire dataset
    protected function processData($originalData, $extractedData, $accumulator)
    {
        $numerator = $this->getSingleInput($extractedData['numerator']);
        $denominator = $this->getSingleInput($extractedData['denominator']);

        if ($denominator != 0) {
            $percentage = ($numerator / $denominator) * 100;
        } else {
            $percentage = 0;
        }

        $accumulator['results'][] = [
            'outputs' => ['result' => $percentage],
            'data' => $originalData
        ];

        return $accumulator;
    }

    protected function finaliseData($accumulator)
    {
        return $accumulator['results'];
    }
}
