<?php

namespace Resrequest\Application\Chart\Converter;

use Resrequest\Application\Chart\Converter;
use Resrequest\Application\Chart\Input;
use Resrequest\Application\Chart\Option;

class Round extends Converter
{
    protected $subType = 'round';

    const INITIAL_ACCUMULATOR = [
        'results' => [],
    ];

    protected $supportedInputs = [
        'field',
    ];

    protected $supportedOutputs = [
        'result'
    ];

    protected function generateOptions() {
        return [
            new Option('precision', new Input(2)),
            new Option('mode', new Input('PHP_ROUND_HALF_UP'))
        ];
    }

    // Calculate the total value of fields across the entire dataset
    protected function processData($originalData, $extractedData, $accumulator)
    {
        $precision = $this->optionByName('precision')->getValue();
        $mode = constant($this->optionByName('mode')->getValue());

        $field = $this->getSingleInput($extractedData['field']);
        $result = round($field, $precision, $mode);

        $accumulator['results'][] = [
            'outputs' => ['result' => $result],
            'data' => $originalData
        ];

        return $accumulator;
    }

    protected function finaliseData($accumulator)
    {
        return $accumulator['results'];
    }
}
