<?php

namespace Resrequest\Application\Chart\Converter;

use Resrequest\Application\Chart\Converter;

class SortBy extends Converter
{
    protected $subType = 'sortBy';

    const INITIAL_ACCUMULATOR = [
        'data' => [],
    ];

    protected $supportedInputs = [
        'sortBy'
    ];

    protected $supportedOutputs = [];

    // Add the specified fields together for each element of the dataset
    protected function processData($originalData, $extractedData, $accumulator)
    {
        
        if (!isset($accumulator['sortBy'])) {
            foreach ($extractedData['sortBy'] as $key => $value) {
                $accumulator['sortBy'] = $key;
            }
        }

        $accumulator['data'][] = $originalData;

        return $accumulator;
    }

    protected function finaliseData($accumulator)
    {
        if (!isset($accumulator['sortBy'])) {
            return [];
        }

        $sortData = array_column($accumulator['data'], $accumulator['sortBy']);
        asort($sortData);
        $sortedKeys = array_keys($sortData);

        $results = [];
        foreach ($sortedKeys as $key) {
            $results[] = [
                'outputs' => [],
                'data' => $accumulator['data'][$key]
            ];
        }

        return $results;
    }
}
