<?php

namespace Resrequest\Application\Chart\Converter;

use Resrequest\Application\Chart\Converter;
use Resrequest\Application\Chart\Input;
use Resrequest\Application\Chart\Option;

class Template extends Converter
{
    protected $subType = 'template';

    const INITIAL_ACCUMULATOR = [
        'results' => []
    ];

    protected $supportedInputs = [
        'template',
        'templateFields'
    ];

    protected $supportedOutputs = ['result'];

    public function generateOptions() {
        return [
            new Option('template', new Input(false))
        ];
    }

    protected function processData($originalData, $extractedData, $accumulator)
    {
        $template = $this->optionByName('template')->input->getValue();
        if ($template === false) {
            $template = $this->getSingleInput($extractedData['template']);
        }

        $result = preg_replace_callback('{{[\S]+}}', function($matches) use ($extractedData) {
            foreach ($matches as $match) {
                $field = substr($match, 2, -2);

                if (isset($extractedData['templateFields'][$field])) {
                    return $extractedData['templateFields'][$field];
                } else {
                    return 'Invalid field';
                }
            }
        }, $template);

        $accumulator['results'][] = [
            'outputs' => [
                'result' => $result
            ],
            'data' => $originalData
        ];
        

        return $accumulator;
    }

    protected function finaliseData($accumulator)
    {
        return $accumulator['results'];
    }
}
