<?php

namespace Resrequest\Application\Chart\Converter;

use Resrequest\Application\Chart\Converter;

class Total extends Converter
{
    protected $subType = 'total';

    const INITIAL_ACCUMULATOR = [
        'results' => [],
        'total' => 0
    ];

    protected $supportedInputs = [
        'totalFields',
    ];

    protected $supportedOutputs = [
        'result'
    ];


    // Calculate the total value of fields across the entire dataset
    protected function processData($originalData, $extractedData, $accumulator)
    {
        $accumulator['total'] += array_sum($extractedData['totalFields']);

        $accumulator['results'][] = [
            'outputs' => [],
            'data' => $originalData
        ];

        return $accumulator;
    }

    protected function finaliseData($accumulator)
    {
        foreach ($accumulator['results'] as &$result) {
            $result['outputs']['result'] = $accumulator['total'];
        }

        return $accumulator['results'];
    }
}
