<?php

namespace Resrequest\Application\Chart;

use Resrequest\Application\Chart\Process;

class DatasetOption extends Process
{
    protected $name;
    protected $type = 'data';
    protected $subType = 'generic';

    public function __construct($name, $options = [])
    {
        $this->options = $options;

        parent::__construct($name);
    }

    public function getOptionByName($name)
    {
        foreach ($this->options as $option) {
            if ($name == $option->getName()) {
                return $option;
            }
        }

        throw new \Exception("Option '$name' does not exist in dataset option '$this->name'");
    }

    protected function addSupportedOutputs()
    {
        foreach ($this->options as $option) {
            $this->supportedOutputs[] = $option->getName();
        }
    }

    public function update(array $config)
    {
        parent::update($config);
        foreach ($this->supportedOutputs as $output) {
            $this->outputs[$output] = $output;
        }
    }

    public function generateOptions() {
        if (empty($this->supportedOutputs)) {
            $this->addSupportedOutputs();
        }
        
        return $this->options;
    }

    protected function processOptions()
    {
        $value = [];

        foreach ($this->options as $option) {
            $value[$option->getName()] = $option->getValue();
        }

        return $value;
    }

    protected function finaliseData($accumulator)
    {
        return [
            [
                'outputs' => $this->optionsValue,
                'data' => []
            ]
        ];
    }

    public function toArray()
    {
        return [
            'name' => $this->name,
            'type' => $this->getSubType(),
            'id' => $this->id,
            'options' => $this->optionsToArray()
        ];
    }
}
