<?php

namespace Resrequest\Application\Chart;

use Resrequest\Application\Chart\Process;

abstract class Filter extends Process
{
    protected $type = 'filter';

    protected function finaliseData($accumulator)
    {
        return [
            [
                'outputs' => $this->optionsValue,
                'data' => []
            ]
        ];
    }

    public function update(array $config)
    {
        parent::update($config);
        foreach ($this->supportedOutputs as $output) {
            $this->outputs[$output] = $output;
        }
    }

    public function toArray()
    {
        return [
            'name' => $this->name,
            'type' => $this->getSubType(),
            'id' => $this->id,
            'options' => $this->optionsToArray()
        ];
    }
}
