<?php

namespace Resrequest\Application\Chart\Filter;

use Resrequest\Application\Chart\Filter;
use Resrequest\Application\Chart\Input\Date as DateInput;
use Resrequest\Application\Chart\Option;

class Date extends Filter
{
    protected $supportedOutputs = [
        'date',
    ];

    protected function generateOptions()
    {
        return [
            new Option('date', new DateInput('today')),
        ];
    }

    protected function processOptions()
    {
        $dateOption = $this->optionByName('date');
        $date = $dateOption->getValue();
        $date = new \DateTime($date);
        $date = $date->format('Y-m-d');

        return ['date' => $date];
    }
}
