<?php

namespace Resrequest\Application\Chart\Filter;

use Resrequest\Application\Chart\Filter;
use Resrequest\Application\Chart\Input\DateRange as DateRangeInput;
use Resrequest\Application\Chart\Option;

class DateRange extends Filter
{
    protected $supportedOutputs = [
        'startDate',
        'endDate'
    ];

    protected function generateOptions()
    {
        return [
            new Option('dateRange', new DateRangeInput('yesterday', 'today')),
        ];
    }

    protected function processOptions()
    {
        $dateRangeOption = $this->optionByName('dateRange');
        $dateRange = $dateRangeOption->getValue();
        
        $startDate = new \DateTime($dateRange['startDate']);
        $endDate = new \DateTime($dateRange['endDate']);

        $date = [];
        $date['startDate'] = $startDate->format('Y-m-d');
        $date['endDate'] = $endDate->format('Y-m-d');

        return $date;
    }
}
