<?php

namespace Resrequest\Application\Chart\Filter;

use Resrequest\Application\Chart\Filter;
use Resrequest\Application\Chart\Input\MultiSelect;
use Resrequest\Application\Chart\Option;
use Resrequest\Application\Chart\Input\Select\SelectOption;

class RateComponent extends Filter
{
    protected $supportedOutputs = [
        'selectedComponents'
    ];

    protected function generateOptions()
    {
        $componentsQuery = $this->em->createQueryBuilder();

        $components = $componentsQuery
            ->select(
                [
                    'comp.rtComponentIx as id',
                    'comp.rtComponentDesc as description',
                    'comp.rtComponentInactiveYn as inactive',
                ]
            )
            ->from('Resrequest\DB\Enterprise\Entity\RtComponent', 'comp')
            ->addOrderBy('description', 'ASC')
            ->getQuery()
            ->getResult();
        
        $value = [];
        $options = [];
        foreach ($components as $component) {
            $value[] = $component['id'];
            $options[] = new SelectOption($component['description'], $component['id'], boolval($component['inactive']));
        }

        $multiSelect = new MultiSelect('Rate component', true, 'Search rate components');
        $multiSelect->setOptions($options);
        $multiSelect->setValue($value);

        return [
            new Option('components', $multiSelect)
        ];
    }

    protected function processOptions()
    {
        $componentOption = $this->optionByName('components');
        $selectedComponents = $componentOption->getValue();

        return ['selectedComponents' => $selectedComponents];
    }
}
