<?php

namespace Resrequest\Application\Chart\Filter;

use Resrequest\Application\Chart\Filter;
use Resrequest\Application\Chart\Input\MultiSelect;
use Resrequest\Application\Chart\Option;
use Resrequest\Application\Chart\Input\Select\SelectOption;

class RateType extends Filter
{
    protected $supportedOutputs = [
        'selectedRateTypes'
    ];

    protected function generateOptions()
    {
        $ratesQuery = $this->em->createQueryBuilder();

        $rates = $ratesQuery
            ->select(
                [
                    'rate.rtRateTypeIx as id',
                    'rate.rtRateTypeDesc as description',
                    'rate.rtRateTypeInactiveYn as inactive',
                ]
            )
            ->from('Resrequest\DB\Enterprise\Entity\RtRateType', 'rate')
            ->addOrderBy('description', 'ASC')
            ->getQuery()
            ->getResult();
        
        $value = [];
        $options = [];
        foreach ($rates as $rate) {
            $value[] = $rate['id'];
            $options[] = new SelectOption($rate['description'], $rate['id'], boolval($rate['inactive']));
        }

        $multiSelect = new MultiSelect('Rate types', true, 'Search rate types');
        $multiSelect->setOptions($options);
        $multiSelect->setValue($value);

        return [
            new Option('rates', $multiSelect)
        ];
    }

    protected function processOptions()
    {
        $rateOption = $this->optionByName('rates');
        $selectedRates = $rateOption->getValue();

        return ['selectedRateTypes' => $selectedRates];
    }
}
