<?php

namespace Resrequest\Application\Chart\Filter;

use Resrequest\Application\Chart\Filter;
use Resrequest\Application\Chart\Input\MultiSelect;
use Resrequest\Application\Chart\Option;
use Resrequest\Application\Chart\Input\Select\SelectOption;

class ReservationStatus extends Filter
{
    protected $supportedOutputs = [
        'selectedStatuses',
        'provisionalFilter'
    ];

    private $disableProvisionalExpired = false;
    private $enableInProgress = false;

    protected function generateOptions()
    {
        $this->availableStatuses = [
            new SelectOption('Cancelled', 'cancelled', false),
            new SelectOption('Confirmed', 'confirmed', false),
            new SelectOption('Deleted', 'deleted', false),
        ];

        if ($this->enableInProgress) {
            $this->availableStatuses[] = new SelectOption('In progress', 'inProgress', false);
        }
        if (!$this->disableProvisionalExpired) {
            $this->availableStatuses[] = new SelectOption('Provisional (expired)', 'provisionalExpired', false);
        }

        $this->availableStatuses[] = new SelectOption('Provisional (valid)', 'provisionalValid', false);
        $this->availableStatuses[] = new SelectOption('Quotation', 'quotation', false);
        $this->availableStatuses[] = new SelectOption('Waitlisted', 'waitlisted', false);



        $multiSelect = new MultiSelect('Reservation status', false, '', $this->availableStatuses, true);
        $multiSelect->setValue([
            'confirmed',
            'provisionalValid',
        ]);

        return [
            new Option('reservationStatuses', $multiSelect)
        ];
    }

    public function disableProvisionalExpired() {
        $this->disableProvisionalExpired = true;
        $this->options = $this->generateOptions();

        return $this;
    }

    public function enableInProgress() {
        $this->enableInProgress = true;
        $this->options = $this->generateOptions();

        return $this;
    }

    protected function processOptions()
    {
        $statusIds = [
            'cancelled' => 90,
            'confirmed' => 30,
            'deleted' => 95,
            'inProgress' => 25,
            'provisionalValid' => 20,
            'provisionalExpired' => 20,
            'quotation' => 0,
            'waitlisted' => 10,
        ];

        $statusesOption = $this->optionByName('reservationStatuses');
        $statusesInput = $statusesOption->input;
        $selectedStatuses = $statusesInput->getValue();

        $selectedStatusesValue = [];

        foreach ($selectedStatuses as $status) {
            $selectedStatusesValue[] = $statusIds[$status];
        }

        $provisionalFilter = [];
        if (in_array('provisionalExpired', $selectedStatuses)) {
            $provisionalFilter[] = false; // Invalid provisional
        }

        if (in_array('provisionalValid', $selectedStatuses)) {
            $provisionalFilter[] = true; // Valid provisional
        }

        return [
            'selectedStatuses' => $selectedStatusesValue,
            'provisionalFilter' => $provisionalFilter,
        ];
    }
}
