<?php

namespace Resrequest\Application\Chart\FusionCharts;

use Resrequest\Application\Chart\Chart;

class AngularGauge extends Chart
{
    public $library = "FusionCharts";
    public $type = "angularGauge";

    protected $accumulator = [
        'dials' => []
    ];

    public function processData($accumulator, $data, $mapping)
    {
        if (empty($data)) {
            return $accumulator;
        }

        $dials = &$accumulator['dials'];

        foreach($mapping['dials'] as $dialMapping) {
            $dials[] = ['value' => $data[0][$dialMapping['value']]];
        }

        return $accumulator;
    }

    public function finaliseData($processedData)
    {
        $dataStructure = [
            'dials' => [
                'dial' => []
            ]
        ];

        $maxValue = 0;
        foreach($processedData['dials'] as $dial) {
            if ($dial['value'] > $maxValue) {
                $maxValue = $dial['value'];
            }
        }

        $dataStructure['dials']['dial'] = $processedData['dials'];

        $libraryConfig = &$this->config['library'];

        // If a max limit for the chart hasn't been specified
        // determine it automatically
        if (empty($libraryConfig['chart']['upperlimit'])) {
            $libraryConfig['chart']['upperlimit'] = $maxValue;
        }

        $upperLimit = $libraryConfig['chart']['upperlimit'];

        // If a colour range has min and maxvalues specified in percentage
        // calculate the values from the charts max limit
        if (!empty($libraryConfig['colorrange']['color'])) {
            foreach ($libraryConfig['colorrange']['color'] as &$color) {
                // Check if value is a percentage. Decimals allowed
                if (preg_match('/^\d+(?:\.\d+)?%$/', $color['minvalue'])) {
                    $color['minvalue'] = ($color['minvalue'] / 100) * $upperLimit;
                }
                if (preg_match('/^\d+(?:\.\d+)?%$/', $color['maxvalue'])) {
                    $color['maxvalue'] = ($color['maxvalue'] / 100) * $upperLimit;
                }
            }
        } 

        return $dataStructure;
    }

    public function validateData($accumulator)
    {
        $valid = false;

        if (empty($accumulator['dials'])) {
            $valid = false;
        } else {
            foreach ($accumulator['dials'] as $dial) {
                if (isset($dial['value'])) {
                    $valid = true;
                    break;
                }
            }
        }

        return $valid;
    }
}
